/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin.customizer;

import org.glassfish.embeddable.CommandRunner;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.paas.gfplugin.GlassFishPluginConstants;
import org.glassfish.paas.gfplugin.GlassFishProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.virtualization.runtime.VirtualClusters;
import org.glassfish.virtualization.spi.VirtualCluster;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;

@Service
@Scoped(value=Singleton.class)
public class LocalInstanceProvisioner
implements GlassFishPluginConstants {
    @Inject(optional=true)
    private VirtualClusters virtualClusters;

    public void provision(GlassFishProvisionedService das, ProvisionedService ... instances) {
        CommandRunner cr = null;
        try {
            cr = das.getProvisionedGlassFish().getCommandRunner();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String clusterName = das.getServiceDescription().getVirtualClusterName();
        VirtualCluster virtualCluster = null;
        try {
            virtualCluster = this.virtualClusters.byName(clusterName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        for (ProvisionedService instance : instances) {
            String vmId = instance.getServiceProperties().getProperty("vm-id");
            VirtualMachine vm = virtualCluster.vmByName(vmId);
            String instanceName = vm.getName();
            cr.run("create-local-instance", new String[]{"--cluster=" + clusterName, instanceName});
            cr.run("start-local-instance", new String[]{instanceName});
        }
    }
}

