/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin.customizer;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.paas.gfplugin.GlassFishPluginConstants;
import org.glassfish.paas.gfplugin.GlassFishProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.spe.common.BasicProvisionedService;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;

@Service
@Scoped(value=Singleton.class)
public class RemoteInstanceProvisioner
implements GlassFishPluginConstants {
    public void provision(GlassFishProvisionedService das, ProvisionedService ... instances) {
        String sshUser;
        String sshPassword = sshUser = das.getVM().getConfig().getTemplate().getUser().getName();
        String passwordFile = this.createPasswordFile(sshPassword);
        CommandRunner cr = null;
        try {
            cr = das.getProvisionedGlassFish().getCommandRunner();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        for (ProvisionedService instance : instances) {
            VirtualMachine vm = ((BasicProvisionedService)instance).getVM();
            cr.run("setup-ssh", new String[]{"--interactive=false", "--passwordfile=" + passwordFile, "--sshuser=" + sshUser, "--generatekey=true", vm.getAddress().getHostAddress()});
            cr.run("create-node-ssh", new String[]{"--nodehost=" + vm.getAddress().getHostAddress(), "--sshuser=" + sshUser, "--installdir=" + vm.getProperty(VirtualMachine.PropertyName.INSTALL_DIR), this.getNodeName(vm)});
            cr.run("create-instance", new String[]{"--node=" + this.getNodeName(vm), "--cluster=" + instance.getServiceDescription().getVirtualClusterName(), this.getInstanceName(vm)});
            cr.run("start-instance", new String[]{this.getInstanceName(vm)});
        }
    }

    private String getNodeName(VirtualMachine virtualMachine) {
        String machineName = virtualMachine.getMachine() != null ? virtualMachine.getMachine().getName() : virtualMachine.getServerPool().getConfig().getVirtualization().getName();
        String[] args = new String[]{virtualMachine.getServerPool().getName(), machineName, virtualMachine.getName()};
        return NODE_NAME_FORMAT.format(args).toString();
    }

    private String getInstanceName(VirtualMachine virtualMachine) {
        String machineName = virtualMachine.getMachine() != null ? virtualMachine.getMachine().getName() : virtualMachine.getServerPool().getConfig().getVirtualization().getName();
        String[] args = new String[]{virtualMachine.getServerPool().getName(), machineName, virtualMachine.getName()};
        return INSTANCE_NAME_FORMAT.format(args).toString();
    }

    private String createPasswordFile(String sshPassword) {
        OutputStreamWriter fw = null;
        try {
            File passFile = File.createTempFile("asadmin", "passwd");
            passFile.deleteOnExit();
            fw = new FileWriter(passFile);
            fw.write("AS_ADMIN_SSHPASSWORD=" + sshPassword + "\n");
            fw.flush();
            fw.close();
            String string = passFile.getAbsolutePath();
            return string;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception ex) {}
            }
        }
    }
}

