/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.mq;

import com.sun.enterprise.util.ExecException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ProcessExecutor;
import java.io.File;
import java.io.FileWriter;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.virtualization.spi.TemplateCustomizer;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualCluster;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="Native-MQ")
public class MQNativeTemplateCustomizer
implements TemplateCustomizer {
    @Inject
    private ServerContext serverContext;

    public void customize(VirtualCluster cluster, VirtualMachine virtualMachine) throws VirtException {
    }

    public void start(VirtualMachine virtualMachine, boolean firstStart) {
        FileWriter fw = null;
        final String fileName = System.getProperty("java.io.tmpdir") + File.separator + "mq.plugin.broker.password.txt";
        this.generateMQAdminPasswordFile(fw, fileName);
        String[] startBrokerArgs = new String[]{this.serverContext.getInstallRoot().getAbsolutePath() + File.separator + ".." + File.separator + "mq" + File.separator + "bin" + File.separator + "imqbrokerd" + (OS.isWindows() ? ".bat" : ""), "-passfile", fileName, "-port", "26767", "-force", "-name", "mq-service-broker"};
        final ProcessExecutor startBroker = new ProcessExecutor(startBrokerArgs);
        try {
            Thread myThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        String[] output = startBroker.execute(true);
                        System.out.println(output);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        MQNativeTemplateCustomizer.this.deleteMQPasswordFile(fileName);
                    }
                }
            };
            myThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteMQPasswordFile(String fileName) {
        try {
            File file = new File(fileName);
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(VirtualMachine virtualMachine) {
        FileWriter fw = null;
        String fileName = System.getProperty("java.io.tmpdir") + File.separator + "mq.plugin.broker.password.txt";
        this.generateMQAdminPasswordFile(fw, fileName);
        String[] stopBrokerArgs = new String[]{this.serverContext.getInstallRoot().getAbsolutePath() + File.separator + ".." + File.separator + "mq" + File.separator + "bin" + File.separator + "imqcmd" + (OS.isWindows() ? ".bat" : ""), "shutdown", "bkr", "-u", "admin", "-f", "-passfile", fileName, "-b", "localhost:26767"};
        ProcessExecutor stopBroker = new ProcessExecutor(stopBrokerArgs);
        try {
            stopBroker.execute();
        }
        catch (ExecException e) {
            e.printStackTrace();
        }
        finally {
            this.deleteMQPasswordFile(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMQAdminPasswordFile(FileWriter fw, String fileName) {
        try {
            File file = new File(fileName);
            file.deleteOnExit();
            fw = new FileWriter(file);
            fw.write("imq.imqcmd.password=admin");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void clean(VirtualMachine virtualMachine) {
    }
}

