/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.mq;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.javaee.core.deployment.DolProvider;
import org.glassfish.javaee.core.deployment.JavaEEDeploymentUtils;
import org.glassfish.paas.gfplugin.GlassFishProvisionedService;
import org.glassfish.paas.mq.Constants;
import org.glassfish.paas.mq.logger.MQServicePluginLogger;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.ServiceOrchestrator;
import org.glassfish.paas.orchestrator.provisioning.ServiceInfo;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.service.MQServiceType;
import org.glassfish.paas.orchestrator.service.metadata.Property;
import org.glassfish.paas.orchestrator.service.metadata.ServiceCharacteristics;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceReference;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServiceProvisioningException;
import org.glassfish.paas.spe.common.BasicProvisionedService;
import org.glassfish.paas.spe.common.ServiceProvisioningEngineBase;
import org.glassfish.virtualization.spi.AllocationStrategy;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scoped(value=PerLookup.class)
@Service
public class MQServicePlugin
extends ServiceProvisioningEngineBase<MQServiceType> {
    @Inject
    private ServiceUtil serviceUtil;
    @Inject
    private Habitat habitat;
    @Inject
    private ApplicationFactory applicationFactory;
    @Inject
    private DolProvider dolProvider;

    public MQServiceType getServiceType() {
        return new MQServiceType();
    }

    public boolean handles(ReadableArchive cloudArchive) {
        return true;
    }

    public boolean handles(ServiceDescription serviceDescription) {
        return false;
    }

    public boolean isReferenceTypeSupported(String referenceType) {
        return Constants.serviceReferenceTypes.contains(referenceType);
    }

    public Set getServiceReferences(String appName, ReadableArchive cloudArchive, PaaSDeploymentContext dc) {
        LinkedHashSet<ServiceReference> serviceReferences = new LinkedHashSet<ServiceReference>();
        if (this.discoverServiceReferences(cloudArchive).size() > 0) {
            serviceReferences.add(new ServiceReference(cloudArchive.getName(), "JavaEE", null));
        }
        return serviceReferences;
    }

    public ServiceDescription getDefaultServiceDescription(String appName, ServiceReference svcRef) {
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(new Property("service-type", "MQ"));
        ServiceCharacteristics serviceCharacteristics = new ServiceCharacteristics(properties);
        ArrayList configurations = new ArrayList();
        return new ServiceDescription("default-mq-service", appName, null, (Object)serviceCharacteristics, configurations);
    }

    private Set<ServiceReference> discoverServiceReferences(ReadableArchive cloudArchive) {
        HashSet<ServiceReference> serviceReferences = new HashSet<ServiceReference>();
        Application application = null;
        try {
            application = this.dolProvider.processDeploymentMetaData(cloudArchive);
        }
        catch (Exception ex) {
            MQServicePluginLogger.getLogger().log(Level.INFO, "exception", ex);
        }
        if (!JavaEEDeploymentUtils.isJavaEE((ReadableArchive)cloudArchive, (Habitat)this.habitat)) {
            return serviceReferences;
        }
        if (application != null) {
            Set bundleDescriptors = application.getBundleDescriptors();
            for (BundleDescriptor descriptor : bundleDescriptors) {
                this.populateResourceRefsAsServiceReferences((Descriptor)descriptor, serviceReferences);
                if (descriptor instanceof EjbBundleDescriptor) {
                    EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
                    Set ejbDescriptors = ejbDesc.getEjbs();
                    for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                        this.populateResourceRefsAsServiceReferences((Descriptor)ejbDescriptor, serviceReferences);
                    }
                    Set ejbInterceptors = ejbDesc.getInterceptors();
                    for (EjbInterceptor ejbInterceptor : ejbInterceptors) {
                        this.populateResourceRefsAsServiceReferences((Descriptor)ejbInterceptor, serviceReferences);
                    }
                }
                Set managedBeanDescriptors = descriptor.getManagedBeans();
                for (ManagedBeanDescriptor mbd : managedBeanDescriptors) {
                    this.populateResourceRefsAsServiceReferences((Descriptor)mbd, serviceReferences);
                }
            }
        }
        return serviceReferences;
    }

    public Set<ServiceDescription> getImplicitServiceDescriptions(ReadableArchive cloudArchive, String appName, PaaSDeploymentContext context) {
        HashSet<ServiceDescription> implicitServiceDescriptions = new HashSet<ServiceDescription>();
        if (!JavaEEDeploymentUtils.isJavaEE((ReadableArchive)cloudArchive, (Habitat)this.habitat)) {
            return implicitServiceDescriptions;
        }
        Set<ServiceReference> serviceReferences = this.discoverServiceReferences(cloudArchive);
        boolean hasJMSReference = false;
        for (ServiceReference serviceReference : serviceReferences) {
            if (!Constants.serviceReferenceTypes.contains(serviceReference.getType())) continue;
            hasJMSReference = true;
            break;
        }
        if (hasJMSReference) {
            implicitServiceDescriptions.add(this.getDefaultServiceDescription(appName, null));
        }
        return implicitServiceDescriptions;
    }

    private boolean isDuplicate(ServiceReference serviceReference, Set<ServiceReference> serviceReferences) {
        for (ServiceReference sr : serviceReferences) {
            if (!sr.getName().equals(serviceReference.getName()) || !sr.getType().equals(serviceReference.getType())) continue;
            return true;
        }
        return false;
    }

    private void populateResourceRefsAsServiceReferences(Descriptor descriptor, Set<ServiceReference> serviceReferences) {
        if (descriptor instanceof JndiNameEnvironment) {
            ServiceReference serviceRef;
            JndiNameEnvironment jndiEnv = (JndiNameEnvironment)descriptor;
            for (Object resourceRef : jndiEnv.getResourceReferenceDescriptors()) {
                ResourceReferenceDescriptor resRefDesc = (ResourceReferenceDescriptor)resourceRef;
                if (!Constants.serviceReferenceTypes.contains(resRefDesc.getType()) || this.isDuplicate(serviceRef = new ServiceReference(resRefDesc.getJndiName(), resRefDesc.getType(), null), serviceReferences)) continue;
                serviceReferences.add(serviceRef);
            }
            for (Object resourceEnvRef : jndiEnv.getResourceEnvReferenceDescriptors()) {
                ResourceEnvReferenceDescriptor resourceEnvRefDesc = (ResourceEnvReferenceDescriptor)resourceEnvRef;
                if (!Constants.serviceReferenceTypes.contains(resourceEnvRefDesc.getRefType()) || this.isDuplicate(serviceRef = new ServiceReference(resourceEnvRefDesc.getJndiName(), resourceEnvRefDesc.getRefType(), null), serviceReferences)) continue;
                serviceReferences.add(serviceRef);
            }
            for (Object jmsDestRef : jndiEnv.getMessageDestinationReferenceDescriptors()) {
                MessageDestinationReferenceDescriptor msgDestnRefDesc = (MessageDestinationReferenceDescriptor)jmsDestRef;
                if (!Constants.serviceReferenceTypes.contains(msgDestnRefDesc.getDestinationType()) || this.isDuplicate(serviceRef = new ServiceReference(msgDestnRefDesc.getJndiName(), msgDestnRefDesc.getDestinationType(), null), serviceReferences)) continue;
                serviceReferences.add(serviceRef);
            }
        }
    }

    public void executeCommand(VirtualMachine virtualMachine, String ... args) {
        List<String> commandArgs = Arrays.asList(args);
        try {
            String output = virtualMachine.executeOn(args);
            MQServicePluginLogger.getLogger().log(Level.FINEST, "Command [" + commandArgs.toString() + "] output : " + output);
        }
        catch (Exception e) {
            MQServicePluginLogger.getLogger().log(Level.WARNING, "Unable to execute command [" + commandArgs.toString() + "]", e);
        }
    }

    public void startMQ(final VirtualMachine virtualMachine) {
        if (virtualMachine.getMachine() == null) {
            return;
        }
        String fileName = "~/mq.plugin.broker.password.txt";
        this.executeCommand(virtualMachine, "echo \"imq.imqcmd.password=admin\" > ~/mq.plugin.broker.password.txt");
        try {
            Thread myThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        String installDir = virtualMachine.getProperty(VirtualMachine.PropertyName.INSTALL_DIR);
                        String[] args = new String[]{installDir + File.separator + "mq" + File.separator + "bin" + File.separator + "imqbrokerd", "-passfile", "~/mq.plugin.broker.password.txt", "-port", "26767", "-force", "-name", "mq-service-broker"};
                        MQServicePlugin.this.executeCommand(virtualMachine, args);
                    }
                    catch (Exception e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            MQServicePlugin.this.executeCommand(virtualMachine, "rm ~/mq.plugin.broker.password.txt");
                            throw throwable;
                        }
                        MQServicePlugin.this.executeCommand(virtualMachine, "rm ~/mq.plugin.broker.password.txt");
                    }
                    MQServicePlugin.this.executeCommand(virtualMachine, "rm ~/mq.plugin.broker.password.txt");
                }
            };
            myThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopMQ(VirtualMachine virtualMachine) {
        if (virtualMachine.getMachine() == null) {
            return;
        }
        String fileName = "~/mq.plugin.broker.password.txt";
        this.executeCommand(virtualMachine, "echo \"imq.imqcmd.password=admin\" > " + fileName);
        String installDir = virtualMachine.getProperty(VirtualMachine.PropertyName.INSTALL_DIR);
        String[] args = new String[]{installDir + File.separator + "mq" + File.separator + "bin" + File.separator + "imqcmd", "shutdown", "bkr", "-u", "admin", "-f", "-passfile", fileName, "-b", "localhost:26767"};
        this.executeCommand(virtualMachine, args);
        this.executeCommand(virtualMachine, "rm " + fileName);
    }

    public ProvisionedService provisionService(ServiceDescription serviceDescription, PaaSDeploymentContext dc) {
        ProvisionedService provisionedService = this.createService(serviceDescription).get();
        Properties properties = provisionedService.getProperties();
        VirtualMachine vm = this.getVmByID(serviceDescription.getVirtualClusterName(), properties.getProperty("vm-id"));
        this.startMQ(vm);
        String ipAddress = properties.getProperty("ip-address");
        properties.putAll((Map<?, ?>)this.getServiceProperties(ipAddress, provisionedService.getName()));
        return provisionedService;
    }

    protected Properties getServiceProperties(String ipAddress, String serviceName) {
        Properties serviceProperties = new Properties();
        serviceProperties.put("user", "admin");
        serviceProperties.put("password", "admin");
        serviceProperties.put("host", ipAddress);
        serviceProperties.put("port", "26767");
        serviceProperties.put("imqDestinationName", serviceName);
        return serviceProperties;
    }

    public ProvisionedService getProvisionedService(ServiceDescription serviceDescription) {
        try {
            String serviceName = serviceDescription.getName();
            String appName = serviceDescription.getAppName();
            ServiceInfo serviceInfo = this.serviceUtil.getServiceInfo(serviceName, appName);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)serviceInfo.getProperties());
            properties.putAll((Map<?, ?>)this.getServiceProperties(properties.getProperty("ip-address"), serviceName));
            return new BasicProvisionedService(serviceDescription, properties, this.serviceUtil.getServiceStatus(serviceInfo));
        }
        catch (Exception ex) {
            throw new ServiceProvisioningException((Throwable)ex);
        }
    }

    public ProvisionedService getProvisionedService(ServiceDescription serviceDescription, ServiceInfo serviceInfo) {
        return this.getProvisionedService(serviceDescription);
    }

    public boolean unprovisionService(ServiceDescription serviceDescription, PaaSDeploymentContext dc) {
        Properties properties = this.getProvisionedService(serviceDescription).getProperties();
        VirtualMachine vm = this.getVmByID(serviceDescription.getVirtualClusterName(), properties.getProperty("vm-id"));
        String ipAddress = properties.getProperty("ip-address");
        this.stopMQ(vm);
        return this.deleteService(serviceDescription);
    }

    public ProvisionedService startService(ServiceDescription serviceDescription, ServiceInfo serviceInfo) {
        ProvisionedService provisionedService = this.startService(serviceDescription);
        Properties properties = provisionedService.getProperties();
        VirtualMachine vm = this.getVmByID(serviceDescription.getVirtualClusterName(), properties.getProperty("vm-id"));
        this.startMQ(vm);
        properties.putAll((Map<?, ?>)this.getServiceProperties(properties.getProperty("ip-address"), serviceInfo.getServiceName()));
        return provisionedService;
    }

    public boolean stopService(ProvisionedService provisionedService, ServiceInfo serviceInfo) {
        ServiceDescription serviceDescription = provisionedService.getServiceDescription();
        Properties properties = provisionedService.getProperties();
        VirtualMachine vm = this.getVmByID(serviceDescription.getVirtualClusterName(), properties.getProperty("vm-id"));
        this.stopMQ(vm);
        return this.stopService(serviceDescription);
    }

    public boolean isRunning(ProvisionedService provisionedSvc) {
        throw new UnsupportedOperationException("Status check of MQ Service not supported in this release");
    }

    public ProvisionedService match(ServiceReference svcRef) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ProvisionedService scaleService(ProvisionedService provisionedService, int scaleCount, AllocationStrategy allocStrategy) {
        throw new UnsupportedOperationException("Scaling of MQ Service not supported in this release");
    }

    public boolean reconfigureServices(ProvisionedService oldPS, ProvisionedService newPS) {
        throw new UnsupportedOperationException("Reconfiguration of MQ Service not supported in this release");
    }

    public void dissociateServices(org.glassfish.paas.orchestrator.service.spi.Service serviceConsumer, ServiceReference serviceReference, org.glassfish.paas.orchestrator.service.spi.Service serviceProvider, boolean beforeUndeploy, PaaSDeploymentContext dc) {
        ReadableArchive archive;
        Set<ServiceReference> serviceReferences;
        if (beforeUndeploy) {
            return;
        }
        if (serviceConsumer.getServiceType().toString().equalsIgnoreCase("MQ") && serviceProvider.getServiceType().toString().equalsIgnoreCase("JavaEE") && serviceReference.getType().equalsIgnoreCase("JavaEE") && (serviceReferences = this.discoverServiceReferences(archive = dc.getArchive())).size() > 0) {
            for (ServiceReference svcRef : serviceReferences) {
                CommandRunner commandRunner = this.getCommandRunner(serviceProvider);
                String target = serviceProvider.getServiceDescription().getName();
                if (!svcRef.getType().equals("javax.jms.Queue") && !svcRef.getType().equals("javax.jms.Topic") && !svcRef.getType().equals("javax.jms.QueueConnectionFactory") && !svcRef.getType().equals("javax.jms.TopicConnectionFactory")) continue;
                ArrayList<String> params = new ArrayList<String>();
                params.add("--target=" + target);
                params.add(svcRef.getName());
                String[] parameters = new String[params.size()];
                parameters = params.toArray(parameters);
                this.deleteResource(commandRunner, parameters);
                this.resetJMSService(commandRunner, serviceConsumer, serviceProvider);
            }
        }
    }

    public void associateServices(org.glassfish.paas.orchestrator.service.spi.Service serviceConsumer, ServiceReference serviceReference, org.glassfish.paas.orchestrator.service.spi.Service serviceProvider, boolean beforeDeployment, PaaSDeploymentContext dc) {
        ReadableArchive archive;
        Set<ServiceReference> serviceReferences;
        if (!beforeDeployment) {
            return;
        }
        if (serviceConsumer.getServiceType().toString().equalsIgnoreCase("MQ") && serviceProvider.getServiceType().toString().equalsIgnoreCase("JavaEE") && serviceReference.getType().equalsIgnoreCase("JavaEE") && (serviceReferences = this.discoverServiceReferences(archive = dc.getArchive())).size() > 0) {
            for (ServiceReference svcRef : serviceReferences) {
                ArrayList<String> params;
                CommandRunner commandRunner = this.getCommandRunner(serviceProvider);
                String target = serviceProvider.getServiceDescription().getName();
                this.configureJMSService(commandRunner, serviceConsumer, serviceProvider);
                if (svcRef.getType().equals("javax.jms.Queue") || svcRef.getType().equals("javax.jms.Topic")) {
                    params = new ArrayList<String>();
                    params.add("--restype=" + svcRef.getType());
                    params.add("--target=" + target);
                    String destinationName = svcRef.getName().replaceAll("/", "_");
                    params.add("--property=imqDestinationName=" + destinationName + ":" + "Name=" + destinationName);
                    params.add(svcRef.getName());
                    String[] parameters = new String[params.size()];
                    parameters = params.toArray(parameters);
                    this.createResource(commandRunner, parameters);
                    continue;
                }
                if (!svcRef.getType().equals("javax.jms.QueueConnectionFactory") && !svcRef.getType().equals("javax.jms.TopicConnectionFactory")) continue;
                params = new ArrayList();
                params.add("--restype=" + svcRef.getType());
                params.add("--target=" + target);
                params.add(svcRef.getName());
                String[] parameters = new String[params.size()];
                parameters = params.toArray(parameters);
                this.createResource(commandRunner, parameters);
            }
        }
    }

    private void resetJMSService(CommandRunner commandRunner, org.glassfish.paas.orchestrator.service.spi.Service serviceConsumer, org.glassfish.paas.orchestrator.service.spi.Service serviceProvider) {
        String clusterName = serviceProvider.getName();
        boolean hasNoJmsResources = this.hasNoJmsResources(commandRunner, clusterName);
        if (hasNoJmsResources) {
            String serviceTypeSetCommand = "configs.config." + clusterName + "-config.jms-service.type=EMBEDDED";
            String defaultJMSHost = "configs.config." + clusterName + "-config.jms-service.jms-host.default_JMS_host.host=" + "localhost";
            String defaultJMSPort = "configs.config." + clusterName + "-config.jms-service.jms-host.default_JMS_host.port=" + "'${JMS_PROVIDER_PORT}'";
            this.executeSetCommand(commandRunner, serviceTypeSetCommand);
            this.executeSetCommand(commandRunner, defaultJMSHost);
            this.executeSetCommand(commandRunner, defaultJMSPort);
        }
    }

    private boolean hasNoJmsResources(CommandRunner commandRunner, String clusterName) {
        CommandResult result = commandRunner.run("list-jms-resources", new String[]{clusterName});
        MQServicePluginLogger.getLogger().log(Level.FINEST, "list-jms-resources output : " + result.getOutput());
        boolean noJmsResourcesFound = false;
        if (result.getOutput().contains("Nothing to list")) {
            noJmsResourcesFound = true;
        }
        return noJmsResourcesFound;
    }

    private void configureJMSService(CommandRunner commandRunner, org.glassfish.paas.orchestrator.service.spi.Service serviceConsumer, org.glassfish.paas.orchestrator.service.spi.Service serviceProvider) {
        String clusterName = serviceProvider.getName();
        CommandResult result = commandRunner.run("list-jms-resources", new String[]{clusterName});
        MQServicePluginLogger.getLogger().log(Level.FINEST, "list-jms-resources output : " + result.getOutput());
        boolean hasNoJmsResources = this.hasNoJmsResources(commandRunner, clusterName);
        if (hasNoJmsResources) {
            String ipAddress = serviceConsumer.getProperties().getProperty("ip-address");
            String serviceTypeSetCommand = "configs.config." + clusterName + "-config.jms-service.type=REMOTE";
            String defaultJMSHost = "configs.config." + clusterName + "-config.jms-service.jms-host.default_JMS_host.host=" + ipAddress;
            String defaultJMSPort = "configs.config." + clusterName + "-config.jms-service.jms-host.default_JMS_host.port=" + "26767";
            this.executeSetCommand(commandRunner, serviceTypeSetCommand);
            this.executeSetCommand(commandRunner, defaultJMSHost);
            this.executeSetCommand(commandRunner, defaultJMSPort);
        }
    }

    private void executeSetCommand(CommandRunner commandRunner, String command) {
        CommandResult result = commandRunner.run("set", new String[]{command});
        if (result.getExitStatus().equals((Object)CommandResult.ExitStatus.FAILURE)) {
            MQServicePluginLogger.getLogger().log(Level.WARNING, "failed to execute command [ set " + command + " ] : " + result.getOutput(), result.getFailureCause());
            throw new RuntimeException(result.getFailureCause());
        }
    }

    private CommandRunner getCommandRunner(org.glassfish.paas.orchestrator.service.spi.Service serviceProvider) {
        CommandRunner commandRunner = null;
        try {
            if (serviceProvider instanceof GlassFishProvisionedService) {
                GlassFishProvisionedService gfps = (GlassFishProvisionedService)serviceProvider;
                GlassFish gf = gfps.getProvisionedGlassFish();
                commandRunner = gf.getCommandRunner();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return commandRunner;
    }

    private void createResource(CommandRunner commandRunner, String[] parameters) {
        CommandResult result = commandRunner.run("create-jms-resource", parameters);
        if (result.getExitStatus().equals((Object)CommandResult.ExitStatus.FAILURE)) {
            MQServicePluginLogger.getLogger().log(Level.WARNING, "failed to create jms resource : " + result.getOutput(), result.getFailureCause());
            throw new RuntimeException(result.getFailureCause());
        }
    }

    private void deleteResource(CommandRunner commandRunner, String[] parameters) {
        CommandResult result = commandRunner.run("delete-jms-resource", parameters);
        if (result.getExitStatus().equals((Object)CommandResult.ExitStatus.FAILURE)) {
            MQServicePluginLogger.getLogger().log(Level.WARNING, "failed to delete jms resource : " + result.getOutput(), result.getFailureCause());
            throw new RuntimeException(result.getFailureCause());
        }
    }

    public boolean reassociateServices(org.glassfish.paas.orchestrator.service.spi.Service serviceConsumer, org.glassfish.paas.orchestrator.service.spi.Service oldServiceProvider, org.glassfish.paas.orchestrator.service.spi.Service newServiceProvider, ServiceOrchestrator.ReconfigAction reason) {
        return true;
    }
}

