/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.AdminCommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.internal.deployment.ApplicationLifecycleInterceptor;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.virtualization.config.VirtualMachineConfig;
import org.glassfish.virtualization.config.Virtualizations;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public class ApplicationLifecycleInterceptorImpl
implements ApplicationLifecycleInterceptor {
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private Habitat habitat;
    @Inject
    private ServiceOrchestratorImpl serviceOrchestratorImpl;
    @Inject
    private ServerEnvironment serverEnvironment;
    private static Logger logger = LogDomains.getLogger(ServiceOrchestratorImpl.class, (String)"javax.org.glassfish.paas");

    public void before(final ExtendedDeploymentContext.Phase phase, final ExtendedDeploymentContext context) {
        if (this.isOrchestrationEnabled((DeploymentContext)context)) {
            this.logEvent(true, phase, context);
            AdminCommandLock.runWithSuspendedLock((Runnable)new Runnable(){

                public void run() {
                    if (phase.equals((Object)ExtendedDeploymentContext.Phase.PREPARE)) {
                        OpsParams params = context.getCommandParameters(OpsParams.class);
                        String appName = params.name();
                        if (params.origin == OpsParams.Origin.deploy) {
                            ApplicationLifecycleInterceptorImpl.this.serviceOrchestratorImpl.preDeploy(appName, (DeploymentContext)context);
                        } else if (params.origin == OpsParams.Origin.load) {
                            if (params.command == OpsParams.Command.startup_server) {
                                if (ApplicationLifecycleInterceptorImpl.this.isValidApplication(appName)) {
                                    ApplicationLifecycleInterceptorImpl.this.serviceOrchestratorImpl.startup(appName, (DeploymentContext)context);
                                }
                            } else if (params.command == OpsParams.Command.enable && ApplicationLifecycleInterceptorImpl.this.isValidApplication(appName)) {
                                ApplicationLifecycleInterceptorImpl.this.serviceOrchestratorImpl.enable(appName, (DeploymentContext)context);
                            }
                        }
                    } else if (phase.equals((Object)ExtendedDeploymentContext.Phase.STOP)) {
                        OpsParams params = context.getCommandParameters(OpsParams.class);
                        String appName = params.name();
                        if (params.origin == OpsParams.Origin.undeploy && params.command == OpsParams.Command.disable) {
                            ApplicationLifecycleInterceptorImpl.this.serviceOrchestratorImpl.preUndeploy(appName, (DeploymentContext)context);
                        }
                    }
                }
            });
        }
    }

    public void after(final ExtendedDeploymentContext.Phase phase, final ExtendedDeploymentContext context) {
        if (this.isOrchestrationEnabled((DeploymentContext)context)) {
            this.logEvent(false, phase, context);
            AdminCommandLock.runWithSuspendedLock((Runnable)new Runnable(){

                public void run() {
                    if (phase.equals((Object)ExtendedDeploymentContext.Phase.REPLICATION)) {
                        String appName;
                        OpsParams params = context.getCommandParameters(OpsParams.class);
                        if (params.origin == OpsParams.Origin.deploy) {
                            appName = params.name();
                            ApplicationLifecycleInterceptorImpl.this.serviceOrchestratorImpl.postDeploy(appName, (DeploymentContext)context);
                        }
                        if (params.origin == OpsParams.Origin.undeploy && params.command == OpsParams.Command.undeploy) {
                            ApplicationLifecycleInterceptorImpl.this.serviceOrchestratorImpl.undeploy(params, context);
                        }
                        appName = params.name();
                        if (params.origin == OpsParams.Origin.unload && params.command == OpsParams.Command.disable && ApplicationLifecycleInterceptorImpl.this.isValidApplication(appName)) {
                            ApplicationLifecycleInterceptorImpl.this.serviceOrchestratorImpl.disable(appName, context);
                        }
                    }
                }
            });
        }
    }

    private boolean isValidApplication(String appName) {
        boolean isValid = true;
        return isValid;
    }

    private void logEvent(boolean before, ExtendedDeploymentContext.Phase phase, ExtendedDeploymentContext context) {
        Level logLevel = Level.FINEST;
        if (logger.isLoggable(logLevel)) {
            try {
                StringBuilder sb = new StringBuilder();
                if (before) {
                    sb.append("ServiceOrchestrator receiving event \n { [Before] ");
                } else {
                    sb.append("ServiceOrchestrator receiving event \n { [After] ");
                }
                sb.append(" [Phase : " + phase.toString() + "]");
                if (context != null) {
                    OpsParams params = context.getCommandParameters(OpsParams.class);
                    sb.append(" [Command : " + params.command + "]");
                    sb.append(" [Origin : " + params.origin + "]");
                } else {
                    sb.append(" [DeploymentContext is null, command and origin not available]");
                }
                sb.append(" }");
                logger.log(logLevel, sb.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private boolean isOrchestrationEnabled(DeploymentContext dc) {
        return this.serverEnvironment.isDas() && this.isVirtualizationEnabled() && this.isValidDeploymentTarget(dc) || Boolean.getBoolean("org.glassfish.paas.orchestrator.enabled");
    }

    private boolean isVirtualizationEnabled() {
        boolean isVirtualEnvironment = false;
        Virtualizations v = (Virtualizations)this.domain.getExtensionByType(Virtualizations.class);
        if (v != null && v.getVirtualizations().size() > 0) {
            isVirtualEnvironment = true;
        }
        return isVirtualEnvironment;
    }

    private boolean isValidDeploymentTarget(DeploymentContext dc) {
        DeployCommandParameters dcp;
        if (dc == null) {
            return false;
        }
        String target = null;
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin == OpsParams.Origin.deploy || params.origin == OpsParams.Origin.load) {
            dcp = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            target = dcp.target;
        } else if (params.origin == OpsParams.Origin.undeploy || params.origin == OpsParams.Origin.unload) {
            dcp = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
            target = dcp.target;
        } else {
            return false;
        }
        if (target == null) {
            return true;
        }
        Cluster cluster = this.domain.getClusterNamed(target);
        if (cluster != null) {
            List vmcList = cluster.getExtensionsByType(VirtualMachineConfig.class);
            return vmcList != null && vmcList.size() > 0;
        }
        return false;
    }
}

