/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.glassfish.paas.orchestrator.service.metadata.ServiceReference;
import org.glassfish.paas.orchestrator.service.spi.ConfiguredService;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.Service;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.jvnet.hk2.annotations.Scoped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scoped(value=Singleton.class)
@org.jvnet.hk2.annotations.Service
public class PaaSAppInfoRegistry {
    private Map<String, ServiceMetadata> serviceMetadata = new LinkedHashMap<String, ServiceMetadata>();
    private Map<String, Set<ProvisionedService>> provisionedServices = new LinkedHashMap<String, Set<ProvisionedService>>();
    private Map<String, Set<ConfiguredService>> configuredServices = new LinkedHashMap<String, Set<ConfiguredService>>();
    private Map<String, Map<ServiceReference, ServiceDescription>> serviceRefToSDMap = new LinkedHashMap<String, Map<ServiceReference, ServiceDescription>>();
    private Map<String, Map<ServiceDescription, ServicePlugin>> pluginsToHandleSDMap = new LinkedHashMap<String, Map<ServiceDescription, ServicePlugin>>();
    private Map<String, Set<ServicePlugin>> effectivePlugins = new LinkedHashMap<String, Set<ServicePlugin>>();

    public ServiceMetadata removeServiceMetadata(String appName) {
        return this.serviceMetadata.remove(appName);
    }

    public Map<String, Set<ProvisionedService>> getAllProvisionedServices() {
        return this.provisionedServices;
    }

    public void addEffectivePlugins(String appName, Set<ServicePlugin> effectivePlugins) {
        this.getEffectivePlugins(appName).addAll(effectivePlugins);
    }

    public Set<ServicePlugin> getEffectivePlugins(String appName) {
        Set<ServicePlugin> plugins = this.effectivePlugins.get(appName);
        if (plugins == null) {
            this.effectivePlugins.put(appName, new LinkedHashSet());
            plugins = this.effectivePlugins.get(appName);
        }
        return plugins;
    }

    public Set<ServicePlugin> removeEffectivePlugins(String appName) {
        return this.effectivePlugins.remove(appName);
    }

    public Set<ProvisionedService> removeProvisionedServices(String appName) {
        return this.provisionedServices.remove(appName);
    }

    public Map<ServiceReference, ServiceDescription> getSRToSDMap(String appName) {
        Map<ServiceReference, ServiceDescription> srToSDMap = this.serviceRefToSDMap.get(appName);
        if (srToSDMap == null) {
            srToSDMap = new LinkedHashMap<ServiceReference, ServiceDescription>();
            this.serviceRefToSDMap.put(appName, srToSDMap);
        }
        return srToSDMap;
    }

    public Map<ServiceReference, ServiceDescription> removeSRToSDMap(String appName) {
        return this.serviceRefToSDMap.remove(appName);
    }

    public Map<ServiceDescription, ServicePlugin> getPluginsToHandleSDs(String appName) {
        Map<ServiceDescription, ServicePlugin> pluginToSDMap = this.pluginsToHandleSDMap.get(appName);
        if (pluginToSDMap == null) {
            pluginToSDMap = new LinkedHashMap<ServiceDescription, ServicePlugin>();
            this.pluginsToHandleSDMap.put(appName, pluginToSDMap);
        }
        return pluginToSDMap;
    }

    public Map<ServiceDescription, ServicePlugin> removePluginsToHandleSDs(String appName) {
        return this.pluginsToHandleSDMap.remove(appName);
    }

    public ServiceMetadata getServiceMetadata(String appName) {
        return this.serviceMetadata.get(appName);
    }

    Set<ProvisionedService> getProvisionedServices(String appName) {
        Set<ProvisionedService> ps = this.provisionedServices.get(appName);
        if (ps == null) {
            ps = new LinkedHashSet<ProvisionedService>();
            this.provisionedServices.put(appName, ps);
        }
        return this.provisionedServices.get(appName);
    }

    Set<ConfiguredService> getConfiguredServices(String appName) {
        Set<ConfiguredService> cs = this.configuredServices.get(appName);
        if (cs == null) {
            cs = new LinkedHashSet<ConfiguredService>();
            this.configuredServices.put(appName, cs);
        }
        return this.configuredServices.get(appName);
    }

    public void addServiceMetadata(String appName, ServiceMetadata appServiceMetadata) {
        this.serviceMetadata.put(appName, appServiceMetadata);
    }

    public boolean unregisterProvisionedServices(String appName, Collection<ProvisionedService> provisionedServices) {
        return this.getProvisionedServices(appName).removeAll(provisionedServices);
    }

    public boolean unregisterConfiguredServices(String appName, Collection<ConfiguredService> configuredServices) {
        return this.getConfiguredServices(appName).removeAll(configuredServices);
    }

    public void registerProvisionedServices(String appName, Collection<ProvisionedService> provisionedServices) {
        this.getProvisionedServices(appName).addAll(provisionedServices);
    }

    public void registerConfiguredServices(String appName, Collection<ConfiguredService> configuredServices) {
        this.getConfiguredServices(appName).addAll(configuredServices);
    }

    public Set<Service> getServices(String appName) {
        LinkedHashSet<Service> allServices = new LinkedHashSet<Service>();
        allServices.addAll(this.getConfiguredServices(appName));
        allServices.addAll(this.getProvisionedServices(appName));
        return allServices;
    }

    public void resetAppInfo(String appName) {
        this.removeProvisionedServices(appName);
        this.removeServiceMetadata(appName);
        this.removePluginsToHandleSDs(appName);
        this.removeSRToSDMap(appName);
        this.removeEffectivePlugins(appName);
    }
}

