/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.AdminCommandLock;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.paas.orchestrator.PaaSAppInfoRegistry;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.PaaSDeploymentException;
import org.glassfish.paas.orchestrator.PaaSDeploymentState;
import org.glassfish.paas.orchestrator.ServiceOrchestrator;
import org.glassfish.paas.orchestrator.config.ExternalService;
import org.glassfish.paas.orchestrator.config.Service;
import org.glassfish.paas.orchestrator.config.ServiceProvisioningEngine;
import org.glassfish.paas.orchestrator.config.ServiceProvisioningEngines;
import org.glassfish.paas.orchestrator.config.SharedService;
import org.glassfish.paas.orchestrator.provisioning.ServiceInfo;
import org.glassfish.paas.orchestrator.provisioning.ServiceScope;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.glassfish.paas.orchestrator.service.metadata.ServiceReference;
import org.glassfish.paas.orchestrator.service.spi.ConfiguredService;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.glassfish.paas.orchestrator.state.ConfiguredServiceRegistrationState;
import org.glassfish.paas.orchestrator.state.ConfiguredServiceUnregisterState;
import org.glassfish.paas.orchestrator.state.DeployState;
import org.glassfish.paas.orchestrator.state.DeploymentCompletionState;
import org.glassfish.paas.orchestrator.state.DisableCompletionState;
import org.glassfish.paas.orchestrator.state.DisableState;
import org.glassfish.paas.orchestrator.state.EnableState;
import org.glassfish.paas.orchestrator.state.PostDeployAssociationState;
import org.glassfish.paas.orchestrator.state.PostUndeployDissociationState;
import org.glassfish.paas.orchestrator.state.PreDeployAssociationState;
import org.glassfish.paas.orchestrator.state.PreUndeployDissociationState;
import org.glassfish.paas.orchestrator.state.ProvisioningState;
import org.glassfish.paas.orchestrator.state.ServerStartupState;
import org.glassfish.paas.orchestrator.state.ServiceDependencyDiscoveryState;
import org.glassfish.paas.orchestrator.state.ServiceReferenceRegistrationState;
import org.glassfish.paas.orchestrator.state.ServiceReferenceUnregisterState;
import org.glassfish.paas.orchestrator.state.SharedServiceRegistrationState;
import org.glassfish.paas.orchestrator.state.SharedServiceUnregisterState;
import org.glassfish.paas.orchestrator.state.UndeployState;
import org.glassfish.paas.orchestrator.state.UnprovisioningState;
import org.glassfish.virtualization.runtime.VirtualClusters;
import org.glassfish.virtualization.spi.AllocationStrategy;
import org.glassfish.virtualization.spi.VirtualCluster;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@org.jvnet.hk2.annotations.Service
@Scoped(value=Singleton.class)
public class ServiceOrchestratorImpl
implements ServiceOrchestrator {
    @Inject
    protected Habitat habitat;
    @Inject
    private ServiceUtil serviceUtil;
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private VirtualClusters virtualClusters;
    @Inject
    private PaaSAppInfoRegistry appRegistry;
    private Map<String, ProvisionedService> sharedServices = new LinkedHashMap<String, ProvisionedService>();
    private Map<String, ConfiguredService> externalServices = new LinkedHashMap<String, ConfiguredService>();
    private static final Class[] PRE_DEPLOY_PHASE_STATES = new Class[]{ServiceDependencyDiscoveryState.class, ProvisioningState.class, SharedServiceRegistrationState.class, ConfiguredServiceRegistrationState.class, ServiceReferenceRegistrationState.class, PreDeployAssociationState.class};
    private static final Class[] DEPLOY_PHASE_STATES = new Class[]{DeployState.class};
    private static final Class[] UNDEPLOY_PHASE_STATES = new Class[]{UndeployState.class};
    private static final Class[] POST_DEPLOY_PHASE_STATES = new Class[]{PostDeployAssociationState.class, DeploymentCompletionState.class};
    private static final Class[] PRE_UNDEPLOY_PHASE_STATES = new Class[]{PreUndeployDissociationState.class};
    private static final Class[] POST_UNDEPLOY_PHASE_STATES = new Class[]{PostUndeployDissociationState.class, ServiceReferenceUnregisterState.class, ConfiguredServiceUnregisterState.class, SharedServiceUnregisterState.class, UnprovisioningState.class};
    private static final Class[] ENABLE_PHASE_STATES = new Class[]{ServiceDependencyDiscoveryState.class, SharedServiceRegistrationState.class, ConfiguredServiceRegistrationState.class, EnableState.class};
    private static final Class[] DISABLE_PHASE_STATES = new Class[]{DisableState.class, SharedServiceUnregisterState.class, ConfiguredServiceUnregisterState.class, DisableCompletionState.class};
    private static final Class[] SERVER_STARTUP_PHASE_STATES = new Class[]{ServiceDependencyDiscoveryState.class, SharedServiceRegistrationState.class, ConfiguredServiceRegistrationState.class, ServerStartupState.class};
    private static final List<Class> DEPLOYMENT_STATES = new ArrayList<Class>();
    private static Logger logger = LogDomains.getLogger(ServiceOrchestratorImpl.class, (String)"javax.org.glassfish.paas");
    private Set<ServicePlugin> pluginsSet = null;
    public static final String ORCHESTRATOR_UNDEPLOY_CALL = "orchestrator.undeploy.call";
    public static final String PARALLEL_PROVISIONING_FLAG = "org.glassfish.paas.orchestrator.parallel-provisioning";
    public static final String ATOMIC_DEPLOYMENT_FLAG = "org.glassfish.paas.orchestrator.atomic-deployment";
    public static boolean parallelProvisioningEnabled;
    public static boolean atomicDeploymentEnabled;
    private static StringManager localStrings;

    private static void detectAtomicDeploymentSetting() {
        atomicDeploymentEnabled = Boolean.valueOf(System.getProperty(ATOMIC_DEPLOYMENT_FLAG, "true"));
    }

    private static void detectParallalProvisioningSetting() {
        parallelProvisioningEnabled = Boolean.valueOf(System.getProperty(PARALLEL_PROVISIONING_FLAG, "false"));
    }

    private static void composeDeploymentStates() {
        Collections.addAll(DEPLOYMENT_STATES, PRE_DEPLOY_PHASE_STATES);
        DEPLOYMENT_STATES.add(DeployState.class);
        Collections.addAll(DEPLOYMENT_STATES, POST_DEPLOY_PHASE_STATES);
    }

    public static Collection<Class> getAllStates() {
        LinkedHashSet<Class> allStates = new LinkedHashSet<Class>();
        allStates.addAll(DEPLOYMENT_STATES);
        Collections.addAll(allStates, ENABLE_PHASE_STATES);
        Collections.addAll(allStates, DISABLE_PHASE_STATES);
        return Collections.unmodifiableSet(allStates);
    }

    public Set<ServicePlugin> getPlugins(ServiceMetadata appServiceMetadata) {
        LinkedHashSet<ServicePlugin> plugins = new LinkedHashSet<ServicePlugin>();
        for (ServiceDescription sd : appServiceMetadata.getServiceDescriptions()) {
            plugins.add(sd.getPlugin());
        }
        for (ServiceReference sr : appServiceMetadata.getServiceReferences()) {
            if (sr.getRequestingPlugin() == null) continue;
            plugins.add(sr.getRequestingPlugin());
        }
        return plugins;
    }

    public Set<ServicePlugin> getPlugins() {
        if (this.pluginsSet == null) {
            LinkedHashSet<ServicePlugin> plugins = new LinkedHashSet<ServicePlugin>();
            plugins.addAll(this.habitat.getAllByContract(ServicePlugin.class));
            logger.log(Level.INFO, "discovered.plugins", plugins);
            this.pluginsSet = plugins;
        }
        return this.pluginsSet;
    }

    @Override
    public void deployApplication(String appName, ReadableArchive cloudArchive) {
    }

    public Set<org.glassfish.paas.orchestrator.service.spi.Service> getServicesForAssociation(String appName) {
        LinkedHashSet<org.glassfish.paas.orchestrator.service.spi.Service> servicesSet = new LinkedHashSet<org.glassfish.paas.orchestrator.service.spi.Service>();
        servicesSet.addAll(this.appRegistry.getProvisionedServices(appName));
        servicesSet.addAll(this.appRegistry.getConfiguredServices(appName));
        return servicesSet;
    }

    public Set<org.glassfish.paas.orchestrator.service.spi.Service> getServicesForDissociation(String appName) {
        return this.getServicesForAssociation(appName);
    }

    private void orchestrateTask(Class[] tasks, String appName, PaaSDeploymentContext pc, boolean deployment) {
        for (Class clz : tasks) {
            PaaSDeploymentState state = (PaaSDeploymentState)this.habitat.getByType(clz.getName());
            try {
                state.beforeExecution(pc);
                state.handle(pc);
                state.afterExecution(pc);
            }
            catch (PaaSDeploymentException e) {
                this.handleFailure(appName, tasks, deployment, state, pc, e);
            }
            catch (Exception e) {
                this.handleFailure(appName, tasks, deployment, state, pc, e);
            }
        }
    }

    private void handleFailure(String appName, Class[] tasks, boolean deployment, PaaSDeploymentState state, PaaSDeploymentContext pc, Exception e) {
        logger.log(Level.WARNING, localStrings.getString("failure.handling", (Object)state.getClass().getSimpleName()), e);
        if (deployment) {
            DeploymentException de = null;
            if (this.isAtomicDeploymentEnabled()) {
                this.rollbackDeployment(pc, state, DEPLOYMENT_STATES);
                de = new DeploymentException("Failure while deploying application [ " + appName + " ], " + "rolled back all deploy operations.");
            } else {
                de = new DeploymentException("Failure while deploying application [ " + appName + " ]. Atomic" + "deployment is disabled, manual cleanup is required");
            }
            de.initCause((Throwable)e);
            throw de;
        }
        DeploymentException de = new DeploymentException("Failure while undeploying application [ " + appName + " ].");
        de.initCause((Throwable)e);
        throw de;
    }

    private void rollbackDeployment(PaaSDeploymentContext context, PaaSDeploymentState failedState, List<Class> tasksList) {
        int index = tasksList.indexOf(failedState.getClass());
        if (index == -1) {
            logger.log(Level.WARNING, "no.such.task.to.initiate.rollback", failedState.getClass());
            return;
        }
        ArrayList<Class> tmpTasksList = new ArrayList<Class>();
        tmpTasksList.addAll(tasksList);
        List rollbackTasksList = tmpTasksList.subList(0, index);
        Collections.reverse(rollbackTasksList);
        for (Class clz : rollbackTasksList) {
            PaaSDeploymentState state = (PaaSDeploymentState)this.habitat.getByType(clz.getName());
            Class rollbackClz = state.getRollbackState();
            if (rollbackClz == null) continue;
            PaaSDeploymentState rollbackState = (PaaSDeploymentState)this.habitat.getByType(rollbackClz.getName());
            try {
                rollbackState.handle(context);
            }
            catch (Exception e) {
                Object[] args = new Object[]{context.getAppName(), rollbackState.getClass().getSimpleName()};
                logger.log(Level.WARNING, localStrings.getString("failure.while.rollback", args), e);
            }
        }
    }

    private void provisionServicesForApplication(String appName, PaaSDeploymentContext pc) {
        logger.log(Level.FINER, localStrings.getString("METHOD.provisionServicesForApplication"));
        this.orchestrateTask(PRE_DEPLOY_PHASE_STATES, appName, pc, true);
        logger.log(Level.FINER, localStrings.getString("METHOD.provisionServicesForApplication"));
    }

    public void postDeploy(String appName, DeploymentContext dc) {
        PaaSDeploymentContext pc = new PaaSDeploymentContext(appName, dc);
        logger.log(Level.FINER, localStrings.getString("METHOD.postDeploy"));
        this.orchestrateTask(POST_DEPLOY_PHASE_STATES, appName, pc, true);
        logger.log(Level.FINER, localStrings.getString("METHOD.postDeploy"));
    }

    public void deploy(String appName, PaaSDeploymentContext dc) {
        logger.log(Level.FINER, localStrings.getString("METHOD.deploy"));
        this.orchestrateTask(DEPLOY_PHASE_STATES, appName, dc, true);
        logger.log(Level.FINER, localStrings.getString("METHOD.deploy"));
    }

    public void postDeploy(String appName, PaaSDeploymentContext dc) {
        logger.log(Level.FINER, localStrings.getString("METHOD.postDeploy"));
        this.orchestrateTask(POST_DEPLOY_PHASE_STATES, appName, dc, true);
        logger.log(Level.FINER, localStrings.getString("METHOD.postDeploy"));
    }

    public void startup(String appName, DeploymentContext dc) {
        PaaSDeploymentContext pc = new PaaSDeploymentContext(appName, dc);
        logger.log(Level.FINER, localStrings.getString("METHOD.startup"));
        this.orchestrateTask(SERVER_STARTUP_PHASE_STATES, appName, pc, false);
        logger.log(Level.FINER, localStrings.getString("METHOD.startup"));
    }

    public void enable(String appName, DeploymentContext dc) {
        PaaSDeploymentContext pc = new PaaSDeploymentContext(appName, dc);
        logger.log(Level.FINER, localStrings.getString("METHOD.enable"));
        this.orchestrateTask(ENABLE_PHASE_STATES, appName, pc, false);
        logger.log(Level.FINER, localStrings.getString("METHOD.enable"));
    }

    public void disable(String appName, ExtendedDeploymentContext dc) {
        PaaSDeploymentContext pc = new PaaSDeploymentContext(appName, (DeploymentContext)dc);
        logger.log(Level.FINER, localStrings.getString("METHOD.disable"));
        this.orchestrateTask(DISABLE_PHASE_STATES, appName, pc, false);
        logger.log(Level.FINER, localStrings.getString("METHOD.disable"));
    }

    public void preUndeploy(String appName, PaaSDeploymentContext pc) {
        logger.log(Level.FINER, localStrings.getString("METHOD.preUndeploy"));
        this.orchestrateTask(PRE_UNDEPLOY_PHASE_STATES, appName, pc, false);
        logger.log(Level.FINER, localStrings.getString("METHOD.preUndeploy"));
    }

    public void preUndeploy(String appName, DeploymentContext dc) {
        PaaSDeploymentContext pc = new PaaSDeploymentContext(appName, dc);
        logger.log(Level.FINER, localStrings.getString("METHOD.preUndeploy"));
        if (!this.isOrchestratorInitiatedUndeploy(dc.getCommandParameters(OpsParams.class))) {
            this.orchestrateTask(PRE_UNDEPLOY_PHASE_STATES, appName, pc, false);
        }
        logger.log(Level.FINER, localStrings.getString("METHOD.preUndeploy"));
    }

    public void undeploy(String appName, PaaSDeploymentContext dc) {
        logger.log(Level.FINER, localStrings.getString("METHOD.undeploy"));
        this.orchestrateTask(UNDEPLOY_PHASE_STATES, appName, dc, true);
        logger.log(Level.FINER, localStrings.getString("METHOD.undeploy"));
    }

    public void postUndeploy(String appName, PaaSDeploymentContext dc) {
        logger.log(Level.FINER, localStrings.getString("METHOD.postUndeploy"));
        this.orchestrateTask(POST_UNDEPLOY_PHASE_STATES, appName, dc, false);
        logger.log(Level.FINER, localStrings.getString("METHOD.postUndeploy"));
    }

    public void postUndeploy(String appName, DeploymentContext dc) {
        PaaSDeploymentContext pc = new PaaSDeploymentContext(appName, dc);
        logger.log(Level.FINER, localStrings.getString("METHOD.postUndeploy"));
        if (!this.isOrchestratorInitiatedUndeploy(dc.getCommandParameters(OpsParams.class))) {
            this.orchestrateTask(POST_UNDEPLOY_PHASE_STATES, appName, pc, false);
        }
        logger.log(Level.FINER, localStrings.getString("METHOD.postUndeploy"));
    }

    private boolean isOrchestratorInitiatedUndeploy(OpsParams params) {
        if (params instanceof UndeployCommandParameters) {
            UndeployCommandParameters ucp = (UndeployCommandParameters)params;
            if (ucp.properties != null && Boolean.valueOf(ucp.properties.getProperty(ORCHESTRATOR_UNDEPLOY_CALL, "false")).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ServiceMetadata getServices(ReadableArchive archive) throws Exception {
        ServiceDependencyDiscoveryState state = (ServiceDependencyDiscoveryState)this.habitat.getByType(ServiceDependencyDiscoveryState.class);
        PaaSDeploymentContext pc = new PaaSDeploymentContext(archive.getName(), archive);
        return state.getServiceDependencyMetadata(pc, archive.getName(), archive);
    }

    public Collection<org.glassfish.paas.orchestrator.service.spi.Service> getServicesManagedByPlugin(ServicePlugin plugin, Set<org.glassfish.paas.orchestrator.service.spi.Service> allServices) {
        ArrayList<org.glassfish.paas.orchestrator.service.spi.Service> services = new ArrayList<org.glassfish.paas.orchestrator.service.spi.Service>();
        for (org.glassfish.paas.orchestrator.service.spi.Service service : allServices) {
            if (!service.getServiceType().equals(plugin.getServiceType())) continue;
            services.add(service);
        }
        return services;
    }

    public Collection<ProvisionedService> getServicesProvisionedByPlugin(ServicePlugin plugin, Set<ProvisionedService> provisionedServices) {
        ArrayList<ProvisionedService> services = new ArrayList<ProvisionedService>();
        for (ProvisionedService service : provisionedServices) {
            if (!service.getServiceType().equals(plugin.getServiceType())) continue;
            services.add(service);
        }
        return services;
    }

    public String getVirtualClusterForApplication(String appName, ServiceMetadata appServiceMetadata) {
        Set<ServiceDescription> appSDs = appServiceMetadata.getServiceDescriptions();
        String virtualClusterName = null;
        for (ServiceDescription sd : appSDs) {
            if (!"JavaEE".equalsIgnoreCase(sd.getServiceType()) || !ServiceScope.APPLICATION.equals((Object)sd.getServiceScope())) continue;
            virtualClusterName = sd.getName();
            break;
        }
        if (virtualClusterName == null) {
            virtualClusterName = appName;
        }
        return virtualClusterName;
    }

    public Collection<ProvisionedService> getServicesToUnprovision(String appName) {
        Set<ProvisionedService> provisionedServices = this.appRegistry.getProvisionedServices(appName);
        LinkedHashSet<ProvisionedService> servicesToUnprovision = new LinkedHashSet<ProvisionedService>();
        for (ProvisionedService ps : provisionedServices) {
            if (!ServiceScope.APPLICATION.equals((Object)ps.getServiceDescription().getServiceScope())) continue;
            servicesToUnprovision.add(ps);
        }
        return servicesToUnprovision;
    }

    public ProvisionedService getProvisionedService(ServiceDescription sd, String appName) {
        ProvisionedService provisionedService = null;
        Set<ProvisionedService> provisionedServices = this.appRegistry.getProvisionedServices(appName);
        for (ProvisionedService ps : provisionedServices) {
            if (!sd.getName().equals(ps.getName())) continue;
            provisionedService = ps;
            break;
        }
        return provisionedService;
    }

    public Collection<ServiceDescription> getServiceDescriptionsToProvision(String appName) {
        ServiceMetadata appServiceMetadata = this.appRegistry.getServiceMetadata(appName);
        Set<ServiceDescription> serviceDescriptions = appServiceMetadata.getServiceDescriptions();
        ArrayList<ServiceDescription> sdsToProvision = new ArrayList<ServiceDescription>();
        for (ServiceDescription sd : serviceDescriptions) {
            if (ServiceScope.SHARED.equals((Object)sd.getServiceScope()) || ServiceScope.EXTERNAL.equals((Object)sd.getServiceScope())) continue;
            sdsToProvision.add(sd);
        }
        return sdsToProvision;
    }

    public Collection<ServiceDescription> getServiceDescriptionsToUnprovision(String appName) {
        return this.getServiceDescriptionsToProvision(appName);
    }

    public void removeVirtualCluster(String virtualClusterName) {
        try {
            VirtualCluster virtualCluster = this.virtualClusters.byName(virtualClusterName);
            if (virtualCluster != null) {
                this.virtualClusters.remove(virtualCluster);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, localStrings.getString("exception.while.remove.cluster", (Object)ex.getLocalizedMessage()), ex);
        }
        CommandResult commandResult = this.commandRunner.run("delete-cluster", new String[]{virtualClusterName});
        Object[] args = new Object[]{virtualClusterName, commandResult.getOutput()};
        logger.log(Level.INFO, "delete.cluster.exec.output", args);
        Throwable failureCause = commandResult.getFailureCause();
        if (failureCause != null) {
            args[0] = failureCause.getLocalizedMessage();
            args[1] = failureCause;
            logger.log(Level.WARNING, localStrings.getString("failure.cause", args[0]), args[1]);
        }
    }

    public ServicePlugin getDefaultPluginForServiceRef(String serviceRefType) {
        ServicePlugin<Object> defaultPlugin = null;
        ArrayList<ServicePlugin> matchingPlugin = new ArrayList<ServicePlugin>();
        for (ServicePlugin servicePlugin : this.getPlugins()) {
            if (!servicePlugin.isReferenceTypeSupported(serviceRefType)) continue;
            matchingPlugin.add(servicePlugin);
        }
        block1: for (ServicePlugin<Object> servicePlugin : matchingPlugin) {
            ServiceProvisioningEngines spes = (ServiceProvisioningEngines)this.habitat.getComponent(ServiceProvisioningEngines.class);
            if (spes == null) continue;
            for (ServiceProvisioningEngine spe : spes.getServiceProvisioningEngines()) {
                if (!spe.getType().equalsIgnoreCase(servicePlugin.getServiceType().toString()) || !spe.getDefault()) continue;
                String className = spe.getClassName();
                if (!servicePlugin.getClass().getName().equals(className)) continue;
                defaultPlugin = servicePlugin;
                continue block1;
            }
        }
        return defaultPlugin;
    }

    public ServicePlugin getDefaultPlugin(Collection<ServicePlugin> pluginsList, String type) {
        ServiceProvisioningEngines spes;
        ServicePlugin defaultPlugin = null;
        if (pluginsList != null && (spes = (ServiceProvisioningEngines)this.habitat.getComponent(ServiceProvisioningEngines.class)) != null) {
            block0: for (ServiceProvisioningEngine spe : spes.getServiceProvisioningEngines()) {
                if (!spe.getType().equalsIgnoreCase(type) || !spe.getDefault()) continue;
                String className = spe.getClassName();
                for (ServicePlugin plugin : pluginsList) {
                    if (!plugin.getClass().getName().equals(className)) continue;
                    defaultPlugin = plugin;
                    continue block0;
                }
            }
        }
        return defaultPlugin;
    }

    @Override
    public boolean scaleService(final String appName, final String svcName, final int scaleCount, final AllocationStrategy allocStrategy) {
        Object[] args = new Object[]{svcName, appName, scaleCount};
        logger.log(Level.INFO, "scale.services", args);
        AdminCommandLock.runWithSuspendedLock((Runnable)new Runnable(){

            public void run() {
                String effectiveAppName = appName;
                String tmpAppName = null;
                for (String app : ServiceOrchestratorImpl.this.appRegistry.getAllProvisionedServices().keySet()) {
                    logger.log(Level.FINER, localStrings.getString("check.app.for.service ", (Object)svcName));
                    Set<ProvisionedService> appsServices = ServiceOrchestratorImpl.this.appRegistry.getProvisionedServices(app);
                    for (ProvisionedService p : appsServices) {
                        if (!p.getName().equals(svcName)) continue;
                        tmpAppName = app;
                    }
                }
                if (tmpAppName != null) {
                    effectiveAppName = tmpAppName;
                    logger.log(Level.FINER, localStrings.getString("setAppName"));
                }
                Set<ProvisionedService> appPS = ServiceOrchestratorImpl.this.appRegistry.getProvisionedServices(effectiveAppName);
                logger.log(Level.FINER, localStrings.getString("appPS", appPS));
                org.glassfish.paas.orchestrator.service.spi.Service oldPS = null;
                for (ProvisionedService ps : appPS) {
                    if (!ps.getName().equals(svcName)) continue;
                    oldPS = ps;
                }
                logger.log(Level.FINER, localStrings.getString("oldPS", oldPS));
                ServicePlugin chosenPlugin = oldPS.getServiceDescription().getPlugin();
                ServiceInfo oldServiceInfo = ServiceOrchestratorImpl.this.serviceUtil.getServiceInfo(oldPS.getName(), appName);
                Object[] args = new Object[]{svcName, chosenPlugin};
                logger.log(Level.INFO, "scale.service.using.plugin", args);
                ProvisionedService newPS = chosenPlugin.scaleService((ProvisionedService)oldPS, scaleCount, allocStrategy);
                ServiceOrchestratorImpl.this.serviceUtil.unregisterService(oldServiceInfo);
                ServiceOrchestratorImpl.this.serviceUtil.registerService(appName, newPS, null);
                args[0] = svcName;
                args[1] = newPS;
                logger.log(Level.INFO, "new.provisioned.service", args);
                assert (newPS.getName().equals(oldPS.getName()));
                assert (newPS.getServiceType().equals(oldPS.getServiceType()));
                ServiceMetadata appServiceMetadata = ServiceOrchestratorImpl.this.appRegistry.getServiceMetadata(effectiveAppName);
                Set<ServicePlugin> plugins = ServiceOrchestratorImpl.this.getPlugins(appServiceMetadata);
                for (ServicePlugin svcPlugin : plugins) {
                    if (newPS.getServiceType().equals(svcPlugin.getServiceType())) continue;
                    Set<ServiceReference> appSRs = appServiceMetadata.getServiceReferences();
                    for (ServiceReference serviceRef : appSRs) {
                        Object[] args1 = new Object[]{newPS, serviceRef, svcPlugin};
                        logger.log(Level.INFO, "reassociate.provisionedservice.serviceref", args1);
                        Collection<org.glassfish.paas.orchestrator.service.spi.Service> serviceConsumers = ServiceOrchestratorImpl.this.getServicesManagedByPlugin(svcPlugin, ServiceOrchestratorImpl.this.getServicesForAssociation(appName));
                        for (org.glassfish.paas.orchestrator.service.spi.Service serviceConsumer : serviceConsumers) {
                            svcPlugin.reassociateServices(serviceConsumer, oldPS, newPS, ServiceOrchestrator.ReconfigAction.AUTO_SCALING);
                        }
                    }
                }
            }
        });
        return true;
    }

    @Override
    public ServiceDescription getServiceDescription(String appName, String service) {
        ServiceMetadata appServiceMetadata = this.appRegistry.getServiceMetadata(appName);
        for (ServiceDescription desc : appServiceMetadata.getServiceDescriptions()) {
            if (!desc.getName().equals(service)) continue;
            return desc;
        }
        return null;
    }

    public void undeploy(OpsParams params, ExtendedDeploymentContext context) {
        String appName = params.name();
        this.postUndeploy(appName, (DeploymentContext)context);
    }

    public void preDeploy(String appName, PaaSDeploymentContext dc) {
        this.provisionServicesForApplication(appName, dc);
    }

    public void preDeploy(String appName, DeploymentContext dc) {
        PaaSDeploymentContext pc = new PaaSDeploymentContext(appName, dc);
        this.provisionServicesForApplication(appName, pc);
    }

    public void addSharedService(String serviceName, ProvisionedService provisionedService) {
        this.sharedServices.put(serviceName, provisionedService);
    }

    public void addExternalService(String serviceName, ConfiguredService configuredService) {
        ServiceDescription sd = configuredService.getServiceDescription();
        if (configuredService.getServiceDescription().getPlugin() == null) {
            ServicePlugin plugin = this.getPlugin(sd);
            sd.setPlugin(plugin);
        }
        this.externalServices.put(serviceName, configuredService);
    }

    public ConfiguredService removeExternalService(String serviceName) {
        return this.externalServices.remove(serviceName);
    }

    public ProvisionedService removeSharedService(String serviceName) {
        return this.sharedServices.remove(serviceName);
    }

    public ConfiguredService getConfiguredService(String serviceName) {
        ConfiguredService configuredService = this.externalServices.get(serviceName);
        if (configuredService == null) {
            configuredService = this.serviceUtil.getExternalService(serviceName);
            this.addExternalService(serviceName, configuredService);
        }
        if (configuredService == null) {
            throw new RuntimeException("No such external service [" + serviceName + "] is available");
        }
        return configuredService;
    }

    public ProvisionedService getSharedService(String serviceName) {
        ProvisionedService provisionedService = this.sharedServices.get(serviceName);
        if (provisionedService == null) {
            ServiceDescription sd = this.getSharedServiceDescription(serviceName);
            ServicePlugin plugin = sd.getPlugin();
            ServiceInfo serviceInfo = this.serviceUtil.getServiceInfo(serviceName, null);
            provisionedService = plugin.getProvisionedService(sd, serviceInfo);
            this.sharedServices.put(serviceName, provisionedService);
        }
        if (provisionedService == null) {
            throw new RuntimeException("No such shared service [" + serviceName + "] is available");
        }
        return provisionedService;
    }

    public ServiceDescription getExternalServiceDescription(String serviceName) {
        return this.getConfiguredService(serviceName).getServiceDescription();
    }

    public ServiceDescription getServiceDescriptionForSharedOrExternalService(String serviceName) throws PaaSDeploymentException {
        Service service = this.serviceUtil.getService(serviceName, null);
        ServiceDescription sd = null;
        if (service instanceof SharedService) {
            sd = this.getSharedServiceDescription(serviceName);
        } else if (service instanceof ExternalService) {
            sd = this.getExternalServiceDescription(serviceName);
        }
        return sd;
    }

    public ServiceDescription getSharedServiceDescription(String serviceName) {
        ServiceDescription sd = null;
        ServiceInfo serviceInfo = this.serviceUtil.getServiceInfo(serviceName, null);
        if (serviceInfo != null) {
            sd = this.serviceUtil.getSharedServiceDescription(serviceInfo);
            if (sd == null) {
                throw new RuntimeException("Could not retrieve shared-service-description [" + serviceName + "] ");
            }
            sd.setServiceScope(ServiceScope.SHARED);
        } else {
            throw new RuntimeException("No such shared service [" + serviceName + "] is available");
        }
        ServicePlugin plugin = this.getPlugin(sd);
        sd.setPlugin(plugin);
        sd.setVirtualClusterName(sd.getName());
        return sd;
    }

    public ServicePlugin getPlugin(ServiceDescription sd) {
        LinkedHashSet<ServicePlugin> plugins = new LinkedHashSet<ServicePlugin>();
        for (ServicePlugin plugin : this.getPlugins()) {
            if (!sd.getServiceType().equalsIgnoreCase(plugin.getServiceType().toString())) continue;
            plugins.add(plugin);
        }
        if (plugins.size() > 0) {
            ServicePlugin matchingPlugin;
            ArrayList<ServicePlugin> pluginsHandlingSD = new ArrayList<ServicePlugin>();
            for (ServicePlugin plugin : plugins) {
                if (!plugin.handles(sd)) continue;
                pluginsHandlingSD.add(plugin);
            }
            if (pluginsHandlingSD.size() == 1) {
                return (ServicePlugin)pluginsHandlingSD.get(0);
            }
            if (pluginsHandlingSD.size() > 1 && (matchingPlugin = this.getDefaultPlugin(pluginsHandlingSD, sd.getServiceType())) == null) {
                throw new RuntimeException("Unable to resolve conflict among multiple service-provisioning engines that can handle service-type [" + sd.getServiceType() + "]" + " specified in the service-description [" + sd + "]");
            }
        }
        ServicePlugin matchingPlugin = null;
        if (plugins.size() > 1) {
            matchingPlugin = this.getDefaultPlugin(plugins, sd.getServiceType());
            if (matchingPlugin == null) {
                throw new RuntimeException("Unable to resolve conflict among multiple service-provisioning engines that can handle service-type [" + sd.getServiceType() + "]" + " specified in the service-description [" + sd + "]");
            }
        } else if (plugins.size() == 1) {
            matchingPlugin = (ServicePlugin)plugins.iterator().next();
        } else {
            throw new RuntimeException("No service-provisioning-engine can handle service-type [" + sd.getServiceType() + "]" + " specified in service-description [" + sd + "]");
        }
        return matchingPlugin;
    }

    public boolean isParallelProvisioningEnabled() {
        return parallelProvisioningEnabled;
    }

    public boolean isAtomicDeploymentEnabled() {
        return atomicDeploymentEnabled;
    }

    public Set<org.glassfish.paas.orchestrator.service.spi.Service> getServices(String appName) {
        return this.appRegistry.getServices(appName);
    }

    static {
        localStrings = StringManager.getManager(ServiceOrchestratorImpl.class);
        ServiceOrchestratorImpl.composeDeploymentStates();
        ServiceOrchestratorImpl.detectParallalProvisioningSetting();
        ServiceOrchestratorImpl.detectAtomicDeploymentSetting();
    }
}

