/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator;

import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.paas.orchestrator.ServicesXMLParser;
import org.glassfish.paas.orchestrator.provisioning.ServiceScope;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class ServicesXMLParserImpl
implements ServicesXMLParser {
    public ServiceMetadata discoverDeclaredServices(String appName, ReadableArchive ra) {
        ServiceMetadata serviceMetadata = null;
        try {
            InputStream inputStream = null;
            inputStream = DeploymentUtils.isWebArchive((ReadableArchive)ra) ? ra.getEntry("WEB-INF/glassfish-services.xml") : ra.getEntry("META-INF/glassfish-services.xml");
            if (inputStream != null) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ServiceMetadata.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                serviceMetadata = (ServiceMetadata)unmarshaller.unmarshal(inputStream);
                if (appName != null) {
                    serviceMetadata.setAppName(appName);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (serviceMetadata != null) {
            for (ServiceDescription serviceDescription : serviceMetadata.getServiceDescriptions()) {
                serviceDescription.setAppName(appName);
                serviceDescription.setServiceScope(ServiceScope.APPLICATION);
            }
        }
        return serviceMetadata;
    }
}

