/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.logging.LogDomains;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.PaaSAppInfoRegistry;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.config.ApplicationScopedService;
import org.glassfish.paas.orchestrator.config.Services;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.service.spi.ConfiguredService;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServiceLogRecord;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="collect-service-log-files")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="collect-service-log-files", description="Collect Log files for Services")})
public class CollectServiceLogFiles
implements AdminCommand {
    @Inject
    protected PaaSAppInfoRegistry appInfoRegistry;
    @Param(name="appname", optional=true)
    private String appName;
    @Param(name="servicename", optional=true)
    private String serviceName;
    @Param(name="datetime", optional=true, defaultValue="01/01/1970 00:00:00.001")
    private String datetime;
    @Param(name="retrieve", optional=true, defaultValue="false")
    boolean retrieve;
    @Param(primary=true, optional=true, defaultValue=".")
    private String retrieveFilePath;
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;
    @Inject
    protected ServiceOrchestratorImpl orchestrator;
    @Inject
    ServerEnvironment env;
    @Inject
    LoggingConfigImpl loggingConfig;
    Map<org.glassfish.paas.orchestrator.service.spi.Service, List<ServiceLogRecord>> serviceLogRecordMap;
    String recordBeginMarker = "[#|";
    String recordEndMarker = "|#]";
    String fieldSeparator = "|";
    long dateinmilliseconds = 0L;
    private static Logger logger = LogDomains.getLogger(CollectServiceLogFiles.class, (String)"javax.org.glassfish.paas");
    StringBuffer reportMessage = new StringBuffer();
    String zipFileName = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        logger.log(Level.INFO, "Collecting Service Log Records");
        if (this.appName == null && this.serviceName == null) {
            report.setMessage("Missing application name or service name.");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.appName != null && this.serviceName != null) {
            report.setMessage("Enter either application name or service name.");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.retrieve && !this.retrieveFilePath.equals(".") && this.retrieveFilePath.length() > 1) {
            this.reportMessage.append("WARNING: Retrieve flag is false so zip file is not copied to " + this.retrieveFilePath + "\n");
        }
        if (this.datetime != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
            Date date = null;
            try {
                date = dateFormat.parse(this.datetime);
            }
            catch (ParseException ex) {
                logger.warning("Error while parsing date: " + ex);
                report.setMessage("Error while parsing date [" + this.datetime + "]. Please use dd/MM/yyyy HH:mm:ss.SSS formatter for passing date.");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            this.dateinmilliseconds = date.getTime();
        }
        if (this.appName != null) {
            this.zipFileName = this.appName;
            if (this.domain.getApplications().getApplication(this.appName) == null) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("No such application [" + this.appName + "] is deployed");
                return;
            }
            Set<org.glassfish.paas.orchestrator.service.spi.Service> appServices = this.appInfoRegistry.getServices(this.appName);
            for (org.glassfish.paas.orchestrator.service.spi.Service service : appServices) {
                try {
                    this.serviceLogRecordMap = service.collectLogs(service.getDefaultLogType(), Level.ALL, new Date());
                    if (this.serviceLogRecordMap != null) {
                        this.creatingLogFilesOnDAS(this.serviceLogRecordMap, report, service.getName());
                        this.reportMessage.append("Logs are collected for [" + service.getName() + "] having service type [" + service.getServiceType().getName() + "] " + "which is used by [" + this.appName + "]" + "\n");
                        continue;
                    }
                    this.reportMessage.append("Collect Logs are unsupported for [" + service.getName() + "]  having service type [" + service.getServiceType().getName() + "] " + "which is used by [" + this.appName + "]" + "\n");
                }
                catch (UnsupportedOperationException ex) {
                    this.reportMessage.append("Collect Logs are unsupported for [" + service.getName() + "]  having service type [" + service.getServiceType().getName() + "] " + "which is used by [" + this.appName + "]" + "\n");
                }
            }
        }
        if (this.serviceName != null) {
            ProvisionedService provisionedService;
            ConfiguredService configuredService;
            this.zipFileName = this.serviceName;
            Services services = this.serviceUtil.getServices();
            List<org.glassfish.paas.orchestrator.config.Service> allServices = services.getServices();
            boolean serviceFound = false;
            boolean appScopedServiceFound = false;
            boolean configuredServiceFound = false;
            boolean provisionedServiceFound = false;
            String appName = "";
            for (org.glassfish.paas.orchestrator.config.Service service : allServices) {
                if (!service.getServiceName().equals(this.serviceName)) continue;
                if (service instanceof ApplicationScopedService) {
                    appName = ((ApplicationScopedService)service).getApplicationName();
                    appScopedServiceFound = true;
                } else if (service instanceof ConfiguredService) {
                    configuredServiceFound = true;
                } else if (service instanceof ProvisionedService) {
                    provisionedServiceFound = true;
                }
                serviceFound = true;
                break;
            }
            if (!serviceFound) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("No such service [" + this.serviceName + "] is available");
                return;
            }
            if (appScopedServiceFound) {
                Set<org.glassfish.paas.orchestrator.service.spi.Service> appServices = this.orchestrator.getServices(appName);
                for (org.glassfish.paas.orchestrator.service.spi.Service service : appServices) {
                    if (!service.getName().equals(this.serviceName)) continue;
                    try {
                        this.serviceLogRecordMap = service.collectLogs(service.getDefaultLogType(), Level.ALL, new Date());
                        this.creatingLogFilesOnDAS(this.serviceLogRecordMap, report, service.getName());
                        this.reportMessage.append("Logs are collected for [" + service.getName() + "] having service " + "type [" + service.getServiceType().getName() + "] " + "which is used by [" + appName + "]" + "\n");
                    }
                    catch (UnsupportedOperationException ex) {
                        this.reportMessage.append("Collect Logs are unsupported for [" + service.getName() + "] having " + "service type [" + service.getServiceType().getName() + "] " + "which is used by [" + appName + "]" + "\n");
                    }
                }
            }
            if (configuredServiceFound && (configuredService = this.orchestrator.getConfiguredService(this.serviceName)) != null) {
                try {
                    this.serviceLogRecordMap = configuredService.collectLogs(configuredService.getDefaultLogType(), Level.ALL, new Date());
                    this.creatingLogFilesOnDAS(this.serviceLogRecordMap, report, configuredService.getName());
                    this.reportMessage.append("Logs are collected for [" + this.serviceName + "] having service " + "type [" + configuredService.getServiceType().getName() + "]" + "\n");
                }
                catch (UnsupportedOperationException ex) {
                    this.reportMessage.append("Collect Logs are unsupported for [" + this.serviceName + "] having " + "service type [" + configuredService.getServiceType().getName() + "]" + "\n");
                }
            }
            if (provisionedServiceFound && (provisionedService = this.orchestrator.getSharedService(this.serviceName)) != null) {
                try {
                    this.serviceLogRecordMap = provisionedService.collectLogs(provisionedService.getDefaultLogType(), Level.ALL, new Date());
                    this.creatingLogFilesOnDAS(this.serviceLogRecordMap, report, provisionedService.getName());
                    this.reportMessage.append("Logs are collected for [" + this.serviceName + "] having service type " + "[" + provisionedService.getServiceType().getName() + "]" + "\n");
                }
                catch (UnsupportedOperationException ex) {
                    this.reportMessage.append("Collect Logs are unsupported for [" + this.serviceName + "] having service " + "type [" + provisionedService.getServiceType().getName() + "]" + "\n");
                }
            }
        }
        String zipFile = "";
        File zipFilePath = this.getZipFilePath();
        if (zipFilePath != null && zipFilePath.exists()) {
            try {
                zipFile = this.loggingConfig.createZipFile(zipFilePath.getAbsolutePath(), this.zipFileName);
                if (zipFile == null || new File(zipFile) == null) {
                    this.reportMessage.append("File is downloaded on DAS [" + this.getZipFilePath().getAbsolutePath() + "] but " + "error occur while creating zip file");
                    report.setMessage(this.reportMessage.toString());
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception during creating zip file on DAS: " + e);
                this.reportMessage.append("File is downloaded on DAS [" + this.getZipFilePath().getAbsolutePath() + "] but " + "error occur while creating zip file");
                report.setMessage(this.reportMessage.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            finally {
                this.deleteDir(new File(this.getZipFilePath().getAbsolutePath() + File.separator + "logs"));
            }
            if (this.retrieve) {
                zipFile = this.retrieveFile(zipFile, context, this.getZipFilePath(), this.initFileXferProps(), report);
            }
            if (zipFile != null) {
                this.reportMessage.append("Zip file is available at: " + zipFile + "\n");
            }
        } else {
            this.reportMessage.append("As collect logs are unsupported for each of the services so no zip file available on DAS.\n");
        }
        report.setMessage(this.reportMessage.toString());
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void creatingLogFilesOnDAS(Map<org.glassfish.paas.orchestrator.service.spi.Service, List<ServiceLogRecord>> serviceLogRecordMap, ActionReport report, String fileName) {
        for (org.glassfish.paas.orchestrator.service.spi.Service service : serviceLogRecordMap.keySet()) {
            List<ServiceLogRecord> serviceLogRecords;
            String serviceName = service.getName();
            File serviceDirectoryOnDAS = this.makingDirectoryOnDas(serviceName, report);
            boolean dataWrittenToFile = this.writingServiceLogRecordToFile(serviceDirectoryOnDAS, serviceLogRecords = serviceLogRecordMap.get(service), fileName);
            if (dataWrittenToFile) continue;
            this.reportMessage.append("Log details are missing for [" + serviceName + "]" + "\n");
        }
    }

    private boolean writingServiceLogRecordToFile(File serviceDirectoryOnDAS, List<ServiceLogRecord> serviceLogRecords, String fileName) {
        try {
            if (!serviceDirectoryOnDAS.exists()) {
                serviceDirectoryOnDAS.mkdirs();
            }
            File serviceLogFile = new File(serviceDirectoryOnDAS, fileName);
            FileWriter fstream = new FileWriter(serviceLogFile);
            BufferedWriter out = new BufferedWriter(fstream);
            for (ServiceLogRecord serviceLogRecord : serviceLogRecords) {
                long millis = serviceLogRecord.getMillis();
                if (millis <= this.dateinmilliseconds) continue;
                SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(millis);
                String dateTime = formatter.format(calendar.getTime());
                StringBuffer logDetails = new StringBuffer();
                logDetails.append(this.recordBeginMarker);
                logDetails.append(dateTime);
                logDetails.append(this.fieldSeparator);
                logDetails.append(serviceLogRecord.getLevel().toString());
                logDetails.append(this.fieldSeparator);
                logDetails.append(serviceLogRecord.getLoggerName());
                logDetails.append(this.fieldSeparator);
                logDetails.append(serviceLogRecord.getApplicationName());
                logDetails.append(this.fieldSeparator);
                Object[] myObject = serviceLogRecord.getParameters();
                if (myObject != null) {
                    for (Object object : myObject) {
                        logDetails.append(object.toString());
                        logDetails.append("|");
                    }
                }
                logDetails.append(serviceLogRecord.getMessage());
                logDetails.append(this.recordEndMarker);
                out.write(logDetails.toString());
                out.newLine();
            }
            out.close();
            fstream.close();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception during creating file on DAS: " + e);
            return false;
        }
    }

    private File makingDirectory(File parent, String path, ActionReport report) {
        File targetDir = new File(parent, path);
        boolean created = false;
        if (!targetDir.exists()) {
            created = targetDir.mkdir();
            if (!created) {
                report.setMessage("Error while creating [" + targetDir.getAbsolutePath() + "]  on Server.");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return null;
            }
            return targetDir;
        }
        return targetDir;
    }

    private File makingDirectoryOnDas(String serviceName, ActionReport report) {
        File logsDir;
        File collectLogsDir = this.makingDirectory(this.env.getInstanceRoot(), "collected-logs", report);
        File appDir = logsDir = this.makingDirectory(collectLogsDir, "logs", report);
        if (this.appName != null) {
            appDir = this.makingDirectory(logsDir, this.appName, report);
        }
        File targetDir = this.makingDirectory(appDir, serviceName, report);
        return targetDir;
    }

    private boolean deleteDir(File dir) {
        boolean ret = true;
        for (File f : dir.listFiles()) {
            ret = f.isDirectory() ? ret && this.deleteDir(f) : ret && f.delete();
        }
        return ret && dir.delete();
    }

    private File getZipFilePath() {
        return new File(this.env.getInstanceRoot() + File.separator + "collected-logs");
    }

    private Properties initFileXferProps() {
        Properties props = new Properties();
        props.setProperty("file-xfer-root", this.retrieveFilePath.replace("\\", "/"));
        return props;
    }

    private String retrieveFile(String zipFileName, AdminCommandContext context, File sourceDir, Properties props, ActionReport report) {
        String zipFileAtRetrieveLocation = "";
        Payload.Outbound outboundPayload = context.getOutboundPayload();
        boolean fileAttachedToPayload = false;
        if (outboundPayload == null) {
            outboundPayload = PayloadImpl.Outbound.newInstance();
        }
        try {
            ArrayList<File> files = new ArrayList<File>(Arrays.asList(sourceDir.listFiles()));
            for (int i = 0; i < files.size(); ++i) {
                File file = (File)files.get(i);
                if (file.isDirectory()) {
                    files.addAll(Arrays.asList(file.listFiles()));
                    continue;
                }
                if (!file.getAbsolutePath().equals(zipFileName)) continue;
                outboundPayload.attachFile("application/octet-stream", sourceDir.toURI().relativize(file.toURI()), "files", props, file);
                fileAttachedToPayload = true;
                break;
            }
            if (fileAttachedToPayload) {
                boolean created;
                File targetLocalFile = new File(this.retrieveFilePath);
                if (!targetLocalFile.exists() && !(created = targetLocalFile.mkdirs())) {
                    this.reportMessage.append("Retrieve File Path is not exists [" + this.retrieveFilePath + "]");
                    report.setMessage(this.reportMessage.toString());
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return null;
                }
                zipFileAtRetrieveLocation = targetLocalFile + File.separator + zipFileName.substring(zipFileName.lastIndexOf(File.separator) + 1, zipFileName.length());
                FileOutputStream targetStream = new FileOutputStream(zipFileAtRetrieveLocation);
                outboundPayload.writeTo((OutputStream)targetStream);
                targetStream.flush();
                targetStream.close();
            }
        }
        catch (Exception ex) {
            logger.severe("Error while copying zip file [" + zipFileName + "] to [" + this.retrieveFilePath + " ]" + ex);
            this.reportMessage.append("Error while copying zip file [" + zipFileName + "] to [" + this.retrieveFilePath + " ]");
            report.setMessage(this.reportMessage.toString());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return null;
        }
        return zipFileAtRetrieveLocation;
    }
}

