/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.config.Configuration;
import org.glassfish.paas.orchestrator.config.Configurations;
import org.glassfish.paas.orchestrator.config.ExternalService;
import org.glassfish.paas.orchestrator.config.Services;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-external-service")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="create-external-service", description="Create an external service")})
public class CreateExternalService
implements AdminCommand {
    @Param(name="defaultService", defaultValue="false", optional=true)
    private Boolean defaultService;
    @Param(name="force", defaultValue="false", optional=true)
    private Boolean force;
    @Param(name="servicetype", optional=false)
    private String serviceType;
    @Param(name="property", optional=true, separator=58)
    private Properties properties;
    @Param(name="configuration", optional=true, separator=58)
    private Properties configuration;
    @Param(name="servicename", primary=true)
    private String serviceName;
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Services services = this.serviceUtil.getServices();
        if (this.defaultService.booleanValue() && !this.force.booleanValue()) {
            for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
                if (!(service instanceof ExternalService) || !((ExternalService)service).getDefault() || !service.getType().equalsIgnoreCase(this.serviceType)) continue;
                report.setMessage("An external service named [" + service.getServiceName() + "] is already marked as default service, " + "use --force=true to override the same");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Services>(){

                public Object run(Services param) throws PropertyVetoException, TransactionFailure {
                    ExternalService externalService = (ExternalService)param.createChild(ExternalService.class);
                    externalService.setDefault(CreateExternalService.this.defaultService);
                    externalService.setType(CreateExternalService.this.serviceType);
                    externalService.setServiceName(CreateExternalService.this.serviceName);
                    if (CreateExternalService.this.configuration != null) {
                        Configurations configs = (Configurations)externalService.createChild(Configurations.class);
                        for (Map.Entry<Object, Object> entry : CreateExternalService.this.configuration.entrySet()) {
                            Configuration config = (Configuration)configs.createChild(Configuration.class);
                            config.setName((String)entry.getKey());
                            config.setValue((String)entry.getValue());
                            configs.getConfiguration().add(config);
                        }
                        externalService.setConfigurations(configs);
                        for (Map.Entry entry : CreateExternalService.this.configuration.entrySet()) {
                            Property prop = (Property)externalService.createChild(Property.class);
                            prop.setName((String)entry.getKey());
                            prop.setValue((String)entry.getValue());
                            externalService.getProperty().add(prop);
                        }
                    }
                    if (CreateExternalService.this.properties != null) {
                        for (Map.Entry<Object, Object> e : CreateExternalService.this.properties.entrySet()) {
                            Property property = (Property)externalService.createChild(Property.class);
                            property.setName((String)e.getKey());
                            property.setValue((String)e.getValue());
                            externalService.getProperty().add(property);
                        }
                    }
                    if (CreateExternalService.this.defaultService.booleanValue() && CreateExternalService.this.force.booleanValue()) {
                        Services services = (Services)CreateExternalService.this.domain.getExtensionByType(Services.class);
                        for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
                            ExternalService existingExternalService;
                            if (!(service instanceof ExternalService) || !(existingExternalService = (ExternalService)service).getDefault() || !CreateExternalService.this.serviceType.equalsIgnoreCase(existingExternalService.getType())) continue;
                            Transaction transaction = Transaction.getTransaction((ConfigBeanProxy)param);
                            ExternalService wExtService = (ExternalService)transaction.enroll((ConfigBeanProxy)existingExternalService);
                            wExtService.setDefault(false);
                            break;
                        }
                    }
                    param.getServices().add(externalService);
                    return externalService;
                }
            }, (ConfigBeanProxy)services) == null) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("Unable to create external service");
            } else {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
        }
        catch (TransactionFailure transactionFailure) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Unable to create external service due to : " + transactionFailure.getMessage());
            report.setFailureCause((Throwable)transactionFailure);
        }
    }
}

