/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.config.Characteristic;
import org.glassfish.paas.orchestrator.config.Characteristics;
import org.glassfish.paas.orchestrator.config.Configuration;
import org.glassfish.paas.orchestrator.config.Configurations;
import org.glassfish.paas.orchestrator.config.Services;
import org.glassfish.paas.orchestrator.config.SharedService;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.provisioning.cli.SharedServiceLazyInitializer;
import org.glassfish.paas.orchestrator.service.ServiceStatus;
import org.glassfish.paas.orchestrator.service.metadata.Property;
import org.glassfish.paas.orchestrator.service.metadata.ServiceCharacteristics;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.TemplateIdentifier;
import org.glassfish.virtualization.config.Template;
import org.glassfish.virtualization.config.Virtualization;
import org.glassfish.virtualization.config.Virtualizations;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-shared-service")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="create-shared-service", description="Create a shared service")})
public class CreateSharedService
implements AdminCommand {
    @Param(name="defaultService", defaultValue="false", optional=true)
    private Boolean defaultService;
    @Param(name="force", defaultValue="false", optional=true)
    private Boolean force;
    @Param(name="servicetype", optional=false)
    private String serviceType;
    @Param(name="properties", optional=true, separator=58)
    private Properties properties;
    @Param(name="characteristics", optional=true, separator=58)
    private Properties characteristics;
    @Param(name="configuration", optional=true, separator=58)
    private Properties configuration;
    @Param(name="initmode", optional=true, acceptableValues="eager,lazy", defaultValue="eager")
    private String initMode;
    @Param(name="template", optional=true)
    private String template;
    @Param(name="servicename", primary=true)
    private String serviceName;
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;
    private boolean templateFound = false;
    @Inject
    private SharedServiceLazyInitializer sharedServiceLazyInitializer;
    private static Logger logger = LogDomains.getLogger(ServiceOrchestratorImpl.class, (String)"javax.org.glassfish.paas");
    @Inject
    private ServiceOrchestratorImpl serviceOrchestrator;

    public void execute(AdminCommandContext context) {
        Services services;
        Virtualizations virtualizations;
        ActionReport report = context.getActionReport();
        if (this.template != null && this.characteristics != null) {
            report.setMessage("Provide either template or characteristics and not both while creating a shared service");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.template != null && (virtualizations = (Virtualizations)this.domain.getExtensionByType(Virtualizations.class)) != null) {
            block0: for (Virtualization virtualization : virtualizations.getVirtualizations()) {
                for (Template tmplt : virtualization.getTemplates()) {
                    if (!this.template.equalsIgnoreCase(tmplt.getName())) continue;
                    this.templateFound = true;
                    continue block0;
                }
            }
            if (!this.templateFound) {
                report.setMessage("A template named [ " + this.template + " ] does not exist.");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        for (org.glassfish.paas.orchestrator.config.Service service : this.serviceUtil.getServices().getServices()) {
            if (!service.getServiceName().equals(this.serviceName)) continue;
            report.setMessage("Service by name [" + this.serviceName + "] already exist");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.defaultService.booleanValue() && !this.force.booleanValue() && (services = (Services)this.domain.getExtensionByType(Services.class)) != null) {
            for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
                if (!(service instanceof SharedService) || !((SharedService)service).getDefault() || !service.getType().equalsIgnoreCase(this.serviceType)) continue;
                report.setMessage("A shared service by name [" + service.getServiceName() + "] is already marked as default service, " + " for service-type [" + this.serviceType + "] use --force=true to override the same");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        this.createConfig(report);
        if ("eager".equalsIgnoreCase(this.initMode)) {
            ServiceDescription sd = new ServiceDescription();
            sd.setName(this.serviceName);
            ArrayList<Property> configurationList = new ArrayList<Property>();
            if (this.configuration != null) {
                for (String name : this.configuration.stringPropertyNames()) {
                    Property property = new Property();
                    property.setName(name);
                    property.setValue((String)this.configuration.get(name));
                    configurationList.add(property);
                }
                sd.setConfigurations(configurationList);
            }
            if (this.template != null) {
                TemplateIdentifier tid = new TemplateIdentifier();
                tid.setId(this.template);
                sd.setTemplateOrCharacteristics(tid);
            }
            if (this.characteristics != null) {
                ArrayList<Property> characteristicsList = new ArrayList<Property>();
                for (String name : this.characteristics.stringPropertyNames()) {
                    Property property = new Property();
                    property.setName(name);
                    property.setValue((String)this.characteristics.get(name));
                    characteristicsList.add(property);
                }
                ServiceCharacteristics serviceCharacteristics = new ServiceCharacteristics(characteristicsList);
                sd.setTemplateOrCharacteristics(serviceCharacteristics);
            }
            this.sharedServiceLazyInitializer.provisionService(sd, report);
        }
    }

    private void createConfig(ActionReport report) {
        Services services = this.serviceUtil.getServices();
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Services>(){

                public Object run(Services param) throws PropertyVetoException, TransactionFailure {
                    SharedService sharedService = (SharedService)param.createChild(SharedService.class);
                    sharedService.setDefault(CreateSharedService.this.defaultService);
                    sharedService.setType(CreateSharedService.this.serviceType);
                    sharedService.setTemplate(CreateSharedService.this.template);
                    sharedService.setInitMode(CreateSharedService.this.initMode);
                    sharedService.setServiceName(CreateSharedService.this.serviceName);
                    sharedService.setState(ServiceStatus.UNINITIALIZED.toString());
                    if (CreateSharedService.this.properties != null) {
                        for (Map.Entry<Object, Object> e : CreateSharedService.this.properties.entrySet()) {
                            org.jvnet.hk2.config.types.Property prop = (org.jvnet.hk2.config.types.Property)sharedService.createChild(org.jvnet.hk2.config.types.Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            sharedService.getProperty().add(prop);
                        }
                    }
                    if (CreateSharedService.this.characteristics != null) {
                        Characteristics chars = (Characteristics)sharedService.createChild(Characteristics.class);
                        for (Map.Entry<Object, Object> e : CreateSharedService.this.characteristics.entrySet()) {
                            Characteristic characteristic = (Characteristic)chars.createChild(Characteristic.class);
                            characteristic.setName((String)e.getKey());
                            characteristic.setValue((String)e.getValue());
                            chars.getCharacteristic().add(characteristic);
                        }
                        sharedService.setCharacteristics(chars);
                    }
                    if (CreateSharedService.this.configuration != null) {
                        Configurations configs = (Configurations)sharedService.createChild(Configurations.class);
                        for (Map.Entry<Object, Object> e : CreateSharedService.this.configuration.entrySet()) {
                            Configuration config = (Configuration)configs.createChild(Configuration.class);
                            config.setName((String)e.getKey());
                            config.setValue((String)e.getValue());
                            configs.getConfiguration().add(config);
                        }
                        sharedService.setConfigurations(configs);
                    }
                    if (CreateSharedService.this.defaultService.booleanValue() && CreateSharedService.this.force.booleanValue()) {
                        Services services = (Services)CreateSharedService.this.domain.getExtensionByType(Services.class);
                        for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
                            SharedService existingSharedService;
                            if (!(service instanceof SharedService) || !(existingSharedService = (SharedService)service).getDefault() || !CreateSharedService.this.serviceType.equalsIgnoreCase(existingSharedService.getType())) continue;
                            Transaction transaction = Transaction.getTransaction((ConfigBeanProxy)param);
                            SharedService wShService = (SharedService)transaction.enroll((ConfigBeanProxy)existingSharedService);
                            wShService.setDefault(false);
                            break;
                        }
                    }
                    param.getServices().add(sharedService);
                    return sharedService;
                }
            }, (ConfigBeanProxy)services) == null) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("Unable to create shared service");
            }
        }
        catch (Exception e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Unable to create shared service [" + this.serviceName + "] due to : " + e.getMessage());
            report.setFailureCause((Throwable)e);
        }
    }
}

