/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.config.ExternalService;
import org.glassfish.paas.orchestrator.config.Services;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-external-service")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="delete-external-service", description="Delete an external service")})
public class DeleteExternalService
implements AdminCommand {
    @Param(name="servicename", primary=true)
    private String serviceName;
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;
    @Inject
    private ServiceOrchestratorImpl serviceOrchestrator;

    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();
        Services services = this.serviceUtil.getServices();
        boolean found = false;
        for (final org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
            if (!service.getServiceName().equals(this.serviceName) || !(service instanceof ExternalService)) continue;
            found = true;
            List<String> applicationsUsingService = this.serviceUtil.getApplicationsUsingService(service.getServiceName());
            if (applicationsUsingService.size() > 0) {
                report.setMessage("The external service [" + this.serviceName + "] is " + "used by an application [" + applicationsUsingService.get(0) + "].");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Services>(){

                    public Object run(Services param) throws PropertyVetoException, TransactionFailure {
                        param.getServices().remove(service);
                        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        DeleteExternalService.this.serviceOrchestrator.removeExternalService(DeleteExternalService.this.serviceName);
                        return service;
                    }
                }, (ConfigBeanProxy)services) != null) continue;
            }
            catch (TransactionFailure e) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("Deleting external-service [" + this.serviceName + "] failed : " + e.getMessage());
                report.setFailureCause((Throwable)e);
                return;
            }
        }
        if (!found) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("No external-service by name [" + this.serviceName + "] is available");
        }
    }
}

