/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.config.Services;
import org.glassfish.paas.orchestrator.config.SharedService;
import org.glassfish.paas.orchestrator.provisioning.ServiceInfo;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServiceChangeEvent;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-shared-service")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="delete-shared-service", description="Delete a shared service")})
public class DeleteSharedService
implements AdminCommand {
    @Param(name="servicename", primary=true)
    private String serviceName;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private ServiceUtil serviceUtil;
    @Inject
    private ServiceOrchestratorImpl serviceOrchestrator;
    private static Logger logger = LogDomains.getLogger(ServiceOrchestratorImpl.class, (String)"javax.org.glassfish.paas");
    private static StringManager localStrings = StringManager.getManager(ServiceOrchestratorImpl.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Services services = this.serviceUtil.getServices();
        boolean found = false;
        for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
            if (!service.getServiceName().equals(this.serviceName) || !(service instanceof SharedService)) continue;
            found = true;
            List<String> applicationsUsingService = this.serviceUtil.getApplicationsUsingService(service.getServiceName());
            if (applicationsUsingService.size() > 0) {
                report.setMessage("The shared service [" + this.serviceName + "] is " + "used by an application [" + applicationsUsingService.get(0) + "].");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            SharedService sharedService = (SharedService)service;
            ProvisionedService provisionedService = this.serviceOrchestrator.getSharedService(sharedService.getServiceName());
            ServicePlugin plugin = provisionedService.getServiceDescription().getPlugin();
            DeploymentContext dc = null;
            PaaSDeploymentContext pdc = new PaaSDeploymentContext(null, dc);
            ServiceInfo serviceInfo = this.serviceUtil.getServiceInfo(provisionedService.getName(), null);
            plugin.unprovisionService(provisionedService.getServiceDescription(), pdc);
            this.serviceOrchestrator.removeSharedService(sharedService.getServiceName());
            this.serviceUtil.unregisterService(serviceInfo);
            this.serviceUtil.fireServiceChangeEvent(ServiceChangeEvent.Type.DELETED, provisionedService);
            String virtualClusterName = service.getServiceName();
            CommandResult result = this.commandRunner.run("delete-cluster", new String[]{virtualClusterName});
            Object[] args = new Object[]{virtualClusterName, result.getOutput()};
            logger.log(Level.FINEST, localStrings.getString("delete.cluster.exec.output", args));
            if (!result.getExitStatus().equals((Object)CommandResult.ExitStatus.FAILURE)) continue;
            throw new RuntimeException("Failure while deleting virtual-cluster, Unable to delete virtual-cluster [" + virtualClusterName + "]");
        }
        if (!found) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("No shared-service by name [" + this.serviceName + "] is available");
        }
    }
}

