/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.ServiceOrchestrator;
import org.glassfish.paas.orchestrator.provisioning.util.JSONUtil;
import org.glassfish.paas.orchestrator.service.metadata.Property;
import org.glassfish.paas.orchestrator.service.metadata.ServiceCharacteristics;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.glassfish.paas.orchestrator.service.metadata.TemplateIdentifier;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="_generate-glassfish-services-deployment-plan")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Applications.class, opType=RestEndpoint.OpType.POST, path="_generate-glassfish-services-deployment-plan", description="Generate glassfish-services.xml deployment plan from the list of services")})
public class GenerateGlassFishServicesDeploymentPlan
implements AdminCommand {
    @Param(optional=false)
    private File archive;
    @Param(optional=false)
    private String modifiedServiceDesc;
    @Inject
    private ArchiveFactory archiveFactory;
    @Inject
    private ServiceOrchestrator orchestrator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AdminCommandContext context) {
        List serviceMetadata = (List)JSONUtil.jsonToJava(this.modifiedServiceDesc);
        ActionReport report = context.getActionReport();
        List<ServiceDescription> serviceDescriptions = this.generateServiceMetadata(serviceMetadata);
        if (this.archive == null || !this.archive.exists()) {
            report.setMessage("Invalid archive");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ReadableArchive readableArchive = null;
        try {
            readableArchive = this.archiveFactory.openArchive(this.archive);
            ServiceMetadata metadata = this.orchestrator.getServices(readableArchive);
            Set<ServiceDescription> serviceDescriptionsSet = metadata.getServiceDescriptions();
            serviceDescriptionsSet.clear();
            serviceDescriptionsSet.addAll(serviceDescriptions);
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ServiceMetadata.class});
                Marshaller marshaller = jaxbContext.createMarshaller();
                String fileName = System.getProperty("java.io.tmpdir") + File.separator + "glassfish-services.xml";
                File xmlFile = new File(fileName);
                xmlFile.deleteOnExit();
                marshaller.marshal((Object)metadata, xmlFile);
                File jarFile = new File(fileName);
                jarFile.deleteOnExit();
                String jarFilepath = this.generateJarFile(jarFile);
                Properties properties = new Properties();
                properties.put("deployment-plan-file-path", jarFilepath);
                report.setExtraProperties(properties);
                report.setMessage("generated deployment plan jar file [ " + jarFilepath + " ]");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)ex);
                report.setMessage("Failure while generating the updated glassfish-services.xml : " + ex.getMessage());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            report.setMessage("Failure while generating the updated glassfish-services.xml : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            report.setMessage("Failure while generating the updated glassfish-services.xml : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        finally {
            try {
                if (readableArchive != null) {
                    readableArchive.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                report.setMessage("Failure while generating the updated glassfish-services.xml : " + e.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateJarFile(File file) throws IOException {
        String jarFileName = file.getAbsolutePath() + ".jar";
        ZipOutputStream jarOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int count;
            String fileName = file.getName();
            JarEntry jarEntry = new JarEntry(fileName);
            jarEntry.setTime(file.lastModified());
            jarOutputStream = new JarOutputStream(new FileOutputStream(jarFileName));
            ((JarOutputStream)jarOutputStream).putNextEntry(jarEntry);
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            while ((count = bufferedInputStream.read(buffer)) != -1) {
                jarOutputStream.write(buffer, 0, count);
            }
            jarOutputStream.closeEntry();
            String string = jarFileName;
            return string;
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception e) {}
            }
            if (jarOutputStream != null) {
                try {
                    jarOutputStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private List<ServiceDescription> generateServiceMetadata(List<Map<String, Object>> serviceMetadata) {
        ArrayList<ServiceDescription> metadata = new ArrayList<ServiceDescription>();
        for (Map<String, Object> sdMap : serviceMetadata) {
            String value;
            String name;
            Property property;
            Iterator keySetIterator;
            Set keySet;
            ServiceDescription sd = new ServiceDescription();
            if (sdMap.get("name") == null) {
                throw new IllegalArgumentException("Name not available for the ServiceDesciption");
            }
            sd.setName((String)sdMap.get("name"));
            if (sdMap.get("init-type") != null) {
                sd.setInitType((String)sdMap.get("init-type"));
            }
            if (sdMap.get("service-type") == null) {
                throw new IllegalArgumentException("Service-type not available for the ServiceDesciption");
            }
            sd.setInitType((String)sdMap.get("service-type"));
            if (sdMap.get("template-id") != null) {
                String templateID = (String)sdMap.get("template-id");
                TemplateIdentifier tid = new TemplateIdentifier();
                tid.setId(templateID);
                sd.setTemplateOrCharacteristics(tid);
            } else if (sdMap.get("characteristics") != null) {
                HashMap characteristics = (HashMap)sdMap.get("characteristics");
                keySet = characteristics.keySet();
                keySetIterator = keySet.iterator();
                ArrayList<Property> characteristicsList = new ArrayList<Property>();
                while (keySetIterator.hasNext()) {
                    property = new Property();
                    name = (String)keySetIterator.next();
                    value = (String)characteristics.get(name);
                    property.setName(name);
                    property.setValue(value);
                    characteristicsList.add(property);
                }
                ServiceCharacteristics serviceCharacteristics = new ServiceCharacteristics();
                serviceCharacteristics.setServiceCharacteristics(characteristicsList);
                sd.setTemplateOrCharacteristics(serviceCharacteristics);
            } else {
                throw new IllegalArgumentException("Neither template-id nor Characteristics is available for the ServiceDesciption");
            }
            if (sdMap.get("configurations") != null) {
                HashMap configuration = (HashMap)sdMap.get("configurations");
                keySet = configuration.keySet();
                keySetIterator = keySet.iterator();
                ArrayList<Property> configurationList = new ArrayList<Property>();
                while (keySetIterator.hasNext()) {
                    property = new Property();
                    name = (String)keySetIterator.next();
                    value = (String)configuration.get(name);
                    property.setName(name);
                    property.setValue(value);
                    configurationList.add(property);
                }
                sd.setConfigurations(configurationList);
            }
            metadata.add(sd);
        }
        return metadata;
    }
}

