/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.ServiceOrchestrator;
import org.glassfish.paas.orchestrator.service.metadata.Property;
import org.glassfish.paas.orchestrator.service.metadata.ServiceCharacteristics;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="_get-service-description")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Applications.class, opType=RestEndpoint.OpType.GET, path="_get-service-description", description="Get Service Description for a particular service of an application")})
public class GetServiceDescription
implements AdminCommand {
    @Param(name="appname", optional=false)
    private String appName;
    @Param(name="servicename", primary=true)
    private String service;
    @Inject
    private ServiceOrchestrator orchestrator;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.domain.getApplications().getApplication(this.appName) == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("No such application [" + this.appName + "] is deployed");
            return;
        }
        ServiceDescription desc = this.orchestrator.getServiceDescription(this.appName, this.service);
        if (desc == null) {
            report.setMessage("Service by name [" + this.service + " ] does not exist for the given application [" + this.appName + " ]");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Map<String, Object> descMap = this.getServiceDescriptionMap(desc);
        Properties extraProperties = new Properties();
        extraProperties.put("list", descMap);
        report.setExtraProperties(extraProperties);
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private Map<String, Object> getServiceDescriptionMap(ServiceDescription desc) {
        TreeMap<String, Object> serviceDescription = new TreeMap<String, Object>();
        serviceDescription.put("init-type", desc.getInitType());
        serviceDescription.put("name", desc.getName());
        serviceDescription.put("service-type", desc.getServiceType());
        if (desc.getTemplateIdentifier() != null) {
            serviceDescription.put("template-id", desc.getTemplateIdentifier().getId());
        } else {
            TreeMap<String, String> serviceCharacteristicsMap = new TreeMap<String, String>();
            if (desc.getServiceCharacteristics() != null) {
                ServiceCharacteristics characteristics = desc.getServiceCharacteristics();
                for (Property characteristic : characteristics.getServiceCharacteristics()) {
                    serviceCharacteristicsMap.put(characteristic.getName(), characteristic.getValue());
                }
            }
            serviceDescription.put("characteristics", serviceCharacteristicsMap);
        }
        TreeMap<String, String> configuration = new TreeMap<String, String>();
        List<Property> configs = desc.getConfigurations();
        if (configs != null) {
            for (Property property : configs) {
                configuration.put(property.getName(), property.getValue());
            }
        }
        serviceDescription.put("configurations", configuration);
        return serviceDescription;
    }
}

