/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.ServiceOrchestrator;
import org.glassfish.paas.orchestrator.service.metadata.Property;
import org.glassfish.paas.orchestrator.service.metadata.ServiceCharacteristics;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="_get-service-metadata")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Applications.class, opType=RestEndpoint.OpType.GET, path="_get-service-metadata", description="Get Service Metadata")})
public class GetServiceMetadata
implements AdminCommand {
    @Param(primary=true)
    private File archive;
    @Inject
    private ArchiveFactory archiveFactory;
    @Inject
    private ServiceOrchestrator orchestrator;
    @Inject
    private Habitat habitat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.archive == null || !this.archive.exists()) {
            report.setMessage("Invalid archive");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ReadableArchive readableArchive = null;
        try {
            readableArchive = this.archiveFactory.openArchive(this.archive);
            ServiceMetadata metadata = this.orchestrator.getServices(readableArchive);
            ArrayList<Map<String, Object>> serviceMetadataList = new ArrayList<Map<String, Object>>();
            for (ServiceDescription desc : metadata.getServiceDescriptions()) {
                Map<String, Object> descMap = this.getServiceDescriptionMap(desc);
                serviceMetadataList.add(descMap);
            }
            Properties extraProperties = new Properties();
            extraProperties.put("list", serviceMetadataList);
            report.setExtraProperties(extraProperties);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (IOException e) {
            report.setMessage("Failure while reading the archive");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        catch (Exception e) {
            report.setMessage("Failure while getting service-metadata");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        finally {
            try {
                if (readableArchive != null) {
                    readableArchive.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private Map<String, Object> getServiceDescriptionMap(ServiceDescription desc) {
        TreeMap<String, Object> serviceDescription = new TreeMap<String, Object>();
        serviceDescription.put("init-type", desc.getInitType());
        serviceDescription.put("name", desc.getName());
        serviceDescription.put("service-type", desc.getServiceType());
        if (desc.getTemplateIdentifier() != null) {
            serviceDescription.put("template-id", desc.getTemplateIdentifier().getId());
        } else {
            TreeMap<String, String> serviceCharacteristicsMap = new TreeMap<String, String>();
            if (desc.getServiceCharacteristics() != null) {
                ServiceCharacteristics characteristics = desc.getServiceCharacteristics();
                for (Property characteristic : characteristics.getServiceCharacteristics()) {
                    serviceCharacteristicsMap.put(characteristic.getName(), characteristic.getValue());
                }
            }
            serviceDescription.put("characteristics", serviceCharacteristicsMap);
        }
        TreeMap<String, String> configuration = new TreeMap<String, String>();
        List<Property> configs = desc.getConfigurations();
        if (configs != null) {
            for (Property property : configs) {
                configuration.put(property.getName(), property.getValue());
            }
        }
        serviceDescription.put("configurations", configuration);
        return serviceDescription;
    }
}

