/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.logging.LogDomains;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.paas.orchestrator.PaaSAppInfoRegistry;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.config.ApplicationScopedService;
import org.glassfish.paas.orchestrator.config.Services;
import org.glassfish.paas.orchestrator.provisioning.cli.CollectServiceLogFiles;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.service.spi.ConfiguredService;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServiceLogRecord;
import org.glassfish.paas.orchestrator.service.spi.ServiceLogType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="_hidden-tail-service-log-file")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="hidden.tail.server.logfile")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="_hidden-tail-service-log-file", description="Tail Service Log file")})
public class HiddenTailServiceLogFile
implements AdminCommand {
    @Inject
    protected PaaSAppInfoRegistry appInfoRegistry;
    @Param(name="servicename", optional=false)
    private String serviceName;
    @Param(name="logtype", optional=false)
    private String logtype;
    @Param(name="filepointer", optional=false)
    private String filepointer;
    @Param(name="lastrecorddateinmilliseconds", optional=false)
    private String lastrecorddateinmilliseconds;
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;
    @Inject
    protected ServiceOrchestratorImpl orchestrator;
    @Inject
    ServerEnvironment env;
    @Inject
    LoggingConfigImpl loggingConfig;
    Map<org.glassfish.paas.orchestrator.service.spi.Service, List<ServiceLogRecord>> serviceLogRecordMap;
    String recordBeginMarker = "[#|";
    String recordEndMarker = "|#]";
    String fieldSeparator = "|";
    private static Logger logger = LogDomains.getLogger(CollectServiceLogFiles.class, (String)"javax.org.glassfish.paas");
    StringBuffer reportMessage = new StringBuffer();
    StringBuffer fileData = new StringBuffer();
    String newLine = System.getProperty("line.separator");
    long _lastrecorddateinmilliseconds = 0L;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.isLongNumber(this.filepointer)) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Invalid file pointer [" + this.filepointer + "]. Please enter valid numeric value.");
            return;
        }
        long _filePointer = Long.valueOf(this.filepointer);
        this._lastrecorddateinmilliseconds = Long.valueOf(this.lastrecorddateinmilliseconds);
        logger.log(Level.INFO, "Collecting Service Log Records");
        ServiceLogType serviceLogType = new ServiceLogType(){

            public String getName() {
                return HiddenTailServiceLogFile.this.logtype;
            }
        };
        if (this.serviceName != null) {
            ProvisionedService provisionedService;
            ConfiguredService configuredService;
            Services services = this.serviceUtil.getServices();
            List<org.glassfish.paas.orchestrator.config.Service> allServices = services.getServices();
            boolean serviceFound = false;
            boolean appScopedServiceFound = false;
            boolean configuredServiceFound = false;
            boolean provisionedServiceFound = false;
            String appName = "";
            File serviceLogFile = null;
            for (org.glassfish.paas.orchestrator.config.Service service : allServices) {
                if (!service.getServiceName().equals(this.serviceName)) continue;
                if (service instanceof ApplicationScopedService) {
                    appName = ((ApplicationScopedService)service).getApplicationName();
                    appScopedServiceFound = true;
                } else if (service instanceof ConfiguredService) {
                    configuredServiceFound = true;
                } else if (service instanceof ProvisionedService) {
                    provisionedServiceFound = true;
                }
                serviceFound = true;
                break;
            }
            if (!serviceFound) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("No such service [" + this.serviceName + "] is available");
                return;
            }
            if (appScopedServiceFound) {
                Set<org.glassfish.paas.orchestrator.service.spi.Service> appServices = this.orchestrator.getServices(appName);
                for (org.glassfish.paas.orchestrator.service.spi.Service service : appServices) {
                    if (!service.getName().equals(this.serviceName)) continue;
                    try {
                        this.serviceLogRecordMap = service.collectLogs(serviceLogType, Level.INFO, new Date());
                        serviceLogFile = this.creatingLogFilesOnDAS(this.serviceLogRecordMap, report);
                        this.reportMessage.append("Logs are collected for [" + service.getName() + "] having service " + "type [ " + service.getServiceType().getName() + " ] " + "which is used by [" + appName + "]" + "\n");
                    }
                    catch (UnsupportedOperationException ex) {
                        this.reportMessage.append("Tailing Log is unsupported for [" + service.getName() + "] having " + "service type [ " + service.getServiceType().getName() + " ] " + "which is used by [" + appName + "]" + "\n");
                    }
                }
            }
            if (configuredServiceFound && (configuredService = this.orchestrator.getConfiguredService(this.serviceName)) != null) {
                try {
                    this.serviceLogRecordMap = configuredService.collectLogs(serviceLogType, Level.INFO, new Date());
                    serviceLogFile = this.creatingLogFilesOnDAS(this.serviceLogRecordMap, report);
                    this.reportMessage.append("Logs are collected for [" + this.serviceName + "] having service " + "type [ " + configuredService.getServiceType().getName() + " ]" + "\n");
                }
                catch (UnsupportedOperationException ex) {
                    this.reportMessage.append("Tailing Log is unsupported for [" + this.serviceName + "] having " + "service type [ " + configuredService.getServiceType().getName() + " ]" + "\n");
                }
            }
            if (provisionedServiceFound && (provisionedService = this.orchestrator.getSharedService(this.serviceName)) != null) {
                try {
                    this.serviceLogRecordMap = provisionedService.collectLogs(serviceLogType, Level.INFO, new Date());
                    serviceLogFile = this.creatingLogFilesOnDAS(this.serviceLogRecordMap, report);
                    this.reportMessage.append("Logs are collected for [" + this.serviceName + "] having service type " + "[ " + provisionedService.getServiceType().getName() + " ]" + "\n");
                }
                catch (UnsupportedOperationException ex) {
                    this.reportMessage.append("Tailing Log is unsupported for [" + this.serviceName + "] having service " + "type [ " + provisionedService.getServiceType().getName() + " ]" + "\n");
                }
            }
            if (!serviceLogFile.exists() || serviceLogFile.isDirectory() || !serviceLogFile.canRead()) {
                this.reportMessage.append("Cannot Find log file for given [" + this.serviceName + "]" + "\n");
            } else {
                try {
                    long len = serviceLogFile.length();
                    if (len < _filePointer) {
                        this.appendMessage("Log file was reset. Restarting logging from start of file.");
                        _filePointer = len;
                    } else if (len > _filePointer) {
                        RandomAccessFile raf = new RandomAccessFile(serviceLogFile, "r");
                        raf.seek(_filePointer);
                        String line = null;
                        while ((line = raf.readLine()) != null) {
                            this.appendLine(line);
                        }
                        _filePointer = raf.getFilePointer();
                        raf.close();
                    }
                    report.getTopMessagePart().addProperty("filedata", this.fileData.toString());
                    report.getTopMessagePart().addProperty("filepointer", String.valueOf(_filePointer));
                    report.getTopMessagePart().addProperty("lastrecorddateinmilliseconds", String.valueOf(this._lastrecorddateinmilliseconds));
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
    }

    private void appendLine(String line) {
        this.fileData.append(line);
        this.fileData.append(this.newLine);
    }

    private void appendMessage(String message) {
        this.appendLine("[" + new Date().toString() + ", " + message + "]");
    }

    private boolean isLongNumber(String num) {
        try {
            Long.parseLong(num);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private File creatingLogFilesOnDAS(Map<org.glassfish.paas.orchestrator.service.spi.Service, List<ServiceLogRecord>> serviceLogRecordMap, ActionReport report) {
        Iterator<org.glassfish.paas.orchestrator.service.spi.Service> i$ = serviceLogRecordMap.keySet().iterator();
        if (i$.hasNext()) {
            List<ServiceLogRecord> serviceLogRecords;
            org.glassfish.paas.orchestrator.service.spi.Service service = i$.next();
            String serviceName = service.getName();
            File serviceDirectoryOnDAS = this.makingDirectoryOnDas(serviceName, report);
            File serviceLogFile = this.writingServiceLogRecordToFile(serviceDirectoryOnDAS, serviceLogRecords = serviceLogRecordMap.get(service));
            if (serviceLogFile == null) {
                this.reportMessage.append("Log details are missing for [" + serviceName + "]" + "\n");
                return null;
            }
            return serviceLogFile;
        }
        return null;
    }

    private File makingDirectory(File parent, String path, ActionReport report) {
        File targetDir = new File(parent, path);
        boolean created = false;
        if (!targetDir.exists()) {
            created = targetDir.mkdir();
            if (!created) {
                report.setMessage("Error while creating [" + targetDir.getAbsolutePath() + "]  on Server.");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return null;
            }
            return targetDir;
        }
        return targetDir;
    }

    private File makingDirectoryOnDas(String serviceName, ActionReport report) {
        File collectLogsDir = this.makingDirectory(this.env.getInstanceRoot(), "collected-logs", report);
        File logsDir = this.makingDirectory(collectLogsDir, "logs", report);
        File targetDir = this.makingDirectory(logsDir, serviceName, report);
        return targetDir;
    }

    private boolean deleteDir(File dir) {
        boolean ret = true;
        for (File f : dir.listFiles()) {
            ret = f.isDirectory() ? ret && this.deleteDir(f) : ret && f.delete();
        }
        return ret && dir.delete();
    }

    private File writingServiceLogRecordToFile(File serviceDirectoryOnDAS, List<ServiceLogRecord> serviceLogRecords) {
        try {
            if (!serviceDirectoryOnDAS.exists()) {
                serviceDirectoryOnDAS.mkdirs();
            }
            File serviceLogFile = new File(serviceDirectoryOnDAS, this.logtype);
            FileWriter fstream = new FileWriter(serviceLogFile, true);
            BufferedWriter out = new BufferedWriter(fstream);
            for (ServiceLogRecord serviceLogRecord : serviceLogRecords) {
                long millis = serviceLogRecord.getMillis();
                if (millis < this._lastrecorddateinmilliseconds) continue;
                SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(millis);
                String dateTime = formatter.format(calendar.getTime());
                StringBuffer logDetails = new StringBuffer();
                logDetails.append(this.recordBeginMarker);
                logDetails.append(dateTime);
                logDetails.append(this.fieldSeparator);
                logDetails.append(serviceLogRecord.getLevel().toString());
                logDetails.append(this.fieldSeparator);
                logDetails.append(serviceLogRecord.getLoggerName());
                logDetails.append(this.fieldSeparator);
                logDetails.append(serviceLogRecord.getApplicationName());
                logDetails.append(this.fieldSeparator);
                Object[] myObject = serviceLogRecord.getParameters();
                if (myObject != null) {
                    for (Object object : myObject) {
                        logDetails.append(object.toString());
                        logDetails.append("|");
                    }
                }
                logDetails.append(serviceLogRecord.getMessage());
                logDetails.append(this.recordEndMarker);
                out.write(logDetails.toString());
                out.newLine();
                this._lastrecorddateinmilliseconds = millis;
            }
            out.close();
            fstream.close();
            return serviceLogFile;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception during creating file on DAS: " + e);
            return null;
        }
    }
}

