/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import java.util.ArrayList;
import java.util.Locale;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.config.ServiceProvisioningEngine;
import org.glassfish.paas.orchestrator.config.ServiceProvisioningEngines;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-service-provisioning-engines")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-service-provisioning-engines", description="List Service Provisioning Engines")})
public class ListServiceProvisioningEngines
implements AdminCommand {
    @Param(name="type", optional=true)
    private String type;
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;

    public void execute(AdminCommandContext context) {
        String output;
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart messagePart = report.getTopMessagePart();
        ArrayList<String> outputList = new ArrayList<String>();
        ServiceProvisioningEngines serviceProvisioningEngines = this.serviceUtil.getServiceProvisioningEngines();
        Locale locale = Locale.getDefault();
        if (this.type == null) {
            for (ServiceProvisioningEngine serviceProvisioningEngine : serviceProvisioningEngines.getServiceProvisioningEngines()) {
                output = serviceProvisioningEngine.getType().toUpperCase(locale) + "\t<" + serviceProvisioningEngine.getClassName() + ">";
                if (serviceProvisioningEngine.getDefault()) {
                    output = output + "\t<default>";
                }
                outputList.add(output);
            }
        } else {
            for (ServiceProvisioningEngine serviceProvisioningEngine : serviceProvisioningEngines.getServiceProvisioningEngines()) {
                if (!serviceProvisioningEngine.getType().equalsIgnoreCase(this.type)) continue;
                output = this.type.toUpperCase(locale) + "\t<" + serviceProvisioningEngine.getClassName() + ">";
                if (serviceProvisioningEngine.getDefault()) {
                    output = output + "\t<default>";
                }
                outputList.add(output);
            }
            if (outputList.isEmpty()) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                report.setMessage("No service-provisioning-engine of type [" + this.type + "] is available.");
                return;
            }
        }
        for (String anOutputList : outputList) {
            ActionReport.MessagePart childPart = messagePart.addChild();
            childPart.setMessage(anOutputList);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

