/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.admin.util.ColumnFormatter;
import com.sun.enterprise.config.serverbeans.Domain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.config.ApplicationScopedService;
import org.glassfish.paas.orchestrator.config.ExternalService;
import org.glassfish.paas.orchestrator.config.ServiceRef;
import org.glassfish.paas.orchestrator.config.Services;
import org.glassfish.paas.orchestrator.config.SharedService;
import org.glassfish.paas.orchestrator.provisioning.ServiceInfo;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="list-services")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-services", description="List Services")})
public class ListServices
implements AdminCommand {
    @Param(name="appname", optional=true)
    private String appName;
    @Param(name="type", optional=true)
    private String type;
    @Param(name="scope", optional=true, acceptableValues="external,shared,application")
    private String scope;
    @Param(name="terse", optional=true, shortName="t", defaultValue="false")
    private boolean terse;
    @Param(name="header", optional=true, shortName="h", defaultValue="false")
    private boolean header;
    @Param(name="output", optional=true, shortName="o")
    private String output;
    @Param(name="key", optional=true)
    private String key;
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;
    public static final String SCOPE_EXTERNAL = "external";
    public static final String SCOPE_SHARED = "shared";
    public static final String SCOPE_APPLICATION = "application";
    public static final List<String> listOfOptionsForCommand = Arrays.asList("SERVICE-NAME", "IP-ADDRESS", "VM-ID", "SERVER-TYPE", "STATE", "SCOPE");

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Services services = this.serviceUtil.getServices();
        ArrayList<org.glassfish.paas.orchestrator.config.Service> matchedServices = new ArrayList<org.glassfish.paas.orchestrator.config.Service>();
        if (this.appName != null) {
            if (this.domain.getApplications().getApplication(this.appName) == null) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("No such application [" + this.appName + "] is deployed");
                return;
            }
            for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
                if (!(service instanceof ApplicationScopedService) || !this.appName.equals(((ApplicationScopedService)service).getApplicationName())) continue;
                if (this.type != null) {
                    if (!service.getType().equalsIgnoreCase(this.type)) continue;
                    if (this.scope != null) {
                        if (!this.scope.equals(this.getServiceScope(service))) continue;
                        matchedServices.add(service);
                        continue;
                    }
                    matchedServices.add(service);
                    continue;
                }
                if (this.scope != null) {
                    if (!this.scope.equals(this.getServiceScope(service))) continue;
                    matchedServices.add(service);
                    continue;
                }
                matchedServices.add(service);
            }
            block1: for (ServiceRef serviceRef : services.getServiceRefs()) {
                if (!this.appName.equals(serviceRef.getApplicationName())) continue;
                for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
                    if (!service.getServiceName().equals(serviceRef.getServiceName())) continue;
                    if (this.type != null) {
                        if (!service.getType().equalsIgnoreCase(this.type)) continue;
                        if (this.scope != null) {
                            if (!this.scope.equals(this.getServiceScope(service))) continue;
                            matchedServices.addAll(this.getServiceConfigurations(service));
                            continue block1;
                        }
                        matchedServices.addAll(this.getServiceConfigurations(service));
                        continue block1;
                    }
                    if (this.scope != null) {
                        if (this.scope.equals(this.getServiceScope(service))) {
                            matchedServices.addAll(this.getServiceConfigurations(service));
                            continue block1;
                        }
                        matchedServices.addAll(this.getServiceConfigurations(service));
                        continue block1;
                    }
                    matchedServices.addAll(this.getServiceConfigurations(service));
                    continue block1;
                }
            }
        } else {
            if (this.scope != null && this.scope.equals(SCOPE_APPLICATION)) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("Need application name in order to list application-scoped services");
                return;
            }
            for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
                if (this.type != null) {
                    if (!service.getType().equalsIgnoreCase(this.type)) continue;
                    if (this.scope != null) {
                        if (!this.scope.equals(this.getServiceScope(service))) continue;
                        matchedServices.add(service);
                        continue;
                    }
                    matchedServices.add(service);
                    continue;
                }
                if (this.scope != null) {
                    if (!this.scope.equals(this.getServiceScope(service))) continue;
                    matchedServices.add(service);
                    continue;
                }
                matchedServices.add(service);
            }
        }
        Properties extraProperties = new Properties();
        extraProperties.put("list", new ArrayList());
        if (matchedServices.size() > 0) {
            int heading_count = 0;
            ArrayList<String> headerList = new ArrayList<String>();
            if (this.output != null) {
                String[] outputheaders = this.output.split("[,]");
                boolean count = false;
                for (String s : outputheaders) {
                    if (!listOfOptionsForCommand.contains(s = s.trim().toUpperCase())) {
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setMessage("The column name [" + s.toLowerCase() + "] provided in --output is not valid.");
                        return;
                    }
                    headerList.add(s);
                }
            } else {
                headerList.addAll(listOfOptionsForCommand);
                if (this.type != null) {
                    if (this.scope != null) {
                        headerList.remove("SCOPE");
                        headerList.remove("SERVER-TYPE");
                    } else {
                        headerList.remove("SERVER-TYPE");
                    }
                } else if (this.scope != null) {
                    headerList.remove("SCOPE");
                }
            }
            ColumnFormatter cf = new ColumnFormatter();
            String[] headings = headerList.toArray(new String[headerList.size()]);
            heading_count = headerList.size();
            if (this.terse && !this.header) {
                String[] s = new String[headerList.size()];
                for (int i = 0; i < heading_count; ++i) {
                    s[i] = "";
                }
                cf = new ColumnFormatter(s);
            } else {
                cf = new ColumnFormatter(headings);
            }
            boolean foundRows = false;
            LinkedHashMap<String, HashMap> mapOfMaps = new LinkedHashMap<String, HashMap>();
            for (int i = 0; i < listOfOptionsForCommand.size(); ++i) {
                mapOfMaps.put(listOfOptionsForCommand.get(i), new HashMap());
            }
            HashMap<String, String> valueMap = new HashMap<String, String>();
            for (org.glassfish.paas.orchestrator.config.Service service : matchedServices) {
                foundRows = true;
                String cloudName = service.getServiceName();
                valueMap.put(listOfOptionsForCommand.get(0), cloudName);
                String ipAddress = service.getPropertyValue("ip-address");
                if (ipAddress == null) {
                    ipAddress = "-";
                }
                valueMap.put(listOfOptionsForCommand.get(1), ipAddress);
                String instanceID = service.getPropertyValue("vm-id");
                if (instanceID == null) {
                    instanceID = "-";
                }
                valueMap.put(listOfOptionsForCommand.get(2), instanceID);
                String serverType = service.getType();
                valueMap.put(listOfOptionsForCommand.get(3), serverType);
                String serviceType = null;
                String state = "-";
                if (service instanceof ApplicationScopedService) {
                    state = ((ApplicationScopedService)service).getState();
                    serviceType = SCOPE_APPLICATION;
                } else if (service instanceof SharedService) {
                    state = ((SharedService)service).getState();
                    serviceType = SCOPE_SHARED;
                } else if (service instanceof ExternalService) {
                    state = "-";
                    serviceType = SCOPE_EXTERNAL;
                }
                valueMap.put(listOfOptionsForCommand.get(4), state);
                valueMap.put(listOfOptionsForCommand.get(5), serviceType);
                for (int i = 0; i < listOfOptionsForCommand.size(); ++i) {
                    String option = listOfOptionsForCommand.get(i);
                    HashMap map = mapOfMaps.get(option);
                    map.put(valueMap.get("SERVICE-NAME"), valueMap.get(option));
                    mapOfMaps.put(option, map);
                }
                if (this.key != null) continue;
                if (this.output != null) {
                    Object[] outputstring = new String[heading_count];
                    int count = 0;
                    for (String s : headings) {
                        outputstring[count] = (String)valueMap.get(s);
                        ++count;
                    }
                    cf.addRow(outputstring);
                    continue;
                }
                if (this.type == null) {
                    if (this.scope == null) {
                        cf.addRow(new Object[]{cloudName, ipAddress, instanceID, serverType, state, serviceType});
                        continue;
                    }
                    if (!serviceType.equals(this.scope)) continue;
                    cf.addRow(new Object[]{cloudName, ipAddress, instanceID, serverType, state});
                    continue;
                }
                if (this.scope == null) {
                    cf.addRow(new Object[]{cloudName, ipAddress, instanceID, state, serviceType});
                    continue;
                }
                if (!serviceType.equals(this.scope)) continue;
                cf.addRow(new Object[]{cloudName, ipAddress, instanceID, state});
            }
            if (this.key != null) {
                this.key = this.key.trim().toUpperCase();
                if (!listOfOptionsForCommand.contains(this.key)) {
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage("The key [" + this.key.toLowerCase() + "] provided in --key is not valid.");
                    return;
                }
                LinkedHashMap sortedHashMap = new HashMap();
                sortedHashMap = this.sortHashMap((HashMap)mapOfMaps.get(this.key));
                mapOfMaps.put(this.key, sortedHashMap);
                for (String e : ((HashMap)sortedHashMap).keySet()) {
                    cf.addRow((Object[])this.generateOutputRow(headings, heading_count, e, mapOfMaps));
                }
            }
            if (foundRows) {
                report.setMessage(cf.toString());
                extraProperties.put("list", cf.getContent());
            } else {
                this.header = true;
                if (true) {
                    report.setMessage("Nothing to list.");
                }
            }
        } else {
            this.header = true;
            if (true) {
                report.setMessage("Nothing to list.");
            }
        }
        report.setExtraProperties(extraProperties);
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }

    private List<org.glassfish.paas.orchestrator.config.Service> getServiceConfigurations(org.glassfish.paas.orchestrator.config.Service service) {
        ArrayList<org.glassfish.paas.orchestrator.config.Service> services = new ArrayList<org.glassfish.paas.orchestrator.config.Service>();
        services.add(service);
        ServiceInfo parentServiceInfo = this.serviceUtil.getServiceInfo(service.getServiceName(), null);
        Set<ServiceInfo> serviceInfoSet = parentServiceInfo.getChildServices();
        for (ServiceInfo serviceInfo : serviceInfoSet) {
            org.glassfish.paas.orchestrator.config.Service svc = this.serviceUtil.getService(serviceInfo.getServiceName(), null);
            if (svc == null) continue;
            services.add(svc);
        }
        return services;
    }

    private String getServiceScope(org.glassfish.paas.orchestrator.config.Service service) {
        String scope = null;
        if (service instanceof ApplicationScopedService) {
            scope = SCOPE_APPLICATION;
        } else if (service instanceof SharedService) {
            scope = SCOPE_SHARED;
        } else if (service instanceof ExternalService) {
            scope = SCOPE_EXTERNAL;
        }
        return scope;
    }

    public LinkedHashMap sortHashMap(HashMap passedMap) {
        ArrayList mapKeys = new ArrayList(passedMap.keySet());
        ArrayList mapValues = new ArrayList(passedMap.values());
        Collections.sort(mapValues);
        Collections.sort(mapKeys);
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        block0: for (Object val : mapValues) {
            for (Object key : mapKeys) {
                String comp2;
                String comp1 = passedMap.get(key).toString();
                if (!comp1.equals(comp2 = val.toString())) continue;
                passedMap.remove(key);
                mapKeys.remove(key);
                sortedMap.put((String)key, (String)val);
                continue block0;
            }
        }
        return sortedMap;
    }

    public String[] generateOutputRow(String[] headings, int heading_count, String e, HashMap<String, HashMap> mapOfMaps) {
        String[] outputRow = new String[heading_count];
        int count = 0;
        HashMap map = null;
        for (String s : headings) {
            map = mapOfMaps.get(s);
            outputRow[count] = (String)map.get(e);
            ++count;
        }
        return outputRow;
    }
}

