/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.config.PaasApplication;
import org.glassfish.paas.orchestrator.config.PaasApplications;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="paas-deploy")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="paas-deploy", description="Deploy a PaaS enabled application")})
public class PaaSDeploy
implements AdminCommand {
    @Param(name="file", primary=true)
    private File archive;
    @Inject
    private ServiceOrchestratorImpl orchestrator;
    @Inject
    private ArchiveFactory archiveFactory;
    @Inject
    private ServiceUtil serviceUtil;
    protected static final Logger logger = LogDomains.getLogger(ServiceOrchestratorImpl.class, (String)"javax.org.glassfish.paas");

    public void execute(AdminCommandContext context) {
        ReadableArchive fileArchive = null;
        try {
            fileArchive = this.archiveFactory.openArchive(this.archive);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PaaSDeploymentContext dc = new PaaSDeploymentContext(this.archive.getName(), fileArchive);
        final String appName = dc.getAppName();
        ActionReport report = context.getActionReport();
        PaasApplications paasApplications = this.serviceUtil.getPaasApplications();
        for (PaasApplication paasApplication : paasApplications.getPaasApplications()) {
            if (!paasApplication.getAppName().equalsIgnoreCase(this.archive.getName())) continue;
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("A paas-enabled application with name [ " + this.archive.getName() + " ] is already deployed.");
            return;
        }
        this.orchestrator.preDeploy(this.archive.getName(), dc);
        this.orchestrator.deploy(this.archive.getName(), dc);
        this.orchestrator.postDeploy(this.archive.getName(), dc);
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<PaasApplications>(){

                public Object run(PaasApplications paasApplications) throws PropertyVetoException, TransactionFailure {
                    PaasApplication paasApplication = (PaasApplication)paasApplications.createChild(PaasApplication.class);
                    paasApplication.setAppName(appName);
                    paasApplication.setEnabled(true);
                    paasApplications.getPaasApplications().add(paasApplication);
                    return paasApplication;
                }
            }, (ConfigBeanProxy)paasApplications) == null) {
                logger.log(Level.SEVERE, "Error while persisting config during paas-deploy of application " + appName);
            }
        }
        catch (TransactionFailure transactionFailure) {
            logger.log(Level.SEVERE, "Error while persisting config during paas-deploy of application " + appName + ". Exception : " + transactionFailure.getMessage());
            return;
        }
    }
}

