/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.config.PaasApplication;
import org.glassfish.paas.orchestrator.config.PaasApplications;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="paas-undeploy")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="paas-undeploy", description="Undeploy a PaaS enabled application")})
public class PaaSUndeploy
implements AdminCommand {
    @Param(name="file", primary=true)
    private File archive;
    @Inject
    private ServiceOrchestratorImpl orchestrator;
    @Inject
    private ArchiveFactory archiveFactory;
    @Inject
    private ServiceUtil serviceUtil;

    public void execute(AdminCommandContext context) {
        ReadableArchive fileArchive = null;
        try {
            fileArchive = this.archiveFactory.openArchive(this.archive);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ActionReport report = context.getActionReport();
        PaasApplications paasApplications = this.serviceUtil.getPaasApplications();
        boolean appFound = false;
        for (PaasApplication paasApplication : paasApplications.getPaasApplications()) {
            if (!paasApplication.getAppName().equalsIgnoreCase(this.archive.getName())) continue;
            appFound = true;
        }
        if (!appFound) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("A paas-enabled application with name [ " + this.archive.getName() + " ] is not deployed.");
            return;
        }
        PaaSDeploymentContext dc = new PaaSDeploymentContext(this.archive.getName(), fileArchive);
        this.orchestrator.preUndeploy(this.archive.getName(), dc);
        this.orchestrator.undeploy(this.archive.getName(), dc);
        this.orchestrator.postUndeploy(this.archive.getName(), dc);
    }
}

