/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyVetoException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.config.ServiceProvisioningEngine;
import org.glassfish.paas.orchestrator.config.ServiceProvisioningEngines;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="register-service-provisioning-engine")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="register-service-provisioning-engine", description="Register Service Provisioning Engine")})
public class RegisterServiceProvisioningEngine
implements AdminCommand {
    @Param(name="type", optional=false)
    private String type;
    @Param(name="classname", primary=true)
    private String className;
    @Param(name="defaultservice", defaultValue="false", optional=true)
    private Boolean defaultService;
    @Param(name="force", defaultValue="false", optional=true)
    private Boolean force;
    @Param(name="property", optional=true, separator=58)
    private Properties properties;
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ServiceProvisioningEngines serviceProvisioningEngines = this.serviceUtil.getServiceProvisioningEngines();
        for (ServiceProvisioningEngine serviceProvisioningEngine : serviceProvisioningEngines.getServiceProvisioningEngines()) {
            if (!serviceProvisioningEngine.getClassName().equals(this.className)) continue;
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Duplicate key name. A service provisioning engine with name [ " + this.className + " ] is already registered.");
            return;
        }
        if (this.defaultService.booleanValue() && !this.force.booleanValue()) {
            for (ServiceProvisioningEngine serviceProvisioningEngine : serviceProvisioningEngines.getServiceProvisioningEngines()) {
                if (!Boolean.valueOf(serviceProvisioningEngine.getDefault()).booleanValue() || !this.type.equalsIgnoreCase(serviceProvisioningEngine.getType())) continue;
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)new RuntimeException("A service provisioning engine named [" + serviceProvisioningEngine.getClassName() + "] is already marked as default service provisioning engine " + "for type [" + this.type + "] , use --force=true to override the same"));
                return;
            }
        }
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ServiceProvisioningEngines>(){

                public Object run(ServiceProvisioningEngines serviceProvisioningEngines) throws PropertyVetoException, TransactionFailure {
                    Locale locale = Locale.getDefault();
                    ServiceProvisioningEngine serviceProvisioningEngine = (ServiceProvisioningEngine)serviceProvisioningEngines.createChild(ServiceProvisioningEngine.class);
                    serviceProvisioningEngine.setClassName(RegisterServiceProvisioningEngine.this.className);
                    serviceProvisioningEngine.setType(RegisterServiceProvisioningEngine.this.type.toUpperCase(locale));
                    serviceProvisioningEngine.setDefault(RegisterServiceProvisioningEngine.this.defaultService);
                    if (RegisterServiceProvisioningEngine.this.properties != null) {
                        for (Map.Entry<Object, Object> e : RegisterServiceProvisioningEngine.this.properties.entrySet()) {
                            Property prop = (Property)serviceProvisioningEngine.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            serviceProvisioningEngine.getProperty().add(prop);
                        }
                    }
                    if (RegisterServiceProvisioningEngine.this.defaultService.booleanValue() && RegisterServiceProvisioningEngine.this.force.booleanValue()) {
                        for (ServiceProvisioningEngine spe : serviceProvisioningEngines.getServiceProvisioningEngines()) {
                            if (!spe.getDefault() || !RegisterServiceProvisioningEngine.this.type.equalsIgnoreCase(spe.getType())) continue;
                            Transaction t = Transaction.getTransaction((ConfigBeanProxy)serviceProvisioningEngines);
                            ServiceProvisioningEngine spe_w = (ServiceProvisioningEngine)t.enroll((ConfigBeanProxy)spe);
                            spe_w.setDefault(false);
                            break;
                        }
                    }
                    serviceProvisioningEngines.getServiceProvisioningEngines().add(serviceProvisioningEngine);
                    return serviceProvisioningEngines;
                }
            }, (ConfigBeanProxy)serviceProvisioningEngines) == null) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)new RuntimeException("Unable to register service provisioning service"));
                return;
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
        catch (TransactionFailure transactionFailure) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)transactionFailure);
            return;
        }
    }
}

