/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.ServiceOrchestrator;
import org.glassfish.paas.orchestrator.config.ApplicationScopedService;
import org.glassfish.paas.orchestrator.config.Services;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_scale-service")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="_scale-service", description="Scale Services")})
public class ScaleService
implements AdminCommand {
    @Param(name="appname", optional=true)
    private String appName;
    @Param(name="servicename", optional=false)
    private String serviceName;
    @Param(name="scalecount", optional=false)
    private int scaleCount;
    @Inject
    private ServiceOrchestrator orchestrator;
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;

    public void execute(AdminCommandContext context) {
        boolean match;
        ActionReport report = context.getActionReport();
        if (this.scaleCount == 0) {
            report.setMessage("Invalid scale count.");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.appName != null && this.domain.getApplications().getApplication(this.appName) == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("No such application [" + this.appName + "] is deployed");
            return;
        }
        Services services = this.serviceUtil.getServices();
        if (this.appName != null) {
            if (this.domain.getApplications().getApplication(this.appName) == null) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("No such application [" + this.appName + "] is deployed");
                return;
            }
            match = false;
            for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
                if (!(service instanceof ApplicationScopedService) || !this.appName.equals(((ApplicationScopedService)service).getApplicationName()) || !this.serviceName.equals(service.getServiceName())) continue;
                match = true;
            }
            if (!match) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("No such service [" + this.serviceName + "" + "for application [" + this.appName + "] is deployed");
                return;
            }
        } else {
            match = false;
            for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
                if (service instanceof ApplicationScopedService || !this.serviceName.equals(service.getServiceName())) continue;
                match = true;
            }
            if (!match) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("No such service [" + this.serviceName + "]" + " is deployed");
                return;
            }
        }
        this.orchestrator.scaleService(this.appName, this.serviceName, this.scaleCount, null);
        report.setMessage("Scale Service called.");
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

