/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.config.ApplicationScopedService;
import org.glassfish.paas.orchestrator.config.Characteristic;
import org.glassfish.paas.orchestrator.config.Characteristics;
import org.glassfish.paas.orchestrator.config.Configuration;
import org.glassfish.paas.orchestrator.config.ExternalService;
import org.glassfish.paas.orchestrator.config.PaasApplications;
import org.glassfish.paas.orchestrator.config.ServiceProvisioningEngines;
import org.glassfish.paas.orchestrator.config.ServiceRef;
import org.glassfish.paas.orchestrator.config.Services;
import org.glassfish.paas.orchestrator.config.SharedService;
import org.glassfish.paas.orchestrator.provisioning.ServiceInfo;
import org.glassfish.paas.orchestrator.provisioning.ServiceScope;
import org.glassfish.paas.orchestrator.service.ConfiguredServiceImpl;
import org.glassfish.paas.orchestrator.service.ServiceStatus;
import org.glassfish.paas.orchestrator.service.ServiceType;
import org.glassfish.paas.orchestrator.service.metadata.Property;
import org.glassfish.paas.orchestrator.service.metadata.ServiceCharacteristics;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.TemplateIdentifier;
import org.glassfish.paas.orchestrator.service.spi.ConfiguredService;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServiceChangeEvent;
import org.glassfish.paas.orchestrator.service.spi.ServiceChangeListener;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ServiceUtil {
    private static ExecutorService threadPool = Executors.newCachedThreadPool();
    @Inject
    private Domain domain;
    @Inject
    private Habitat habitat;
    private static Logger logger = LogDomains.getLogger(ServiceOrchestratorImpl.class, (String)"javax.org.glassfish.paas");
    protected static final StringManager localStrings = StringManager.getManager(ServiceOrchestratorImpl.class);

    public static ExecutorService getThreadPool() {
        return threadPool;
    }

    public boolean isValidService(String serviceName, String appName) {
        ServiceInfo entry = this.getServiceInfo(serviceName, appName);
        return entry != null;
    }

    public void setProperty(String serviceName, String appName, final String propName, final String propValue) {
        block4: {
            org.glassfish.paas.orchestrator.config.Service matchingService = this.getService(serviceName, appName);
            if (matchingService != null) {
                try {
                    if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<org.glassfish.paas.orchestrator.config.Service>(){

                        public Object run(org.glassfish.paas.orchestrator.config.Service serviceConfig) throws PropertyVetoException, TransactionFailure {
                            org.jvnet.hk2.config.types.Property property = serviceConfig.getProperty(propName);
                            if (property != null) {
                                Transaction t = Transaction.getTransaction((ConfigBeanProxy)serviceConfig);
                                org.jvnet.hk2.config.types.Property p_w = (org.jvnet.hk2.config.types.Property)t.enroll((ConfigBeanProxy)property);
                                p_w.setValue(propValue);
                            } else {
                                org.jvnet.hk2.config.types.Property prop = (org.jvnet.hk2.config.types.Property)serviceConfig.createChild(org.jvnet.hk2.config.types.Property.class);
                                prop.setName(propName);
                                prop.setValue(propValue);
                                serviceConfig.getProperty().add(prop);
                            }
                            return serviceConfig;
                        }
                    }, (ConfigBeanProxy)matchingService) == null) {
                        String msg = "Unable to update property [" + propName + "] of service [" + serviceName + "]";
                        System.out.println(msg);
                        throw new RuntimeException(msg);
                    }
                    break block4;
                }
                catch (TransactionFailure transactionFailure) {
                    transactionFailure.printStackTrace();
                    throw new RuntimeException(transactionFailure.getMessage(), transactionFailure);
                }
            }
            throw new RuntimeException("Invalid service, no such service [" + serviceName + "] found");
        }
    }

    public void updateState(ProvisionedService service, String appName) {
        if (service.getChildServices() != null) {
            for (org.glassfish.paas.orchestrator.service.spi.Service childService : service.getChildServices()) {
                this.updateState(childService.getName(), appName, service.getStatus().toString());
            }
        }
        this.updateState(service.getName(), appName, service.getStatus().toString());
        this.fireServiceChangeEvent(this.getServiceChangeEventType(service.getStatus()), service);
    }

    private ServiceChangeEvent.Type getServiceChangeEventType(ServiceStatus status) {
        if (ServiceStatus.RUNNING.equals((Object)status) || ServiceStatus.STARTED.equals((Object)status)) {
            return ServiceChangeEvent.Type.STARTED;
        }
        if (ServiceStatus.STOPPED.equals((Object)status) || ServiceStatus.NOT_RUNNING.equals((Object)status)) {
            return ServiceChangeEvent.Type.STOPPED;
        }
        throw new RuntimeException("Unknown Service Status : " + (Object)((Object)status));
    }

    public void updateState(String serviceName, String appName, final String state) {
        org.glassfish.paas.orchestrator.config.Service matchingService = this.getService(serviceName, appName);
        if (matchingService != null) {
            if (matchingService instanceof ApplicationScopedService) {
                ApplicationScopedService appScopedService = (ApplicationScopedService)matchingService;
                try {
                    if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ApplicationScopedService>(){

                        public Object run(ApplicationScopedService serviceConfig) throws PropertyVetoException, TransactionFailure {
                            serviceConfig.setState(state);
                            return serviceConfig;
                        }
                    }, (ConfigBeanProxy)appScopedService) == null) {
                        String msg = "Unable to update state [" + state + "] of service [" + serviceName + "]";
                        System.out.println(msg);
                        throw new RuntimeException(msg);
                    }
                }
                catch (TransactionFailure transactionFailure) {
                    transactionFailure.printStackTrace();
                    throw new RuntimeException(transactionFailure.getMessage(), transactionFailure);
                }
            }
            if (matchingService instanceof SharedService) {
                SharedService sharedService = (SharedService)matchingService;
                try {
                    if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SharedService>(){

                        public Object run(SharedService serviceConfig) throws PropertyVetoException, TransactionFailure {
                            serviceConfig.setState(state);
                            return serviceConfig;
                        }
                    }, (ConfigBeanProxy)sharedService) == null) {
                        String msg = "Unable to update state [" + state + "] of service [" + serviceName + "]";
                        System.out.println(msg);
                        throw new RuntimeException(msg);
                    }
                }
                catch (TransactionFailure transactionFailure) {
                    transactionFailure.printStackTrace();
                    throw new RuntimeException(transactionFailure.getMessage(), transactionFailure);
                }
            }
        } else {
            throw new RuntimeException("Invalid service, no such service [" + serviceName + "] found");
        }
    }

    public List<String> getApplicationsUsingService(String service) {
        ArrayList<String> applications = new ArrayList<String>();
        ServiceInfo serviceInfo = this.getServiceInfo(service, null);
        if (serviceInfo != null) {
            for (ServiceRef serviceRef : this.getServices().getServiceRefs()) {
                if (!serviceRef.getServiceName().equals(service)) continue;
                applications.add(serviceRef.getApplicationName());
            }
        }
        return applications;
    }

    public String getServiceType(String serviceName, String appName) {
        ServiceInfo entry = this.getServiceInfo(serviceName, appName);
        if (entry != null) {
            return entry.getServerType();
        }
        return null;
    }

    public String getIPAddress(String serviceName, String appName) {
        ServiceInfo entry = this.getServiceInfo(serviceName, appName);
        if (entry != null) {
            return entry.getIpAddress();
        }
        return null;
    }

    public String getInstanceID(String serviceName, String appName) {
        ServiceInfo entry = this.getServiceInfo(serviceName, appName);
        if (entry != null) {
            return entry.getInstanceId();
        }
        return null;
    }

    public String getProperty(String serviceName, String appName, String propertyName) {
        ServiceInfo entry = this.getServiceInfo(serviceName, appName);
        if (entry != null) {
            return entry.getProperties().get(propertyName);
        }
        return null;
    }

    public ServiceInfo getServiceInfo(String serviceName, String appName) {
        org.glassfish.paas.orchestrator.config.Service matchingService = null;
        ServiceInfo serviceInfo = null;
        matchingService = this.getService(serviceName, appName);
        if (matchingService != null) {
            serviceInfo = new ServiceInfo();
            serviceInfo.setAppName(appName);
            serviceInfo.setServiceName(matchingService.getServiceName());
            if (matchingService.getProperty() != null) {
                if (matchingService.getProperty("ip-address") != null) {
                    serviceInfo.setIpAddress(matchingService.getProperty("ip-address").getValue());
                }
                if (matchingService.getProperty("vm-id") != null) {
                    serviceInfo.setInstanceId(matchingService.getProperty("vm-id").getValue());
                }
                List<org.jvnet.hk2.config.types.Property> properties = matchingService.getProperty();
                for (org.jvnet.hk2.config.types.Property property : properties) {
                    serviceInfo.getProperties().put(property.getName(), property.getValue());
                }
            }
            if (matchingService instanceof ApplicationScopedService) {
                serviceInfo.setState(((ApplicationScopedService)matchingService).getState());
            } else if (matchingService instanceof SharedService) {
                serviceInfo.setState(((SharedService)matchingService).getState());
            }
            serviceInfo.setServerType(matchingService.getType());
            for (org.glassfish.paas.orchestrator.config.Service service : this.getServices().getServices()) {
                ApplicationScopedService childService;
                if (service.getParentService() == null || !service.getParentService().equals(serviceName) || appName != null && matchingService instanceof ApplicationScopedService && (!(service instanceof ApplicationScopedService) || !appName.equals((childService = (ApplicationScopedService)service).getApplicationName()))) continue;
                ServiceInfo childServiceInfo = this.getServiceInfo(service.getServiceName(), appName);
                serviceInfo.addChildService(childServiceInfo);
            }
        }
        return serviceInfo;
    }

    public ConfiguredService getExternalService(String serviceName) {
        Services services = this.getServices();
        ExternalService externalService = null;
        for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
            if (!service.getServiceName().equals(serviceName) || !(service instanceof ExternalService)) continue;
            externalService = (ExternalService)service;
            break;
        }
        if (externalService == null) {
            throw new RuntimeException("No external service by name " + serviceName + " found");
        }
        ServiceDescription sd = new ServiceDescription();
        sd.setServiceScope(ServiceScope.EXTERNAL);
        sd.setName(externalService.getServiceName());
        sd.setServiceType(externalService.getType());
        Properties properties = new Properties();
        if (externalService.getConfigurations() != null && externalService.getConfigurations().getConfiguration() != null) {
            ArrayList<Property> configurationList = new ArrayList<Property>();
            for (Configuration config : externalService.getConfigurations().getConfiguration()) {
                Property property = new Property();
                property.setName(config.getName());
                property.setValue(config.getValue());
                configurationList.add(property);
                properties.put(property.getName(), property.getValue());
            }
            sd.setConfigurations(configurationList);
        }
        return new ConfiguredServiceImpl(externalService.getServiceName(), this.getServiceType(externalService.getType()), sd, properties);
    }

    public org.glassfish.paas.orchestrator.config.Service getService(String serviceName, String appName) {
        org.glassfish.paas.orchestrator.config.Service matchingService = null;
        Services services = this.getServices();
        block0: for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
            if (!service.getServiceName().equals(serviceName)) continue;
            if (appName != null) {
                if (service instanceof ApplicationScopedService) {
                    String applicationName = ((ApplicationScopedService)service).getApplicationName();
                    if (!appName.equals(applicationName)) break;
                    matchingService = service;
                    break;
                }
                for (ServiceRef serviceRef : services.getServiceRefs()) {
                    if (!appName.equals(serviceRef.getApplicationName()) || !serviceRef.getServiceName().equals(serviceName)) continue;
                    matchingService = service;
                    break block0;
                }
                break;
            }
            matchingService = service;
            break;
        }
        return matchingService;
    }

    public Services getServices() {
        Services services = (Services)this.domain.getExtensionByType(Services.class);
        if (services == null) {
            try {
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Domain>(){

                    public Object run(Domain param) throws PropertyVetoException, TransactionFailure {
                        Services services = (Services)param.createChild(Services.class);
                        param.getExtensions().add(services);
                        return services;
                    }
                }, (ConfigBeanProxy)this.domain) == null) {
                    System.out.println("Unable to create 'services' config");
                }
            }
            catch (TransactionFailure transactionFailure) {
                System.out.println("Unable to create 'services' config due to : " + transactionFailure.getMessage());
                throw new RuntimeException(transactionFailure.getMessage(), transactionFailure);
            }
        }
        services = (Services)this.domain.getExtensionByType(Services.class);
        return services;
    }

    public void unregisterServiceInfo(final String serviceName, final String appName) {
        Services services = this.getServices();
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Services>(){

                public Object run(Services servicesConfig) throws PropertyVetoException, TransactionFailure {
                    org.glassfish.paas.orchestrator.config.Service deletedService = null;
                    for (org.glassfish.paas.orchestrator.config.Service service : servicesConfig.getServices()) {
                        if (!serviceName.equals(service.getServiceName())) continue;
                        if (service instanceof ApplicationScopedService) {
                            ApplicationScopedService appScopedService = (ApplicationScopedService)service;
                            if (!appScopedService.getApplicationName().equals(appName)) continue;
                            servicesConfig.getServices().remove(appScopedService);
                            deletedService = appScopedService;
                            break;
                        }
                        servicesConfig.getServices().remove(service);
                        deletedService = service;
                        break;
                    }
                    return deletedService;
                }
            }, (ConfigBeanProxy)services) == null) {
                String msg = "Unable to remove service [" + serviceName + "]";
                System.out.println(msg);
                throw new RuntimeException(msg);
            }
        }
        catch (TransactionFailure transactionFailure) {
            transactionFailure.printStackTrace();
            throw new RuntimeException(transactionFailure.getMessage(), transactionFailure);
        }
    }

    public void registerServiceReference(final String serviceName, final String appName) {
        Services services = this.getServices();
        boolean serviceFound = false;
        for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
            if ((!service.getServiceName().equals(serviceName) || !(service instanceof SharedService)) && !(service instanceof ExternalService)) continue;
            serviceFound = true;
            break;
        }
        if (serviceFound) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Services>(){

                    public Object run(Services param) throws PropertyVetoException, TransactionFailure {
                        ServiceRef serviceRef = (ServiceRef)param.createChild(ServiceRef.class);
                        serviceRef.setApplicationName(appName);
                        serviceRef.setServiceName(serviceName);
                        param.getServiceRefs().add(serviceRef);
                        return param;
                    }
                }, (ConfigBeanProxy)services);
            }
            catch (TransactionFailure exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
        } else {
            throw new RuntimeException("no shared or external service by name [" + serviceName + "] found.");
        }
    }

    public void unregisterServiceReference(final String serviceName, final String appName) {
        Services services = this.getServices();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Services>(){

                public Object run(Services param) throws PropertyVetoException, TransactionFailure {
                    ServiceRef serviceRefToUnregister = null;
                    for (ServiceRef serviceRef : param.getServiceRefs()) {
                        if (!serviceRef.getServiceName().equals(serviceName) || !serviceRef.getApplicationName().equals(appName)) continue;
                        serviceRefToUnregister = serviceRef;
                        break;
                    }
                    if (serviceRefToUnregister == null) {
                        throw new RuntimeException("no shared or external service by name [" + serviceName + "] is referred" + "by application [" + appName + "]");
                    }
                    param.getServiceRefs().remove(serviceRefToUnregister);
                    return param;
                }
            }, (ConfigBeanProxy)services);
        }
        catch (TransactionFailure exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public void registerService(final ServiceInfo entry) {
        Services services = this.getServices();
        try {
            if (entry.getAppName() == null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Services>(){

                    public Object run(Services servicesConfig) throws PropertyVetoException, TransactionFailure {
                        SharedService service = (SharedService)servicesConfig.createChild(SharedService.class);
                        service.setServiceName(entry.getServiceName());
                        service.setType(entry.getServerType());
                        if (entry.getParentService() != null) {
                            service.setParentService(entry.getParentService().getServiceName());
                        }
                        service.setState(entry.getState());
                        Map<String, String> properties = entry.getProperties();
                        if (properties != null) {
                            for (Map.Entry<String, String> entry2 : properties.entrySet()) {
                                org.jvnet.hk2.config.types.Property prop = (org.jvnet.hk2.config.types.Property)service.createChild(org.jvnet.hk2.config.types.Property.class);
                                prop.setName(entry2.getKey());
                                prop.setValue(entry2.getValue());
                                service.getProperty().add(prop);
                            }
                        }
                        servicesConfig.getServices().add(service);
                        return service;
                    }
                }, (ConfigBeanProxy)services);
            } else if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Services>(){

                public Object run(Services servicesConfig) throws PropertyVetoException, TransactionFailure {
                    ApplicationScopedService service = (ApplicationScopedService)servicesConfig.createChild(ApplicationScopedService.class);
                    service.setServiceName(entry.getServiceName());
                    service.setType(entry.getServerType());
                    if (entry.getAppName() != null) {
                        service.setApplicationName(entry.getAppName());
                    }
                    if (entry.getParentService() != null) {
                        service.setParentService(entry.getParentService().getServiceName());
                    }
                    service.setState(entry.getState());
                    Map<String, String> properties = entry.getProperties();
                    if (properties != null) {
                        for (Map.Entry<String, String> entry2 : properties.entrySet()) {
                            org.jvnet.hk2.config.types.Property prop = (org.jvnet.hk2.config.types.Property)service.createChild(org.jvnet.hk2.config.types.Property.class);
                            prop.setName(entry2.getKey());
                            prop.setValue(entry2.getValue());
                            service.getProperty().add(prop);
                        }
                    }
                    servicesConfig.getServices().add(service);
                    return service;
                }
            }, (ConfigBeanProxy)services) == null) {
                String msg = "Unable to register service [" + entry.getServiceName() + "]";
                logger.log(Level.WARNING, msg);
                throw new RuntimeException(msg);
            }
        }
        catch (TransactionFailure exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public ServiceStatus getServiceStatus(ServiceInfo entry) {
        if (entry.getState() != null && entry.getState().equalsIgnoreCase(ServiceStatus.RUNNING.toString())) {
            return ServiceStatus.RUNNING;
        }
        if (entry.getState() != null && entry.getState().equalsIgnoreCase(ServiceStatus.STARTING.toString())) {
            return ServiceStatus.STARTING;
        }
        if (entry.getState() != null && entry.getState().equalsIgnoreCase(ServiceStatus.STOPPED.toString())) {
            return ServiceStatus.STOPPED;
        }
        if (entry.getState() != null && entry.getState().equalsIgnoreCase(ServiceStatus.STOPPED.toString())) {
            return ServiceStatus.STOPPED;
        }
        return ServiceStatus.UNKNOWN;
    }

    public ServiceProvisioningEngines getServiceProvisioningEngines() {
        ServiceProvisioningEngines spes = (ServiceProvisioningEngines)this.domain.getExtensionByType(ServiceProvisioningEngines.class);
        if (spes == null) {
            try {
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Domain>(){

                    public Object run(Domain param) throws PropertyVetoException, TransactionFailure {
                        ServiceProvisioningEngines spes = (ServiceProvisioningEngines)param.createChild(ServiceProvisioningEngines.class);
                        param.getExtensions().add(spes);
                        return spes;
                    }
                }, (ConfigBeanProxy)this.domain) == null) {
                    logger.log(Level.SEVERE, "unable.tocreate.spe");
                }
            }
            catch (TransactionFailure transactionFailure) {
                logger.log(Level.SEVERE, "unable.tocreate.spe", transactionFailure);
                throw new RuntimeException(transactionFailure.getMessage(), transactionFailure);
            }
        }
        spes = (ServiceProvisioningEngines)this.domain.getExtensionByType(ServiceProvisioningEngines.class);
        return spes;
    }

    public ServiceDescription getSharedServiceDescription(ServiceInfo serviceInfo) {
        ServiceDescription sd = null;
        org.glassfish.paas.orchestrator.config.Service service = this.getService(serviceInfo.getServiceName(), serviceInfo.getAppName());
        if (service != null) {
            if (service instanceof SharedService) {
                Property property;
                SharedService sharedService = (SharedService)service;
                Object characteristicsOrTemplate = null;
                Characteristics characteristics = sharedService.getCharacteristics();
                if (characteristics != null) {
                    if (characteristics.getCharacteristic() != null) {
                        ArrayList<Property> serviceCharacteristicsList = new ArrayList<Property>();
                        for (Characteristic characteristic : characteristics.getCharacteristic()) {
                            property = new Property(characteristic.getName(), characteristic.getValue());
                            serviceCharacteristicsList.add(property);
                        }
                        ServiceCharacteristics serviceCharacteristics = new ServiceCharacteristics();
                        serviceCharacteristics.setServiceCharacteristics(serviceCharacteristicsList);
                        characteristicsOrTemplate = serviceCharacteristics;
                    }
                } else if (sharedService.getTemplate() != null) {
                    TemplateIdentifier tid = new TemplateIdentifier();
                    tid.setId(sharedService.getTemplate());
                    characteristicsOrTemplate = tid;
                }
                ArrayList<Property> configuration = null;
                if (sharedService.getConfigurations() != null && sharedService.getConfigurations().getConfiguration() != null) {
                    configuration = new ArrayList<Property>();
                    for (Configuration config : sharedService.getConfigurations().getConfiguration()) {
                        property = new Property(config.getName(), config.getValue());
                        configuration.add(property);
                    }
                }
                sd = new ServiceDescription(sharedService.getServiceName(), null, null, characteristicsOrTemplate, configuration);
                sd.setVirtualClusterName(serviceInfo.getServiceName());
            }
        } else {
            throw new RuntimeException("No such service [" + serviceInfo.getServiceName() + "] is available");
        }
        return sd;
    }

    public ServiceType getServiceType(String serviceTypeString) {
        Collection serviceTypes = this.habitat.getAllByContract(ServiceType.class);
        for (ServiceType serviceType : serviceTypes) {
            if (!serviceType.toString().equals(serviceTypeString)) continue;
            return serviceType;
        }
        throw new RuntimeException("Unable to determine the type");
    }

    public void unregisterService(String appName, org.glassfish.paas.orchestrator.service.spi.Service service) {
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setServiceName(service.getName());
        serviceInfo.setAppName(appName);
        serviceInfo.setInstanceId(service.getServiceProperties().getProperty("vm-id"));
        serviceInfo.setIpAddress(service.getServiceProperties().getProperty("ip-address"));
        serviceInfo.setServerType(service.getServiceType().toString());
        if (service instanceof ProvisionedService) {
            serviceInfo.setState(((ProvisionedService)service).getStatus().toString());
        }
        this.unregisterServiceInfo(service.getName(), appName);
        if (service.getChildServices() != null) {
            for (org.glassfish.paas.orchestrator.service.spi.Service serviceNode : service.getChildServices()) {
                this.unregisterServiceInfo(serviceNode.getName(), appName);
            }
        }
    }

    public void unregisterService(ServiceInfo serviceInfo) {
        this.unregisterServiceInfo(serviceInfo.getServiceName(), serviceInfo.getAppName());
        if (serviceInfo.getChildServices() != null) {
            for (ServiceInfo serviceNode : serviceInfo.getChildServices()) {
                this.unregisterServiceInfo(serviceNode.getServiceName(), serviceNode.getAppName());
            }
        }
    }

    public void registerService(String appName, org.glassfish.paas.orchestrator.service.spi.Service service, org.glassfish.paas.orchestrator.service.spi.Service parentService) {
        ServiceInfo parentServiceInfo = null;
        if (parentService != null) {
            parentServiceInfo = this.createServiceInfo(appName, parentService, null);
        }
        ServiceInfo serviceInfo = this.createServiceInfo(appName, service, parentServiceInfo);
        this.registerService(serviceInfo);
        if (service.getChildServices() != null) {
            for (org.glassfish.paas.orchestrator.service.spi.Service serviceNode : service.getChildServices()) {
                ServiceInfo serviceNodeInfo = this.createServiceInfo(appName, serviceNode, serviceInfo);
                serviceInfo.addChildService(serviceNodeInfo);
                this.registerService(serviceNodeInfo);
            }
        }
    }

    public void fireServiceChangeEvent(ServiceChangeEvent.Type type, org.glassfish.paas.orchestrator.service.spi.Service ps) {
        for (ServiceChangeListener listener : this.getServiceChangeListeners()) {
            try {
                listener.onEvent(new ServiceChangeEvent(type, this, null, ps));
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINEST, localStrings.getString("failure.listener.event"), e);
            }
        }
    }

    private Collection<ServiceChangeListener> getServiceChangeListeners() {
        return this.habitat.getAllByContract(ServiceChangeListener.class);
    }

    private ServiceInfo createServiceInfo(String appName, org.glassfish.paas.orchestrator.service.spi.Service serviceNode, ServiceInfo parentServiceInfo) {
        Properties serviceProperties;
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setServiceName(serviceNode.getName());
        serviceInfo.setAppName(appName);
        if (serviceNode.getServiceProperties().getProperty("vm-id") != null) {
            serviceInfo.setInstanceId(serviceNode.getServiceProperties().getProperty("vm-id"));
        }
        if (serviceNode.getServiceProperties().getProperty("ip-address") != null) {
            serviceInfo.setIpAddress(serviceNode.getServiceProperties().getProperty("ip-address"));
        }
        serviceInfo.setServerType(serviceNode.getServiceType().toString());
        if (serviceNode instanceof ProvisionedService) {
            serviceInfo.setState(((ProvisionedService)serviceNode).getStatus().toString());
        }
        if ((serviceProperties = serviceNode.getServiceProperties()) != null) {
            for (String key : serviceProperties.stringPropertyNames()) {
                serviceInfo.setProperty(key, (String)serviceProperties.get(key));
            }
        }
        serviceInfo.setParentService(parentServiceInfo);
        return serviceInfo;
    }

    public PaasApplications getPaasApplications() {
        PaasApplications paasApplications = (PaasApplications)this.domain.getExtensionByType(PaasApplications.class);
        if (paasApplications == null) {
            try {
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Domain>(){

                    public Object run(Domain param) throws PropertyVetoException, TransactionFailure {
                        PaasApplications paasApplications = (PaasApplications)param.createChild(PaasApplications.class);
                        param.getExtensions().add(paasApplications);
                        return paasApplications;
                    }
                }, (ConfigBeanProxy)this.domain) == null) {
                    logger.log(Level.SEVERE, "unable.tocreate.paasapplications");
                }
            }
            catch (TransactionFailure transactionFailure) {
                logger.log(Level.SEVERE, "unable.tocreate.paasapplications", transactionFailure);
                throw new RuntimeException(transactionFailure.getMessage(), transactionFailure);
            }
        }
        paasApplications = (PaasApplications)this.domain.getExtensionByType(PaasApplications.class);
        return paasApplications;
    }
}

