/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.provisioning.ServiceScope;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServiceChangeEvent;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class SharedServiceLazyInitializer {
    @Inject
    private ServiceUtil serviceUtil;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private Habitat habitat;
    @Inject
    private ServiceOrchestratorImpl serviceOrchestrator;
    private static Logger logger = LogDomains.getLogger(ServiceOrchestratorImpl.class, (String)"javax.org.glassfish.paas");
    static final StringManager localStrings = StringManager.getManager(ServiceOrchestratorImpl.class);

    public ProvisionedService provisionService(ServiceDescription sd, ActionReport report) {
        if (report == null) {
            report = (ActionReport)this.habitat.getComponent(ActionReport.class);
        }
        String virtualClusterName = sd.getName();
        ActionReport actionReport = (ActionReport)this.habitat.getComponent(ActionReport.class);
        CommandRunner.CommandInvocation commandInvocation = this.commandRunner.getCommandInvocation("create-cluster", actionReport);
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.add((Object)"DEFAULT", (Object)virtualClusterName);
        commandInvocation.parameters(parameterMap).execute();
        Object[] args = new Object[]{virtualClusterName, actionReport.getMessage()};
        logger.log(Level.INFO, "create.cluster.exec.output", args);
        if (actionReport.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
            if (actionReport.getFailureCause() != null) {
                report.setFailureCause(actionReport.getFailureCause());
            }
            report.setMessage(actionReport.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            logger.log(Level.WARNING, localStrings.getString("unable.create.cluster", (Object)virtualClusterName), report.getFailureCause());
            return null;
        }
        sd.setVirtualClusterName(virtualClusterName);
        ServicePlugin defaultPlugin = this.serviceOrchestrator.getPlugin(sd);
        sd.setPlugin(defaultPlugin);
        sd.setServiceScope(ServiceScope.SHARED);
        DeploymentContext dc = null;
        PaaSDeploymentContext pdc = new PaaSDeploymentContext(null, dc);
        ProvisionedService ps = defaultPlugin.provisionService(sd, pdc);
        Properties properties = ps.getServiceProperties();
        this.serviceUtil.updateState(sd.getName(), null, ps.getStatus().toString());
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            this.serviceUtil.setProperty(sd.getName(), null, (String)e.getKey(), (String)e.getValue());
        }
        this.registerSharedService(ps);
        return ps;
    }

    public ProvisionedService provisionService(String serviceName) {
        ServiceDescription sd = this.serviceOrchestrator.getSharedServiceDescription(serviceName);
        return this.provisionService(sd, null);
    }

    private void registerSharedService(ProvisionedService ps) {
        if (ps.getChildServices() != null && ps.getChildServices().size() > 0) {
            for (org.glassfish.paas.orchestrator.service.spi.Service childPS : ps.getChildServices()) {
                this.serviceUtil.registerService(null, childPS, ps);
            }
        }
        this.serviceUtil.fireServiceChangeEvent(ServiceChangeEvent.Type.CREATED, ps);
    }
}

