/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.config.Services;
import org.glassfish.paas.orchestrator.config.SharedService;
import org.glassfish.paas.orchestrator.provisioning.ServiceInfo;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.service.ServiceStatus;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="start-shared-service")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="start-shared-service", description="Start a shared service")})
public class StartSharedService
implements AdminCommand {
    @Param(name="servicename", primary=true)
    private String serviceName;
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;
    @Inject
    private ServiceOrchestratorImpl orchestrator;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        boolean sharedServiceFound = false;
        Services services = (Services)this.domain.getExtensionByType(Services.class);
        if (services != null) {
            for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
                SharedService sharedService;
                if (!(service instanceof SharedService) || !(sharedService = (SharedService)service).getServiceName().equalsIgnoreCase(this.serviceName)) continue;
                sharedServiceFound = true;
                if (sharedService.getState().equalsIgnoreCase(ServiceStatus.RUNNING.toString())) {
                    report.setMessage("A shared service by name [" + sharedService.getServiceName() + "] is already running");
                    report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    return;
                }
                ServiceInfo serviceInfo = this.serviceUtil.getServiceInfo(this.serviceName, null);
                ServiceDescription serviceDescription = this.orchestrator.getSharedServiceDescription(this.serviceName);
                ServicePlugin plugin = serviceDescription.getPlugin();
                ProvisionedService provisionedService = plugin.startService(serviceDescription, serviceInfo);
                if (provisionedService != null) {
                    this.orchestrator.addSharedService(this.serviceName, provisionedService);
                    this.serviceUtil.updateState(provisionedService, null);
                    continue;
                }
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("Unable to start the shared service [" + this.serviceName + "]");
                return;
            }
            if (!sharedServiceFound) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("A shared service by name [" + this.serviceName + "] does not exist.");
                return;
            }
        } else {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("A shared service by name [" + this.serviceName + "] does not exist.");
            return;
        }
    }
}

