/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.config.ServiceRef;
import org.glassfish.paas.orchestrator.config.Services;
import org.glassfish.paas.orchestrator.config.SharedService;
import org.glassfish.paas.orchestrator.provisioning.ServiceInfo;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.service.ServiceStatus;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="stop-shared-service")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="stop-shared-service", description="Stop a shared service")})
public class StopSharedService
implements AdminCommand {
    @Param(name="servicename", primary=true)
    private String serviceName;
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;
    @Inject
    private ServiceOrchestratorImpl orchestrator;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        boolean sharedServiceFound = false;
        Services services = (Services)this.domain.getExtensionByType(Services.class);
        if (services != null) {
            for (org.glassfish.paas.orchestrator.config.Service service : services.getServices()) {
                ProvisionedService ps;
                SharedService sharedService;
                if (!(service instanceof SharedService) || !(sharedService = (SharedService)service).getServiceName().equalsIgnoreCase(this.serviceName)) continue;
                sharedServiceFound = true;
                if (sharedService.getState().equalsIgnoreCase(ServiceStatus.STOPPED.toString())) {
                    report.setMessage("A shared service by name [" + sharedService.getServiceName() + "] is not running.");
                    report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    return;
                }
                String appName = null;
                boolean appEnabled = false;
                List<ServiceRef> serviceRefList = services.getServiceRefs();
                for (ServiceRef serviceRef : serviceRefList) {
                    if (!this.serviceName.equalsIgnoreCase(serviceRef.getServiceName()) || (appName = serviceRef.getApplicationName()) == null) continue;
                    Clusters clusters = this.domain.getClusters();
                    List clusterList = clusters.getCluster();
                    for (Cluster cluster : clusterList) {
                        ApplicationRef applicationRef = cluster.getApplicationRef(appName);
                        if (applicationRef == null || !"true".equalsIgnoreCase(applicationRef.getEnabled())) continue;
                        appEnabled = true;
                        report.setMessage("A shared service by name [" + this.serviceName + "] is used by an application " + "[" + appName + "].");
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        return;
                    }
                }
                if (appEnabled) continue;
                ServiceInfo serviceInfo = this.serviceUtil.getServiceInfo(this.serviceName, null);
                ServiceDescription serviceDescription = this.orchestrator.getSharedServiceDescription(this.serviceName);
                ServicePlugin plugin = serviceDescription.getPlugin();
                boolean serviceStopped = plugin.stopService(ps = this.orchestrator.getSharedService(this.serviceName), serviceInfo);
                if (serviceStopped) {
                    this.orchestrator.removeSharedService(this.serviceName);
                    this.serviceUtil.updateState(ps, null);
                    continue;
                }
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("Unable to stop shared service [" + this.serviceName + "]");
                return;
            }
            if (!sharedServiceFound) {
                report.setMessage("A shared service by name [" + this.serviceName + "] does not exist. ");
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return;
            }
        } else {
            report.setMessage("A shared service by name [" + this.serviceName + "] does not exist.");
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
    }
}

