/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.provisioning.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.orchestrator.config.ServiceProvisioningEngine;
import org.glassfish.paas.orchestrator.config.ServiceProvisioningEngines;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="unregister-service-provisioning-engine")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="unregister-service-provisioning-engine", description="Unregister Service Provisioning Engine")})
public class UnregisterServiceProvisioningEngine
implements AdminCommand {
    @Param(name="classname", primary=true)
    private String classname;
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;

    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();
        ServiceProvisioningEngines serviceProvisioningEngines = this.serviceUtil.getServiceProvisioningEngines();
        boolean found = false;
        for (final ServiceProvisioningEngine serviceProvisioningEngine : serviceProvisioningEngines.getServiceProvisioningEngines()) {
            if (!serviceProvisioningEngine.getClassName().equals(this.classname)) continue;
            found = true;
            try {
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ServiceProvisioningEngines>(){

                    public Object run(ServiceProvisioningEngines param) throws PropertyVetoException, TransactionFailure {
                        param.getServiceProvisioningEngines().remove(serviceProvisioningEngine);
                        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        report.setMessage("Deleted service-provisioning-engine [" + UnregisterServiceProvisioningEngine.this.classname + "]");
                        return serviceProvisioningEngine;
                    }
                }, (ConfigBeanProxy)serviceProvisioningEngines) != null) continue;
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)new RuntimeException("Deleting service-provisioning engine [" + this.classname + "] failed"));
                return;
            }
            catch (TransactionFailure transactionFailure) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)transactionFailure);
                return;
            }
        }
        if (!found) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)new RuntimeException("No service-provisioning-engine by name [" + this.classname + "] is available"));
            return;
        }
    }
}

