/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.service;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.internal.api.PostStartup;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.config.ExternalService;
import org.glassfish.paas.orchestrator.config.Services;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.service.spi.ConfiguredService;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Scoped(value=Singleton.class)
@Service
public class ServicesConfigListener
implements ConfigListener,
PostConstruct,
PreDestroy,
PostStartup {
    @Inject
    private Domain domain;
    @Inject
    private ServiceUtil serviceUtil;
    @Inject
    private ServiceOrchestratorImpl serviceOrchestrator;
    @Inject
    private CommandRunner commandRunner;
    private static final Logger logger = LogDomains.getLogger(ServiceOrchestratorImpl.class, (String)"javax.org.glassfish.paas");

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new PropertyChangeHandler(events), (Logger)logger);
    }

    public void postConstruct() {
        this.addListenerToServices();
    }

    private void addListenerToServices() {
        Services services = this.serviceUtil.getServices();
        if (services != null) {
            ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)services);
            bean.addListener((ConfigListener)this);
        } else {
            logger.log(Level.WARNING, "unable.to.register.listenersto.servicesconfig");
        }
    }

    public void preDestroy() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyChangeHandler
    implements Changed {
        PropertyChangeEvent[] events;

        private PropertyChangeHandler(PropertyChangeEvent[] events) {
            this.events = events;
        }

        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
            NotProcessed np = null;
            Object[] args = new Object[]{changedType.getName(), changedInstance};
            switch (type) {
                case ADD: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "added.instance", args);
                    }
                    np = this.handleAddEvent(changedInstance);
                    break;
                }
                case CHANGE: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "changed.instance", args);
                    }
                    np = this.handleChangeEvent(changedInstance);
                    break;
                }
                case REMOVE: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "removed.instance", args);
                    }
                    np = this.handleRemoveEvent(changedInstance);
                    break;
                }
                default: {
                    np = new NotProcessed("Unrecognized type of change: " + type);
                }
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleAddEvent(T instance) {
            NotProcessed np = null;
            if (instance instanceof ExternalService) {
                ExternalService externalService = (ExternalService)instance;
                ConfiguredService configuredService = ServicesConfigListener.this.serviceUtil.getExternalService(externalService.getServiceName());
                ServicesConfigListener.this.serviceOrchestrator.addExternalService(externalService.getServiceName(), configuredService);
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleRemoveEvent(T instance) {
            NotProcessed np = null;
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
            NotProcessed np = null;
            return np;
        }
    }
}

