/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.service.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.annotation.XmlElement;
import org.glassfish.paas.orchestrator.service.metadata.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceCharacteristics {
    private List<Property> serviceCharacteristics;

    public ServiceCharacteristics() {
    }

    public ServiceCharacteristics(List<Property> characteristics) {
        this.setServiceCharacteristics(characteristics);
    }

    public ServiceCharacteristics(ServiceCharacteristics other) {
        this.cloneServiceCharacteristics(other);
    }

    @XmlElement(name="characteristic")
    public List<Property> getServiceCharacteristics() {
        return this.serviceCharacteristics;
    }

    public Properties all() {
        Properties props = new Properties();
        for (Property characteristic : this.getServiceCharacteristics()) {
            props.setProperty(characteristic.getName(), characteristic.getValue());
        }
        return props;
    }

    public void setServiceCharacteristics(List<Property> serviceCharacteristics) {
        this.serviceCharacteristics = serviceCharacteristics;
    }

    private void cloneServiceCharacteristics(ServiceCharacteristics other) {
        this.serviceCharacteristics = new ArrayList<Property>();
        for (Property property : other.getServiceCharacteristics()) {
            this.serviceCharacteristics.add(new Property(property.getName(), property.getValue()));
        }
    }

    public String getCharacteristic(String name) {
        for (Property p : this.serviceCharacteristics) {
            if (!p.getName().equals(name)) continue;
            return p.getValue();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceCharacteristics)) {
            return false;
        }
        ServiceCharacteristics sc = (ServiceCharacteristics)o;
        return !(this.serviceCharacteristics != null ? !((Object)this.serviceCharacteristics).equals(sc.serviceCharacteristics) : sc.serviceCharacteristics != null);
    }

    public int hashCode() {
        return this.serviceCharacteristics != null ? ((Object)this.serviceCharacteristics).hashCode() : 0;
    }

    public String toString() {
        return this.serviceCharacteristics != null ? this.serviceCharacteristics.toString() : super.toString();
    }
}

