/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.service.metadata;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.glassfish.internal.api.Globals;
import org.glassfish.paas.orchestrator.provisioning.ServiceScope;
import org.glassfish.paas.orchestrator.service.metadata.Property;
import org.glassfish.paas.orchestrator.service.metadata.ServiceCharacteristics;
import org.glassfish.paas.orchestrator.service.metadata.TemplateIdentifier;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.glassfish.virtualization.spi.TemplateInstance;
import org.glassfish.virtualization.spi.TemplateRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(propOrder={"templateOrCharacteristics", "configurations"})
public class ServiceDescription {
    private String name;
    private String initType;
    private String appName;
    private String virtualClusterName;
    private ServiceScope serviceScope;
    private String serviceType;
    private Object templateOrCharacteristics;
    private List<Property> configurations = new ArrayList<Property>();
    private ServicePlugin plugin;

    public ServiceDescription() {
    }

    public ServiceDescription(String name, String appName, String initType, Object templateOrCharacteristics, List<Property> configurations) {
        this.setName(name);
        this.setAppName(appName);
        this.setInitType(initType);
        this.setTemplateOrCharacteristics(templateOrCharacteristics);
        this.setConfigurations(configurations);
    }

    public ServiceDescription(ServiceDescription other) {
        this.setName(other.getName());
        this.setAppName(other.getAppName());
        this.setVirtualClusterName(other.getVirtualClusterName());
        this.setInitType(other.getInitType());
        this.cloneTemplateOrCharacteristics(other.getTemplateOrCharacteristics());
        this.cloneConfigurations(other.getConfigurations());
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="init-type")
    public String getInitType() {
        return this.initType;
    }

    @XmlTransient
    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setInitType(String initType) {
        this.initType = initType;
    }

    @XmlElementWrapper(name="configurations")
    @XmlElement(name="configuration")
    public List<Property> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<Property> configurations) {
        this.configurations = configurations;
    }

    @XmlElements(value={@XmlElement(name="template", type=TemplateIdentifier.class), @XmlElement(name="characteristics", type=ServiceCharacteristics.class)})
    public Object getTemplateOrCharacteristics() {
        return this.templateOrCharacteristics;
    }

    public void setTemplateOrCharacteristics(Object templateOrCharacteristics) {
        if (templateOrCharacteristics != null) {
            if (templateOrCharacteristics instanceof TemplateIdentifier || templateOrCharacteristics instanceof ServiceCharacteristics) {
                this.templateOrCharacteristics = templateOrCharacteristics;
            } else {
                throw new RuntimeException("Invalid type [" + templateOrCharacteristics.getClass() + "], " + "neither TemplateIdentifier nor ServiceCharacteristics");
            }
        }
    }

    public void cloneTemplateOrCharacteristics(Object templateOrCharacteristics) {
        if (templateOrCharacteristics != null) {
            if (templateOrCharacteristics instanceof TemplateIdentifier) {
                this.templateOrCharacteristics = new TemplateIdentifier();
                ((TemplateIdentifier)this.templateOrCharacteristics).setId(((TemplateIdentifier)templateOrCharacteristics).getId());
            } else if (templateOrCharacteristics instanceof ServiceCharacteristics) {
                this.templateOrCharacteristics = new ServiceCharacteristics((ServiceCharacteristics)templateOrCharacteristics);
            } else {
                throw new RuntimeException("Invalid type [" + templateOrCharacteristics.getClass() + "], " + "neither TemplateIdentifier nor ServiceCharacteristics");
            }
        }
    }

    private void cloneConfigurations(List<Property> configurations) {
        for (Property property : configurations) {
            this.configurations.add(new Property(property.getName(), property.getValue()));
        }
    }

    public TemplateIdentifier getTemplateIdentifier() {
        if (this.getTemplateOrCharacteristics() instanceof TemplateIdentifier) {
            return (TemplateIdentifier)this.getTemplateOrCharacteristics();
        }
        return null;
    }

    public ServiceCharacteristics getServiceCharacteristics() {
        if (this.getTemplateOrCharacteristics() instanceof ServiceCharacteristics) {
            return (ServiceCharacteristics)this.getTemplateOrCharacteristics();
        }
        return null;
    }

    public String getServiceType() {
        if (this.templateOrCharacteristics instanceof ServiceCharacteristics) {
            List<Property> characteristics = ((ServiceCharacteristics)this.templateOrCharacteristics).getServiceCharacteristics();
            for (Property characteristic : characteristics) {
                if (!characteristic.getName().equals("service-type")) continue;
                return characteristic.getValue();
            }
        } else if (this.templateOrCharacteristics instanceof TemplateIdentifier) {
            TemplateIdentifier templateId = (TemplateIdentifier)this.templateOrCharacteristics;
            TemplateRepository templateRepository = (TemplateRepository)Globals.getDefaultHabitat().getByContract(TemplateRepository.class);
            TemplateInstance templateInstance = templateRepository.byName(templateId.getId());
            if (templateInstance != null) {
                return templateInstance.getConfig().byName("ServiceType").getValue();
            }
        }
        return this.serviceType;
    }

    @XmlTransient
    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getConfiguration(String configKey) {
        for (Property p : this.getConfigurations()) {
            if (!p.getName().equals(configKey)) continue;
            return p.getValue();
        }
        return null;
    }

    public String toString() {
        return "{name = " + this.getName() + ", init-type = " + this.getInitType() + (this.templateOrCharacteristics instanceof TemplateIdentifier ? ", template-id = " : ", service-characteristics = ") + this.templateOrCharacteristics + ", service-configurations = " + this.configurations + "}";
    }

    @XmlTransient
    public String getVirtualClusterName() {
        return this.virtualClusterName;
    }

    public void setVirtualClusterName(String virtualClusterName) {
        this.virtualClusterName = virtualClusterName;
    }

    @XmlTransient
    public ServicePlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(ServicePlugin plugin) {
        this.plugin = plugin;
    }

    @XmlTransient
    public ServiceScope getServiceScope() {
        return this.serviceScope;
    }

    public void setServiceScope(ServiceScope serviceScope) {
        this.serviceScope = serviceScope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceDescription)) {
            return false;
        }
        ServiceDescription sd = (ServiceDescription)o;
        if (this.appName != null ? !this.appName.equals(sd.appName) : sd.appName != null) {
            return false;
        }
        if (this.configurations != null ? !((Object)this.configurations).equals(sd.configurations) : sd.configurations != null) {
            return false;
        }
        if (this.initType != null ? !this.initType.equals(sd.initType) : sd.initType != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(sd.name) : sd.name != null) {
            return false;
        }
        if (this.plugin != null ? !this.plugin.equals(sd.plugin) : sd.plugin != null) {
            return false;
        }
        if (this.serviceScope != sd.serviceScope) {
            return false;
        }
        if (this.serviceType != null ? !this.serviceType.equals(sd.serviceType) : sd.serviceType != null) {
            return false;
        }
        if (this.templateOrCharacteristics != null ? !this.templateOrCharacteristics.equals(sd.templateOrCharacteristics) : sd.templateOrCharacteristics != null) {
            return false;
        }
        return !(this.virtualClusterName != null ? !this.virtualClusterName.equals(sd.virtualClusterName) : sd.virtualClusterName != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.initType != null ? this.initType.hashCode() : 0);
        result = 31 * result + (this.appName != null ? this.appName.hashCode() : 0);
        result = 31 * result + (this.virtualClusterName != null ? this.virtualClusterName.hashCode() : 0);
        result = 31 * result + (this.serviceScope != null ? this.serviceScope.hashCode() : 0);
        result = 31 * result + (this.serviceType != null ? this.serviceType.hashCode() : 0);
        result = 31 * result + (this.templateOrCharacteristics != null ? this.templateOrCharacteristics.hashCode() : 0);
        result = 31 * result + (this.configurations != null ? ((Object)this.configurations).hashCode() : 0);
        result = 31 * result + (this.plugin != null ? this.plugin.hashCode() : 0);
        return result;
    }
}

