/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.service.metadata;

import java.util.Properties;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;

public class ServiceReference {
    private String name;
    private String serviceName;
    private String referenceType;
    private Properties properties = new Properties();
    private boolean optional;
    private ServicePlugin requestingPlugin;
    private ServicePlugin matchingPlugin;

    public ServiceReference() {
    }

    public ServiceReference(String refId, String refType, String serviceName) {
        this.name = refId;
        this.serviceName = serviceName;
        this.referenceType = refType;
    }

    public ServiceReference(String refId, String refType, String serviceName, Properties properties) {
        this.name = refId;
        this.serviceName = serviceName;
        this.referenceType = refType;
        this.setProperties(properties);
        if (properties != null && properties.getProperty("serviceName") != null) {
            this.serviceName = properties.getProperty("serviceName");
        }
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="service-name", required=true)
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @XmlAttribute(name="type")
    public String getType() {
        return this.referenceType;
    }

    public void setType(String type) {
        this.referenceType = type;
    }

    @XmlAttribute(name="optional")
    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setRequestingPlugin(ServicePlugin plugin) {
        this.requestingPlugin = plugin;
    }

    @XmlTransient
    public ServicePlugin getRequestingPlugin() {
        return this.requestingPlugin;
    }

    public String toString() {
        return "ServiceReference [ name = " + this.name + ", referenceType = " + this.referenceType + ", serviceName = " + this.serviceName + ", optional = " + this.optional + " ]";
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceReference)) {
            return false;
        }
        ServiceReference that = (ServiceReference)o;
        if (this.optional != that.optional) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        if (this.referenceType != null ? !this.referenceType.equals(that.referenceType) : that.referenceType != null) {
            return false;
        }
        if (this.requestingPlugin != null ? !this.requestingPlugin.equals(that.requestingPlugin) : that.requestingPlugin != null) {
            return false;
        }
        if (this.matchingPlugin != null ? !this.matchingPlugin.equals(that.matchingPlugin) : that.matchingPlugin != null) {
            return false;
        }
        return !(this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        result = 31 * result + (this.referenceType != null ? this.referenceType.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.optional ? 1 : 0);
        result = 31 * result + (this.requestingPlugin != null ? this.requestingPlugin.hashCode() : 0);
        result = 31 * result + (this.matchingPlugin != null ? this.matchingPlugin.hashCode() : 0);
        return result;
    }

    public void setMatchingPlugin(ServicePlugin matchingPlugin) {
        this.matchingPlugin = matchingPlugin;
    }

    @XmlTransient
    public ServicePlugin getMatchingPlugin() {
        return this.matchingPlugin;
    }
}

