/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.service.spi;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.paas.orchestrator.service.spi.ServiceLogRecord;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ServiceLogRecordBuilder {
    public final String LEVEL = "Level";
    public final String SEQUENCENUMBER = "SequenceNumber";
    public final String LOGGERNAME = "LoggerName";
    public final String MESSAGE = "Message";
    public final String SOURCECLASSNAME = "SourceClassName";
    public final String SOURCEMETHODNAME = "SourceMethodName";
    public final String THREADID = "ThreadID";
    public final String DATETIME = "Millis";
    public final String THROWN = "Thrown";
    public final String OTHER = "Parameters";
    private String startSequence;
    private String endSequence;
    private String delimiter;
    private String dateFormatter;
    private String[] parameters;
    private boolean isLB;
    private Level level;
    private File logFile;
    private List<String> logLines;
    private Logger logger = Logger.getLogger(ServiceLogRecordBuilder.class.getName());

    public List<ServiceLogRecord> build() throws UnsupportedEncodingException {
        this.validate(this);
        ArrayList<ServiceLogRecord> records = new ArrayList<ServiceLogRecord>();
        if (this.logLines == null) {
            this.logLines = this.getLogLines();
        }
        BufferedReader br = null;
        for (String line : this.logLines) {
            System.out.println(line);
            br = new BufferedReader(new CharArrayReader(line.toCharArray()));
            try {
                if (!this.isLB && line != null && line.startsWith(this.startSequence)) {
                    records.add(this.parse(line));
                    continue;
                }
                if (!this.isLB || line == null) continue;
                records.add(this.parseLB(line));
            }
            catch (Exception ex) {
                this.logger.warning("Error while parsing log lines" + ex);
            }
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException ex) {
                this.logger.warning("Error while closing buffer reader" + ex);
            }
        }
        this.reset();
        return records;
    }

    private void validate(ServiceLogRecordBuilder serviceLogRecordBuilder) throws UnsupportedEncodingException {
        if (serviceLogRecordBuilder.logLines == null && serviceLogRecordBuilder.logFile == null) {
            throw new UnsupportedEncodingException("Log Lines and Log Files are missing.");
        }
        if (serviceLogRecordBuilder.level == null) {
            throw new UnsupportedEncodingException("Default log Level is Missing.");
        }
        if (serviceLogRecordBuilder.parameters == null) {
            throw new UnsupportedEncodingException("Parameter is Missing.");
        }
        String[] myParameter = serviceLogRecordBuilder.parameters;
        List<String> myPList = Arrays.asList(myParameter);
        if (myPList.contains("Millis") && (serviceLogRecordBuilder.dateFormatter == null || serviceLogRecordBuilder.dateFormatter.trim().equals(""))) {
            throw new UnsupportedEncodingException("Date formatter is Missing.");
        }
    }

    private ServiceLogRecord parse(String line) {
        ServiceLogRecord record = new ServiceLogRecord(this.level, "");
        if (this.startSequence != null && !this.startSequence.trim().equals("")) {
            line = line.substring(this.startSequence.length());
        }
        if (this.endSequence != null && !this.endSequence.trim().equals("")) {
            line = line.substring(0, line.indexOf(this.endSequence));
        }
        StringTokenizer tokenizer = new StringTokenizer(line, this.delimiter);
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            this.set(this.parameters[i], nextToken, record);
            ++i;
        }
        return record;
    }

    private ServiceLogRecord parseLB(String line) {
        ServiceLogRecord record = new ServiceLogRecord(this.level, "");
        for (int i = 0; i < this.parameters.length; ++i) {
            if (line.contains(this.startSequence) && line.contains(this.endSequence)) {
                String vlaue = line.trim().substring(line.trim().indexOf(this.startSequence) + 1, line.trim().indexOf(this.endSequence));
                this.set(this.parameters[i], vlaue, record);
                line = line.trim().substring(line.indexOf(this.endSequence) + 1, line.trim().length());
                continue;
            }
            this.set(this.parameters[i], line, record);
        }
        return record;
    }

    private void set(String key, String value, ServiceLogRecord serviceLogRecord) {
        if (value != null) {
            if (key.equals("Level")) {
                if (value.equalsIgnoreCase("ALL")) {
                    serviceLogRecord.setLevel(Level.ALL);
                } else if (value.equalsIgnoreCase("CONFIG")) {
                    serviceLogRecord.setLevel(Level.CONFIG);
                } else if (value.equalsIgnoreCase("FINE")) {
                    serviceLogRecord.setLevel(Level.FINE);
                } else if (value.equalsIgnoreCase("FINER")) {
                    serviceLogRecord.setLevel(Level.FINER);
                } else if (value.equalsIgnoreCase("FINEST")) {
                    serviceLogRecord.setLevel(Level.FINEST);
                } else if (value.equalsIgnoreCase("OFF")) {
                    serviceLogRecord.setLevel(Level.OFF);
                } else if (value.equalsIgnoreCase("SEVERE")) {
                    serviceLogRecord.setLevel(Level.SEVERE);
                } else if (value.equalsIgnoreCase("WARNING")) {
                    serviceLogRecord.setLevel(Level.WARNING);
                } else {
                    serviceLogRecord.setLevel(Level.INFO);
                }
            } else if (key.equals("LoggerName")) {
                serviceLogRecord.setLoggerName(value);
            } else if (key.equals("Millis")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateFormatter);
                Date date = null;
                try {
                    date = dateFormat.parse(value);
                }
                catch (ParseException ex) {
                    this.logger.warning("Error while parsing date: " + ex);
                }
                serviceLogRecord.setMillis(date.getTime());
            } else if (key.equals("SequenceNumber")) {
                serviceLogRecord.setSequenceNumber(Long.parseLong(value));
            } else if (key.equals("Message")) {
                serviceLogRecord.setMessage(value);
            } else if (key.equals("SourceClassName")) {
                serviceLogRecord.setSourceClassName(value);
            } else if (key.equals("SourceMethodName")) {
                serviceLogRecord.setSourceMethodName(value);
            } else if (key.equals("ThreadID")) {
                serviceLogRecord.setThreadID(Integer.parseInt(value));
            } else if (key.equals("Thrown")) {
                serviceLogRecord.setThrown(new Throwable(value));
            } else if (key.equals("Parameters")) {
                Object[] myObject = serviceLogRecord.getParameters();
                if (myObject == null) {
                    myObject = new Object[]{};
                }
                myObject = this.addElement(myObject, value);
                serviceLogRecord.setParameters(myObject);
            }
        }
    }

    private Object[] addElement(Object[] org, Object added) {
        Object[] result = Arrays.copyOf(org, org.length + 1);
        result[org.length] = added;
        return result;
    }

    private void reset() {
        this.setStartSequence(null).setEndSequence(null).setDelimiter(null).setLogFile(null).setLogLines(null).setParameters(null).setLevel(null);
    }

    public ServiceLogRecordBuilder setStartSequence(String startSequence) {
        this.startSequence = startSequence;
        return this;
    }

    public ServiceLogRecordBuilder setEndSequence(String endSequence) {
        this.endSequence = endSequence;
        return this;
    }

    public ServiceLogRecordBuilder setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public ServiceLogRecordBuilder setLogFile(File logFile) {
        this.logFile = logFile;
        return this;
    }

    public ServiceLogRecordBuilder setLogLines(List logLines) {
        this.logLines = logLines;
        return this;
    }

    public ServiceLogRecordBuilder setParameters(String[] parameters) {
        this.parameters = parameters;
        return this;
    }

    public ServiceLogRecordBuilder setLevel(Level level) {
        this.level = level;
        return this;
    }

    public ServiceLogRecordBuilder setDateFormatter(String dateFormatter) {
        this.dateFormatter = dateFormatter;
        return this;
    }

    public ServiceLogRecordBuilder setLB(boolean isLB) {
        this.isLB = isLB;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getLogLines() {
        BufferedReader reader = null;
        try {
            this.logLines = new ArrayList<String>();
            reader = new BufferedReader(new InputStreamReader(new DataInputStream(new FileInputStream(this.logFile))));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(this.startSequence)) continue;
                this.logLines.add(line);
            }
        }
        catch (Exception ex) {
            this.logger.warning("Error reading log File: " + ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                this.logger.warning("Error while closing buffer reader" + ex);
            }
        }
        return this.logLines;
    }
}

