/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.state;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import org.glassfish.paas.orchestrator.PaaSAppInfoRegistry;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.PaaSDeploymentException;
import org.glassfish.paas.orchestrator.PaaSDeploymentState;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.provisioning.util.FailureInducer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;

public abstract class AbstractPaaSDeploymentState
implements PaaSDeploymentState {
    protected static final Logger logger = LogDomains.getLogger(ServiceOrchestratorImpl.class, (String)"javax.org.glassfish.paas");
    protected static final StringManager localStrings = StringManager.getManager(ServiceOrchestratorImpl.class);
    @Inject
    protected Habitat habitat;
    @Inject
    protected ServiceUtil serviceUtil;
    @Inject
    protected ServiceOrchestratorImpl orchestrator;
    @Inject
    protected PaaSAppInfoRegistry appInfoRegistry;

    public void beforeExecution(PaaSDeploymentContext context) throws PaaSDeploymentException {
        this.detectAndFail(true);
    }

    public void afterExecution(PaaSDeploymentContext context) throws PaaSDeploymentException {
        this.detectAndFail(false);
    }

    private void detectAndFail(boolean beforeExecution) throws PaaSDeploymentException {
        String executionState = "beforeExecution";
        if (!beforeExecution) {
            executionState = "afterExecution";
        }
        if (FailureInducer.getFailureState() != null && this.getClass().equals(FailureInducer.getFailureState())) {
            throw new PaaSDeploymentException("Failure Inducer induced exception on state [ " + this.getClass().getSimpleName() + " ], " + executionState);
        }
    }

    protected boolean isAtomicDeploymentEnabled() {
        return this.orchestrator.isAtomicDeploymentEnabled();
    }

    protected boolean isParallelProvisioningEnabled() {
        return this.orchestrator.isParallelProvisioningEnabled();
    }
}

