/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.PaaSDeploymentException;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.glassfish.paas.orchestrator.service.metadata.ServiceReference;
import org.glassfish.paas.orchestrator.service.spi.Service;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.glassfish.paas.orchestrator.state.AbstractPaaSDeploymentState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AssociationState
extends AbstractPaaSDeploymentState {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void associateProvisionedServices(PaaSDeploymentContext context, boolean preDeployment) throws PaaSDeploymentException {
        String state = "after";
        if (preDeployment) {
            state = "before";
        }
        logger.log(Level.FINER, localStrings.getString("associate.provisioned.services.predeployment", (Object)state));
        String appName = context.getAppName();
        ServiceMetadata appServiceMetadata = this.appInfoRegistry.getServiceMetadata(appName);
        Set<Service> servicesForAssociation = this.orchestrator.getServicesForAssociation(appName);
        ArrayList<ServiceAssociationRecord> associatedServicesList = new ArrayList<ServiceAssociationRecord>();
        try {
            Set<ServiceReference> appSRs = appServiceMetadata.getServiceReferences();
            for (ServiceReference serviceRef : appSRs) {
                for (Service serviceProvider : servicesForAssociation) {
                    ServiceDescription sd = serviceProvider.getServiceDescription();
                    Map<ServiceReference, ServiceDescription> srToSDMap = this.appInfoRegistry.getSRToSDMap(appName);
                    for (Map.Entry<ServiceReference, ServiceDescription> entry : srToSDMap.entrySet()) {
                        ServiceReference ref = entry.getKey();
                        if (!ref.equals(serviceRef) || !sd.equals(entry.getValue())) continue;
                        ServicePlugin requestingPlugin = ref.getRequestingPlugin();
                        ServicePlugin matchingPlugin = ref.getMatchingPlugin();
                        Collection<Service> serviceConsumers = this.orchestrator.getServicesManagedByPlugin(requestingPlugin, servicesForAssociation);
                        for (Service serviceConsumer : serviceConsumers) {
                            try {
                                Object[] args = new Object[]{serviceProvider, serviceRef, requestingPlugin};
                                logger.log(Level.INFO, "associate.provisionedservice", args);
                                requestingPlugin.associateServices(serviceConsumer, serviceRef, serviceProvider, preDeployment, context);
                                associatedServicesList.add(new ServiceAssociationRecord(serviceProvider, serviceConsumer, serviceRef, requestingPlugin));
                                matchingPlugin.associateServices(serviceConsumer, serviceRef, serviceProvider, preDeployment, context);
                                associatedServicesList.add(new ServiceAssociationRecord(serviceProvider, serviceConsumer, serviceRef, matchingPlugin));
                            }
                            catch (Exception e) {
                                Object[] args1 = new Object[]{serviceConsumer.getName(), serviceProvider.getName(), serviceRef};
                                logger.log(Level.WARNING, localStrings.getString("failure.while.associating.service", args1), e);
                                this.rollback(associatedServicesList, context, preDeployment);
                                throw new PaaSDeploymentException(e);
                            }
                        }
                    }
                }
                continue;
                return;
            }
        }
        finally {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "associated-services-records for application [ " + appName + " ]: " + associatedServicesList);
            }
            associatedServicesList.clear();
        }
    }

    private void rollback(List<ServiceAssociationRecord> associatedServices, PaaSDeploymentContext context, boolean preDeployment) {
        if (this.isAtomicDeploymentEnabled()) {
            for (ServiceAssociationRecord asr : associatedServices) {
                Service serviceProvider = asr.getProvider();
                Service serviceConsumer = asr.getConsumer();
                ServiceReference serviceRef = asr.getServiceReference();
                ServicePlugin plugin = asr.getPlugin();
                try {
                    plugin.dissociateServices(serviceConsumer, serviceRef, serviceProvider, preDeployment, context);
                }
                catch (Exception e) {
                    Object[] args = new Object[]{serviceConsumer.getName(), serviceProvider.getName(), serviceRef};
                    logger.log(Level.WARNING, localStrings.getString("failure.while.associating.service", args), e);
                }
            }
        }
    }

    class ServiceAssociationRecord {
        private Service provider;
        private Service consumer;
        private ServiceReference serviceRef;
        private ServicePlugin plugin;

        public ServiceAssociationRecord(Service serviceProvider, Service serviceConsumer, ServiceReference serviceRef, ServicePlugin plugin) {
            this.provider = serviceProvider;
            this.consumer = serviceConsumer;
            this.serviceRef = serviceRef;
            this.plugin = plugin;
        }

        public Service getProvider() {
            return this.provider;
        }

        public Service getConsumer() {
            return this.consumer;
        }

        public ServiceReference getServiceReference() {
            return this.serviceRef;
        }

        public ServicePlugin getPlugin() {
            return this.plugin;
        }

        public String toString() {
            return "AssociatedServiceRecord{provider=" + this.provider + ", consumer=" + this.consumer + ", serviceRef=" + this.serviceRef + ", plugin=" + this.plugin + '}';
        }
    }
}

