/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.state;

import java.util.ArrayList;
import java.util.logging.Level;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.PaaSDeploymentException;
import org.glassfish.paas.orchestrator.provisioning.ServiceInfo;
import org.glassfish.paas.orchestrator.provisioning.ServiceScope;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.glassfish.paas.orchestrator.state.AbstractPaaSDeploymentState;
import org.glassfish.paas.orchestrator.state.EnableState;
import org.jvnet.hk2.annotations.Service;

@Service
public class DisableState
extends AbstractPaaSDeploymentState {
    public void handle(PaaSDeploymentContext context) throws PaaSDeploymentException {
        this.stopServices(context);
    }

    private void stopServices(PaaSDeploymentContext context) throws PaaSDeploymentException {
        String appName = context.getAppName();
        ServiceMetadata appServiceMetadata = this.appInfoRegistry.getServiceMetadata(appName);
        ArrayList<ServiceDescription> stoppedServiceSDs = new ArrayList<ServiceDescription>();
        for (ServiceDescription sd : appServiceMetadata.getServiceDescriptions()) {
            if (!ServiceScope.APPLICATION.equals((Object)sd.getServiceScope())) continue;
            try {
                this.stopService(context, appName, sd);
                stoppedServiceSDs.add(sd);
            }
            catch (Exception e) {
                Object[] args = new Object[]{sd.getName(), appName};
                logger.log(Level.WARNING, localStrings.getString("exception.stop.service", args), e);
                EnableState enableState = (EnableState)this.habitat.getComponent(EnableState.class);
                for (ServiceDescription stoppedSD : stoppedServiceSDs) {
                    try {
                        enableState.startService(context, appName, stoppedSD);
                    }
                    catch (Exception stopException) {
                        args = new Object[]{stoppedSD.getName(), appName};
                        logger.log(Level.WARNING, localStrings.getString("exception.start.service", args), stopException);
                    }
                }
                throw new PaaSDeploymentException(e);
            }
        }
    }

    public boolean stopService(PaaSDeploymentContext context, String appName, ServiceDescription sd) {
        ServicePlugin chosenPlugin = sd.getPlugin();
        ServiceInfo serviceInfo = this.serviceUtil.getServiceInfo(sd.getName(), appName);
        if (serviceInfo != null) {
            ProvisionedService ps = this.orchestrator.getProvisionedService(sd, appName);
            chosenPlugin.stopService(ps, serviceInfo);
            this.serviceUtil.updateState(ps, appName);
            return true;
        }
        Object[] args = new Object[]{sd.getName(), appName};
        logger.log(Level.WARNING, "unable.retrieve.serviceinfo", args);
        return false;
    }

    public Class getRollbackState() {
        return EnableState.class;
    }
}

