/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.state;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.glassfish.paas.orchestrator.service.metadata.ServiceReference;
import org.glassfish.paas.orchestrator.service.spi.Service;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.glassfish.paas.orchestrator.state.AbstractPaaSDeploymentState;

public abstract class DissociationState
extends AbstractPaaSDeploymentState {
    protected void dissociateProvisionedServices(PaaSDeploymentContext context, boolean beforeUndeploy) {
        String state = "after";
        if (beforeUndeploy) {
            state = "before";
        }
        String appName = context.getAppName();
        ServiceMetadata appServiceMetadata = this.appInfoRegistry.getServiceMetadata(appName);
        Set<Service> allServices = this.orchestrator.getServicesForDissociation(appName);
        logger.log(Level.FINEST, localStrings.getString("dissociate.provisioned.services.preundeployment", (Object)state));
        boolean failed = false;
        Exception failureCause = null;
        Set<ServiceReference> appSRs = appServiceMetadata.getServiceReferences();
        for (ServiceReference serviceRef : appSRs) {
            Map<ServiceReference, ServiceDescription> srToSDMap = this.appInfoRegistry.getSRToSDMap(appName);
            for (Service serviceProvider : allServices) {
                ServiceDescription sd = serviceProvider.getServiceDescription();
                for (Map.Entry<ServiceReference, ServiceDescription> entry : srToSDMap.entrySet()) {
                    ServiceReference ref = entry.getKey();
                    if (!ref.equals(serviceRef) || !sd.equals(entry.getValue())) continue;
                    ServicePlugin requestingPlugin = ref.getRequestingPlugin();
                    ServicePlugin matchingPlugin = ref.getMatchingPlugin();
                    Collection<Service> serviceConsumers = this.orchestrator.getServicesManagedByPlugin(requestingPlugin, allServices);
                    for (Service serviceConsumer : serviceConsumers) {
                        try {
                            Object[] args = new Object[]{serviceProvider, serviceRef, requestingPlugin};
                            logger.log(Level.INFO, "dissociate.provisionedservice", args);
                            matchingPlugin.dissociateServices(serviceConsumer, serviceRef, serviceProvider, beforeUndeploy, context);
                            requestingPlugin.dissociateServices(serviceConsumer, serviceRef, serviceProvider, beforeUndeploy, context);
                        }
                        catch (Exception e) {
                            failed = true;
                            failureCause = e;
                        }
                    }
                }
            }
        }
    }
}

