/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.state;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.PaaSDeploymentException;
import org.glassfish.paas.orchestrator.provisioning.ServiceInfo;
import org.glassfish.paas.orchestrator.provisioning.ServiceScope;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.glassfish.paas.orchestrator.state.AbstractPaaSDeploymentState;
import org.glassfish.paas.orchestrator.state.DisableState;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EnableState
extends AbstractPaaSDeploymentState {
    @Override
    public void handle(PaaSDeploymentContext context) throws PaaSDeploymentException {
        this.startServices(context);
    }

    @Override
    public Class getRollbackState() {
        return DisableState.class;
    }

    private Set<ProvisionedService> startServices(PaaSDeploymentContext context) throws PaaSDeploymentException {
        HashSet<ProvisionedService> appPSs = new HashSet<ProvisionedService>();
        String appName = context.getAppName();
        ServiceMetadata appServiceMetadata = this.appInfoRegistry.getServiceMetadata(appName);
        ArrayList<ServiceDescription> provisionedSDs = new ArrayList<ServiceDescription>();
        for (ServiceDescription sd : appServiceMetadata.getServiceDescriptions()) {
            if (ServiceScope.EXTERNAL.equals((Object)sd.getServiceScope()) || ServiceScope.SHARED.equals((Object)sd.getServiceScope())) continue;
            try {
                ProvisionedService ps = this.startService(context, appName, sd);
                appPSs.add(ps);
                provisionedSDs.add(sd);
            }
            catch (Exception e) {
                Object[] args = new Object[]{sd.getName(), appName};
                logger.log(Level.WARNING, localStrings.getString("exception.start.service", args), e);
                DisableState disableState = (DisableState)this.habitat.getComponent(DisableState.class);
                for (ServiceDescription provisionedSD : provisionedSDs) {
                    try {
                        disableState.stopService(context, appName, provisionedSD);
                    }
                    catch (Exception stopException) {
                        args = new Object[]{provisionedSD.getName(), appName};
                        logger.log(Level.WARNING, localStrings.getString("exception.stop.service", args), e);
                    }
                }
                throw new PaaSDeploymentException(e);
            }
        }
        this.appInfoRegistry.registerProvisionedServices(appName, appPSs);
        return appPSs;
    }

    public ProvisionedService startService(PaaSDeploymentContext context, String appName, ServiceDescription sd) {
        ServicePlugin chosenPlugin = sd.getPlugin();
        Object[] args = new Object[]{sd, chosenPlugin};
        logger.log(Level.FINEST, "retrieving.provisionedservice.viaplugin", args);
        ServiceInfo serviceInfo = this.serviceUtil.getServiceInfo(sd.getName(), appName);
        if (serviceInfo != null) {
            ProvisionedService ps = chosenPlugin.startService(sd, serviceInfo);
            this.serviceUtil.updateState(ps, appName);
            return ps;
        }
        Object[] args1 = new Object[]{sd.getName(), appName};
        logger.log(Level.WARNING, "unable.retrieve.serviceinfo", args1);
        return null;
    }
}

