/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.PaaSDeploymentException;
import org.glassfish.paas.orchestrator.provisioning.ServiceScope;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServiceChangeEvent;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.glassfish.paas.orchestrator.state.AbstractPaaSDeploymentState;
import org.glassfish.paas.orchestrator.state.UnprovisioningState;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ProvisioningState
extends AbstractPaaSDeploymentState {
    @Inject
    private CommandRunner commandRunner;

    @Override
    public void handle(PaaSDeploymentContext context) throws PaaSDeploymentException {
        try {
            this.provisionServices(context);
        }
        catch (Exception e) {
            if (e instanceof PaaSDeploymentException) {
                throw (PaaSDeploymentException)e;
            }
            throw new PaaSDeploymentException(e);
        }
    }

    @Override
    public Class getRollbackState() {
        return UnprovisioningState.class;
    }

    private Set<ProvisionedService> provisionServices(final PaaSDeploymentContext context) throws PaaSDeploymentException {
        logger.log(Level.FINER, localStrings.getString("METHOD.provisionServices"));
        HashSet<ProvisionedService> appPSs = new HashSet<ProvisionedService>();
        String appName = context.getAppName();
        ServiceMetadata appServiceMetadata = this.appInfoRegistry.getServiceMetadata(appName);
        String virtualClusterName = this.orchestrator.getVirtualClusterForApplication(appName, appServiceMetadata);
        if (virtualClusterName != null) {
            CommandResult result = this.commandRunner.run("create-cluster", new String[]{virtualClusterName});
            Object[] args = new Object[]{virtualClusterName, result.getOutput()};
            logger.log(Level.INFO, "create.cluster.exec.output", args);
            if (result.getExitStatus().equals((Object)CommandResult.ExitStatus.FAILURE)) {
                throw new RuntimeException("Failure while provisioning services, Unable to create cluster [" + virtualClusterName + "]");
            }
        }
        for (ServiceDescription sd : appServiceMetadata.getServiceDescriptions()) {
            if (!"JavaEE".equalsIgnoreCase(sd.getServiceType()) || !ServiceScope.SHARED.equals((Object)sd.getServiceScope())) continue;
            virtualClusterName = sd.getName();
            break;
        }
        if (virtualClusterName != null) {
            DeploymentContext dc = context.getDeploymentContext();
            if (dc != null) {
                DeployCommandParameters dcp = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
                dcp.target = virtualClusterName;
            }
        } else {
            throw new PaaSDeploymentException("Unable to determine virtual-cluster-name for the application [" + appName + "]");
        }
        Collection<ServiceDescription> serviceDescriptionsToProvision = this.orchestrator.getServiceDescriptionsToProvision(appName);
        boolean failed = false;
        Exception rootCause = null;
        if (this.isParallelProvisioningEnabled()) {
            ArrayList<Future<ProvisionedService>> provisioningFutures = new ArrayList<Future<ProvisionedService>>();
            for (final ServiceDescription serviceDescription : serviceDescriptionsToProvision) {
                Future<ProvisionedService> future = ServiceUtil.getThreadPool().submit(new Callable<ProvisionedService>(){

                    @Override
                    public ProvisionedService call() {
                        ServicePlugin chosenPlugin = serviceDescription.getPlugin();
                        Object[] args = new Object[]{serviceDescription, chosenPlugin};
                        AbstractPaaSDeploymentState.logger.log(Level.FINEST, AbstractPaaSDeploymentState.localStrings.getString("started.provisioningservice.parallel", args));
                        return chosenPlugin.provisionService(serviceDescription, context);
                    }
                });
                provisioningFutures.add(future);
            }
            for (Future future : provisioningFutures) {
                try {
                    ProvisionedService ps = (ProvisionedService)future.get();
                    this.registerServiceAndNotify(appName, ps);
                    appPSs.add(ps);
                    logger.log(Level.FINEST, localStrings.getString("completed.provisioningservice.parallel", (Object)ps));
                }
                catch (Exception e) {
                    failed = true;
                    logger.log(Level.WARNING, localStrings.getString("failure.provisioningservice.parallel"), e);
                    if (rootCause != null) continue;
                    rootCause = e;
                }
            }
        } else {
            for (ServiceDescription sd : serviceDescriptionsToProvision) {
                Object[] args;
                try {
                    ServicePlugin servicePlugin = sd.getPlugin();
                    args = new Object[]{sd, servicePlugin};
                    logger.log(Level.FINEST, localStrings.getString("started.provisioningservice.serial", args));
                    ProvisionedService ps = servicePlugin.provisionService(sd, context);
                    this.registerServiceAndNotify(appName, ps);
                    appPSs.add(ps);
                    logger.log(Level.FINEST, localStrings.getString("completed.provisioningservice.serial", (Object)ps));
                }
                catch (Exception exception) {
                    args = new Object[]{sd.getName(), sd.getPlugin()};
                    failed = true;
                    logger.log(Level.WARNING, localStrings.getString("failure.provisioningservice", args), exception);
                    rootCause = exception;
                    break;
                }
            }
        }
        if (!failed) {
            this.appInfoRegistry.registerProvisionedServices(context.getAppName(), appPSs);
            return appPSs;
        }
        if (this.isAtomicDeploymentEnabled()) {
            for (ProvisionedService ps : appPSs) {
                try {
                    ServiceDescription serviceDescription = ps.getServiceDescription();
                    ServicePlugin chosenPlugin = serviceDescription.getPlugin();
                    Object[] args = new Object[]{serviceDescription, chosenPlugin};
                    logger.log(Level.INFO, "rollingback.provisioningservice", args);
                    chosenPlugin.unprovisionService(serviceDescription, context);
                    this.serviceUtil.unregisterServiceInfo(serviceDescription.getName(), serviceDescription.getAppName());
                    this.serviceUtil.fireServiceChangeEvent(ServiceChangeEvent.Type.DELETED, ps);
                    logger.log(Level.INFO, "rolledback.provisioningservice", args);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, localStrings.getString("failure.while.rollingback.ps", (Object)ps), exception);
                }
            }
            if (virtualClusterName != null) {
                this.orchestrator.removeVirtualCluster(virtualClusterName);
            }
            this.appInfoRegistry.resetAppInfo(appName);
        }
        PaaSDeploymentException re = new PaaSDeploymentException("Failure while provisioning services");
        if (rootCause != null) {
            re.initCause(rootCause);
        }
        throw re;
    }

    private void registerServiceAndNotify(String appName, ProvisionedService ps) {
        this.serviceUtil.registerService(appName, ps, null);
        this.serviceUtil.fireServiceChangeEvent(ServiceChangeEvent.Type.CREATED, ps);
    }
}

