/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.state;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.PaaSDeploymentException;
import org.glassfish.paas.orchestrator.PaaSDeploymentState;
import org.glassfish.paas.orchestrator.provisioning.ServiceInfo;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.glassfish.paas.orchestrator.state.AbstractPaaSDeploymentState;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ServerStartupState
extends AbstractPaaSDeploymentState {
    @Override
    public void handle(PaaSDeploymentContext context) throws PaaSDeploymentException {
        this.retrieveProvisionedServices(context);
    }

    public Set<ProvisionedService> retrieveProvisionedServices(PaaSDeploymentContext context) {
        logger.log(Level.FINER, localStrings.getString("METHOD.retrieveProvisionedServices"));
        String appName = context.getAppName();
        ServiceMetadata appServiceMetadata = this.appInfoRegistry.getServiceMetadata(appName);
        HashSet<ProvisionedService> appPSs = new HashSet<ProvisionedService>();
        String virtualClusterName = this.orchestrator.getVirtualClusterForApplication(appName, appServiceMetadata);
        Object[] args = new Object[]{appName, virtualClusterName};
        logger.log(Level.FINEST, localStrings.getString("retrieve.provisionedservice", args));
        Set<ServiceDescription> appSDs = appServiceMetadata.getServiceDescriptions();
        for (ServiceDescription sd : appSDs) {
            ServicePlugin chosenPlugin = sd.getPlugin();
            args[0] = sd;
            args[1] = chosenPlugin;
            logger.log(Level.FINEST, localStrings.getString("retrieving.provisionedservice.viaplugin", args));
            ServiceInfo serviceInfo = this.serviceUtil.getServiceInfo(sd.getName(), appName);
            if (serviceInfo != null) {
                ProvisionedService ps = chosenPlugin.getProvisionedService(sd, serviceInfo);
                appPSs.add(ps);
                continue;
            }
            args[0] = sd.getName();
            args[1] = appName;
            logger.log(Level.WARNING, "unable.retrieve.serviceinfo", args);
        }
        this.appInfoRegistry.registerProvisionedServices(appName, appPSs);
        return appPSs;
    }

    @Override
    public Class<PaaSDeploymentState> getRollbackState() {
        return null;
    }
}

