/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.PaaSDeploymentException;
import org.glassfish.paas.orchestrator.ServiceOrchestratorImpl;
import org.glassfish.paas.orchestrator.ServicesXMLParser;
import org.glassfish.paas.orchestrator.provisioning.ServiceScope;
import org.glassfish.paas.orchestrator.service.ServiceType;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.glassfish.paas.orchestrator.service.metadata.ServiceReference;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.glassfish.paas.orchestrator.state.AbstractPaaSDeploymentState;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ServiceDependencyDiscoveryState
extends AbstractPaaSDeploymentState {
    @Override
    public void handle(PaaSDeploymentContext context) throws PaaSDeploymentException {
        try {
            ServiceMetadata appServiceMetadata = this.serviceDependencyDiscovery(context);
            String appName = context.getAppName();
            this.appInfoRegistry.addServiceMetadata(appName, appServiceMetadata);
        }
        catch (Exception e) {
            throw new PaaSDeploymentException(e);
        }
    }

    @Override
    public Class getRollbackState() {
        return null;
    }

    private ServiceMetadata serviceDependencyDiscovery(PaaSDeploymentContext context) throws PaaSDeploymentException {
        logger.log(Level.FINER, localStrings.getString("METHOD.serviceDependencyDiscovery"));
        String appName = context.getAppName();
        ReadableArchive archive = context.getArchive();
        return this.getServiceDependencyMetadata(context, appName, archive);
    }

    public ServiceMetadata getServiceDependencyMetadata(PaaSDeploymentContext context, String appName, ReadableArchive archive) throws PaaSDeploymentException {
        Set<ServicePlugin> installedPlugins = this.orchestrator.getPlugins();
        try {
            ServicesXMLParser parser = (ServicesXMLParser)this.habitat.getByContract(ServicesXMLParser.class);
            ServiceMetadata appServiceMetadata = parser.discoverDeclaredServices(appName, archive);
            if (appServiceMetadata == null) {
                appServiceMetadata = new ServiceMetadata();
                appServiceMetadata.setAppName(appName);
            }
            logger.log(Level.INFO, "discovered.declared.metadata", appServiceMetadata);
            LinkedHashMap<ServiceDescription, ServicePlugin> pluginsToHandleSDs = new LinkedHashMap<ServiceDescription, ServicePlugin>();
            LinkedHashSet<ServiceReference> wiredServiceReferences = new LinkedHashSet<ServiceReference>();
            for (ServiceReference serviceReference : appServiceMetadata.getServiceReferences()) {
                String serviceName = serviceReference.getServiceName();
                ServiceDescription sd = this.orchestrator.getServiceDescriptionForSharedOrExternalService(serviceName);
                if (sd == null) continue;
                appServiceMetadata.addServiceDescription(sd);
                wiredServiceReferences.add(serviceReference);
                pluginsToHandleSDs.put(sd, sd.getPlugin());
            }
            for (ServiceDescription sd : appServiceMetadata.getServiceDescriptions()) {
                if (sd.getPlugin() != null) continue;
                ArrayList<ServicePlugin> pluginsList = new ArrayList<ServicePlugin>();
                for (ServicePlugin servicePlugin : installedPlugins) {
                    if (!servicePlugin.handles(sd)) continue;
                    pluginsList.add(servicePlugin);
                }
                if (pluginsList.size() == 1) {
                    pluginsToHandleSDs.put(sd, (ServicePlugin)pluginsList.get(0));
                    sd.setPlugin((ServicePlugin)pluginsList.get(0));
                    continue;
                }
                if (pluginsList.size() <= 1) continue;
                ServicePlugin defaultPlugin = null;
                Object t = ((ServicePlugin)pluginsList.get(0)).getServiceType();
                defaultPlugin = this.orchestrator.getDefaultPlugin(pluginsList, t.toString());
                if (defaultPlugin != null) {
                    pluginsToHandleSDs.put(sd, defaultPlugin);
                    sd.setPlugin(defaultPlugin);
                    continue;
                }
                throw new PaaSDeploymentException("Unable to resolve conflict between multiple service-provisioning-engines that handle service-description [" + sd.getName() + "]");
            }
            HashMap matchingPlugins = new HashMap();
            for (ServicePlugin svcPlugin : installedPlugins) {
                if (!svcPlugin.handles(archive)) continue;
                ArrayList<ServicePlugin> plugins = (ArrayList<ServicePlugin>)matchingPlugins.get(svcPlugin.getServiceType());
                if (plugins == null) {
                    plugins = new ArrayList<ServicePlugin>();
                    matchingPlugins.put(svcPlugin.getServiceType(), plugins);
                }
                plugins.add(svcPlugin);
            }
            LinkedHashSet<ServicePlugin> resolvedPlugins = new LinkedHashSet<ServicePlugin>();
            for (ServiceType type : matchingPlugins.keySet()) {
                List list = (List)matchingPlugins.get(type);
                if (list.size() > 1) {
                    ServicePlugin plugin = this.orchestrator.getDefaultPlugin(list, type.toString());
                    if (plugin != null) {
                        resolvedPlugins.add(plugin);
                        continue;
                    }
                    throw new PaaSDeploymentException("Unable to resolve conflict between multiple service-provisioning-engines of type [" + type + "] that handle the archive");
                }
                if (list.size() != 1) continue;
                resolvedPlugins.add((ServicePlugin)list.get(0));
            }
            resolvedPlugins.addAll(pluginsToHandleSDs.values());
            for (ServicePlugin svcPlugin : resolvedPlugins) {
                Set<ServiceDescription> set;
                if (this.serviceDescriptionExistsForPlugin(appServiceMetadata, svcPlugin) || (set = svcPlugin.getImplicitServiceDescriptions(archive, appName, context)) == null) continue;
                for (ServiceDescription sd : set) {
                    logger.log(Level.FINEST, localStrings.getString("implicit.SD", (Object)sd));
                    pluginsToHandleSDs.put(sd, svcPlugin);
                    sd.setPlugin(svcPlugin);
                    sd.setServiceScope(ServiceScope.APPLICATION);
                    appServiceMetadata.addServiceDescription(sd);
                }
            }
            this.setPluginForSD(this.orchestrator, pluginsToHandleSDs, installedPlugins, appServiceMetadata);
            logger.log(Level.FINEST, "after.implicit.SD", appServiceMetadata);
            HashMap<ServiceReference, ServiceDescription> serviceRefToSD = new HashMap<ServiceReference, ServiceDescription>();
            for (ServicePlugin<Object> servicePlugin : resolvedPlugins) {
                Set<ServiceReference> implicitServiceRefs = servicePlugin.getServiceReferences(appName, archive, context);
                for (ServiceReference sr : implicitServiceRefs) {
                    sr.setRequestingPlugin(servicePlugin);
                    sr.setMatchingPlugin(this.getMatchingPlugin(sr, installedPlugins, pluginsToHandleSDs));
                    logger.log(Level.FINEST, localStrings.getString("serviceReference", (Object)sr));
                    appServiceMetadata.addServiceReference(sr);
                    String serviceName = sr.getServiceName();
                    if (serviceName == null) continue;
                    ServiceDescription sd = this.orchestrator.getServiceDescriptionForSharedOrExternalService(serviceName);
                    if (sd != null) {
                        appServiceMetadata.addServiceDescription(sd);
                        pluginsToHandleSDs.put(sd, sd.getPlugin());
                        wiredServiceReferences.add(sr);
                        serviceRefToSD.put(sr, sd);
                    }
                    if (sd != null) continue;
                    for (ServiceDescription serviceDescription : appServiceMetadata.getServiceDescriptions()) {
                        if (!serviceDescription.getName().equals(serviceName)) continue;
                        sd = serviceDescription;
                        break;
                    }
                    if (sd != null) {
                        wiredServiceReferences.add(sr);
                        serviceRefToSD.put(sr, sd);
                        continue;
                    }
                    if (sr.isOptional()) continue;
                    throw new PaaSDeploymentException("unable to find the service [" + sr.getServiceName() + "] " + "for service-reference [ " + sr + " ]");
                }
            }
            logger.log(Level.FINEST, localStrings.getString("after.serviceref ", (Object)appServiceMetadata));
            Set<ServiceDescription> appSDs = appServiceMetadata.getServiceDescriptions();
            Set<ServiceReference> set = appServiceMetadata.getServiceReferences();
            for (ServiceReference sr : set) {
                if (wiredServiceReferences.contains(sr)) continue;
                String targetSD = sr.getServiceName();
                boolean serviceDescriptionExists = false;
                for (ServiceDescription sd : appSDs) {
                    if (!sd.getName().equals(targetSD)) continue;
                    serviceDescriptionExists = true;
                    break;
                }
                if (serviceDescriptionExists) continue;
                if (sr.getServiceName() != null) {
                    if (!sr.isOptional()) {
                        throw new PaaSDeploymentException("unable to find the service [" + sr.getServiceName() + "] " + "for service-reference [ " + sr + " ]");
                    }
                    logger.log(Level.INFO, "Unable to find the service [" + sr.getServiceName() + "] for " + "'optional' service-reference [" + sr + "]");
                    continue;
                }
                ServicePlugin matchingPlugin = this.getMatchingPlugin(sr, installedPlugins, pluginsToHandleSDs);
                if (matchingPlugin == null) continue;
                ServiceDescription matchingSDForServiceRef = null;
                if (pluginsToHandleSDs.values().contains(matchingPlugin)) {
                    for (Map.Entry entry : pluginsToHandleSDs.entrySet()) {
                        if (!((ServicePlugin)entry.getValue()).equals(matchingPlugin)) continue;
                        matchingSDForServiceRef = (ServiceDescription)entry.getKey();
                        break;
                    }
                } else {
                    matchingSDForServiceRef = matchingPlugin.getDefaultServiceDescription(appName, sr);
                    if (matchingSDForServiceRef == null) {
                        if (sr.isOptional()) continue;
                        throw new PaaSDeploymentException("unable to get service-description for service-reference [" + sr + "]");
                    }
                    matchingSDForServiceRef.setPlugin(matchingPlugin);
                    matchingSDForServiceRef.setServiceScope(ServiceScope.APPLICATION);
                    appServiceMetadata.addServiceDescription(matchingSDForServiceRef);
                    pluginsToHandleSDs.put(matchingSDForServiceRef, matchingPlugin);
                }
                serviceRefToSD.put(sr, matchingSDForServiceRef);
                sr.setServiceName(matchingSDForServiceRef.getName());
            }
            this.setPluginForSD(this.orchestrator, pluginsToHandleSDs, installedPlugins, appServiceMetadata);
            this.assertMetadataComplete(appSDs, set);
            String virtualClusterName = this.orchestrator.getVirtualClusterForApplication(appName, appServiceMetadata);
            for (ServiceDescription sd : appServiceMetadata.getServiceDescriptions()) {
                if (!ServiceScope.APPLICATION.equals((Object)sd.getServiceScope())) continue;
                sd.setVirtualClusterName(virtualClusterName);
            }
            this.appInfoRegistry.getPluginsToHandleSDs(appName).putAll(pluginsToHandleSDs);
            this.appInfoRegistry.getSRToSDMap(appName).putAll(serviceRefToSD);
            this.appInfoRegistry.addEffectivePlugins(appName, resolvedPlugins);
            logger.log(Level.INFO, "final.servicemetadata", appServiceMetadata);
            return appServiceMetadata;
        }
        catch (Exception e) {
            throw new PaaSDeploymentException(e);
        }
    }

    private ServicePlugin getMatchingPlugin(ServiceReference sr, Set<ServicePlugin> installedPlugins, Map<ServiceDescription, ServicePlugin> pluginsToHandleSDs) throws PaaSDeploymentException {
        ServicePlugin matchingPlugin = null;
        ArrayList<ServicePlugin> pluginsList = new ArrayList<ServicePlugin>();
        for (ServicePlugin plugin : installedPlugins) {
            if (!plugin.isReferenceTypeSupported(sr.getType())) continue;
            pluginsList.add(plugin);
        }
        if (pluginsList.size() == 1) {
            matchingPlugin = (ServicePlugin)pluginsList.get(0);
        } else {
            if (pluginsList.size() == 0) {
                if (!sr.isOptional()) {
                    throw new PaaSDeploymentException("No service-provisioning-engine available to handle service-ref [ " + sr + " ]");
                }
                logger.log(Level.INFO, "Unable to find a plugin to handle 'optional' service-reference [" + sr + "] requirement");
                return matchingPlugin;
            }
            matchingPlugin = this.orchestrator.getDefaultPluginForServiceRef(sr.getType());
        }
        if (matchingPlugin == null) {
            Collection<ServicePlugin> plugins = pluginsToHandleSDs.values();
            for (ServicePlugin plugin : plugins) {
                if (!plugin.isReferenceTypeSupported(sr.getType())) continue;
                matchingPlugin = plugin;
                break;
            }
        }
        return matchingPlugin;
    }

    private void setPluginForSD(ServiceOrchestratorImpl orchestrator, Map<ServiceDescription, ServicePlugin> pluginsToHandleSDs, Set<ServicePlugin> installedPlugins, ServiceMetadata appServiceMetadata) throws PaaSDeploymentException {
        for (ServiceDescription sd : appServiceMetadata.getServiceDescriptions()) {
            if (sd.getPlugin() != null) continue;
            ArrayList<ServicePlugin> matchingPluginsForSDs = new ArrayList<ServicePlugin>();
            for (ServicePlugin plugin : installedPlugins) {
                if (!plugin.getServiceType().toString().equals(sd.getServiceType())) continue;
                matchingPluginsForSDs.add(plugin);
            }
            if (matchingPluginsForSDs.size() == 1) {
                sd.setPlugin((ServicePlugin)matchingPluginsForSDs.get(0));
                pluginsToHandleSDs.put(sd, (ServicePlugin)matchingPluginsForSDs.get(0));
                continue;
            }
            if (matchingPluginsForSDs.size() == 0) {
                throw new PaaSDeploymentException("Unable to find a service-provisioning-engine that handlesservice-description [" + sd.getName() + "] of type [" + sd.getServiceType() + "]");
            }
            ServicePlugin plugin = orchestrator.getDefaultPlugin(matchingPluginsForSDs, sd.getServiceType());
            if (plugin != null) {
                sd.setPlugin(plugin);
                pluginsToHandleSDs.put(sd, plugin);
                continue;
            }
            throw new PaaSDeploymentException("Unable to resolve conflict among multiple service-provisioning-engines that handleservice-description [" + sd.getName() + "] of type [" + sd.getServiceType() + "]");
        }
    }

    private void assertMetadataComplete(Set<ServiceDescription> appSDs, Set<ServiceReference> appSRs) throws PaaSDeploymentException {
        for (ServiceReference sr : appSRs) {
            String targetSD = sr.getServiceName();
            boolean serviceDescriptionExists = false;
            for (ServiceDescription sd : appSDs) {
                if (!sd.getName().equals(targetSD)) continue;
                serviceDescriptionExists = true;
                break;
            }
            if (serviceDescriptionExists || sr.isOptional()) continue;
            throw new PaaSDeploymentException("A ServiceDescription is not available for ServiceReference : " + sr);
        }
    }

    private boolean serviceDescriptionExistsForPlugin(ServiceMetadata appServiceMetadata, ServicePlugin plugin) {
        for (ServiceDescription sd : appServiceMetadata.getServiceDescriptions()) {
            if (!sd.getServiceType().equalsIgnoreCase(plugin.getServiceType().toString())) continue;
            if (sd.getPlugin() != null) {
                return sd.getPlugin().equals(plugin);
            }
            return true;
        }
        return false;
    }
}

