/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.state;

import java.util.LinkedHashSet;
import java.util.Set;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.PaaSDeploymentException;
import org.glassfish.paas.orchestrator.config.SharedService;
import org.glassfish.paas.orchestrator.provisioning.ServiceScope;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.provisioning.cli.SharedServiceLazyInitializer;
import org.glassfish.paas.orchestrator.service.ServiceStatus;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.state.AbstractPaaSDeploymentState;
import org.glassfish.paas.orchestrator.state.SharedServiceUnregisterState;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class SharedServiceRegistrationState
extends AbstractPaaSDeploymentState {
    @Inject
    private ServiceUtil serviceUtil;
    @Inject
    private SharedServiceLazyInitializer sharedServiceLazyInitializer;

    public void handle(PaaSDeploymentContext context) throws PaaSDeploymentException {
        String appName = context.getAppName();
        ServiceMetadata serviceMetadata = this.appInfoRegistry.getServiceMetadata(appName);
        Set<ServiceDescription> serviceDescriptions = serviceMetadata.getServiceDescriptions();
        LinkedHashSet<ProvisionedService> sharedServices = new LinkedHashSet<ProvisionedService>();
        ProvisionedService provisionedService = null;
        for (ServiceDescription sd : serviceDescriptions) {
            if (!ServiceScope.SHARED.equals((Object)sd.getServiceScope())) continue;
            SharedService sharedService = (SharedService)this.serviceUtil.getService(sd.getName(), null);
            if (ServiceStatus.UNINITIALIZED.toString().equalsIgnoreCase(sharedService.getState())) {
                provisionedService = this.sharedServiceLazyInitializer.provisionService(sharedService.getServiceName());
                sharedServices.add(provisionedService);
                continue;
            }
            sharedServices.add(this.orchestrator.getSharedService(sd.getName()));
        }
        this.appInfoRegistry.registerProvisionedServices(appName, sharedServices);
    }

    public Class getRollbackState() {
        return SharedServiceUnregisterState.class;
    }
}

