/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.state;

import java.beans.PropertyVetoException;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.PaaSDeploymentException;
import org.glassfish.paas.orchestrator.PaaSDeploymentState;
import org.glassfish.paas.orchestrator.config.PaasApplication;
import org.glassfish.paas.orchestrator.config.PaasApplications;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.glassfish.paas.orchestrator.state.AbstractPaaSDeploymentState;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class UndeployState
extends AbstractPaaSDeploymentState {
    @Inject
    private CommandRunner commandRunner;

    @Override
    public void handle(PaaSDeploymentContext context) throws PaaSDeploymentException {
        final String appName = context.getAppName();
        boolean dasProvisioningEnabled = Boolean.getBoolean("org.glassfish.paas.provision-das");
        if (dasProvisioningEnabled) {
            Set<org.glassfish.paas.orchestrator.service.spi.Service> allServices = this.appInfoRegistry.getServices(appName);
            for (org.glassfish.paas.orchestrator.service.spi.Service service : allServices) {
                ServiceDescription sd = service.getServiceDescription();
                ServicePlugin plugin = sd.getPlugin();
                plugin.undeploy(context, service);
                try {
                    PaasApplications paasApplications = this.serviceUtil.getPaasApplications();
                    if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<PaasApplications>(){

                        public Object run(PaasApplications paasApplications) throws PropertyVetoException, TransactionFailure {
                            for (PaasApplication paasApplication : paasApplications.getPaasApplications()) {
                                if (!appName.equalsIgnoreCase(paasApplication.getAppName())) continue;
                                paasApplications.getPaasApplications().remove(paasApplication);
                                return paasApplication;
                            }
                            return null;
                        }
                    }, (ConfigBeanProxy)paasApplications) != null) continue;
                    logger.log(Level.SEVERE, "Error while persisting config during paas-deploy of application " + appName);
                }
                catch (TransactionFailure transactionFailure) {
                    logger.log(Level.SEVERE, "Error while persisting config during paas-undeploy of application " + appName + ". Exception : " + transactionFailure.getMessage());
                    return;
                }
            }
        } else {
            ParameterMap parameterMap = new ParameterMap();
            parameterMap.add((Object)"DEFAULT", (Object)appName);
            parameterMap.add((Object)"properties", (Object)"orchestrator.undeploy.call=true");
            ActionReport report = (ActionReport)this.habitat.getComponent(ActionReport.class);
            CommandRunner.CommandInvocation invocation = this.commandRunner.getCommandInvocation("undeploy", report);
            invocation.parameters(parameterMap).execute();
            Object[] args = new Object[]{appName, report.getMessage()};
            logger.log(Level.FINEST, "undeploying.app", args);
        }
    }

    @Override
    public Class<PaaSDeploymentState> getRollbackState() {
        return null;
    }
}

