/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.orchestrator.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.PaaSDeploymentException;
import org.glassfish.paas.orchestrator.PaaSDeploymentState;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceMetadata;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServiceChangeEvent;
import org.glassfish.paas.orchestrator.service.spi.ServicePlugin;
import org.glassfish.paas.orchestrator.state.AbstractPaaSDeploymentState;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class UnprovisioningState
extends AbstractPaaSDeploymentState {
    @Override
    public void handle(PaaSDeploymentContext context) throws PaaSDeploymentException {
        this.unprovisionServices(context);
    }

    private void unprovisionServices(final PaaSDeploymentContext context) throws PaaSDeploymentException {
        final String appName = context.getAppName();
        Collection<ServiceDescription> serviceDescriptionsToUnprovision = this.orchestrator.getServiceDescriptionsToUnprovision(appName);
        ArrayList unprovisioningFutures = new ArrayList();
        for (final ServiceDescription sd : serviceDescriptionsToUnprovision) {
            Future<?> future = ServiceUtil.getThreadPool().submit(new Runnable(){

                public void run() {
                    ServicePlugin chosenPlugin = sd.getPlugin();
                    Object[] args = new Object[]{sd, chosenPlugin};
                    AbstractPaaSDeploymentState.logger.log(Level.FINEST, AbstractPaaSDeploymentState.localStrings.getString("unprovision.service", args));
                    chosenPlugin.unprovisionService(sd, context);
                    Collection<ProvisionedService> servicesToUnprovision = UnprovisioningState.this.orchestrator.getServicesToUnprovision(appName);
                    for (ProvisionedService ps : servicesToUnprovision) {
                        if (!sd.getName().equals(ps.getName())) continue;
                        UnprovisioningState.this.serviceUtil.unregisterService(appName, ps);
                        UnprovisioningState.this.serviceUtil.fireServiceChangeEvent(ServiceChangeEvent.Type.DELETED, ps);
                    }
                }
            });
            unprovisioningFutures.add(future);
        }
        boolean failed = false;
        for (Future<?> future : unprovisioningFutures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                failed = true;
                logger.log(Level.WARNING, localStrings.getString("failure.while.unprovisioning.service"), e);
            }
            catch (ExecutionException e) {
                failed = true;
                logger.log(Level.WARNING, localStrings.getString("failure.while.unprovisioning.service"), e);
            }
        }
        ServiceMetadata appServiceMetadata = this.appInfoRegistry.getServiceMetadata(appName);
        String virtualClusterName = this.orchestrator.getVirtualClusterForApplication(appName, appServiceMetadata);
        if (virtualClusterName != null) {
            this.orchestrator.removeVirtualCluster(virtualClusterName);
        }
        this.appInfoRegistry.resetAppInfo(appName);
        if (failed) {
            throw new PaaSDeploymentException("Failure while unprovisioning services, refer server.log for more details");
        }
    }

    @Override
    public Class<PaaSDeploymentState> getRollbackState() {
        return null;
    }
}

