/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.tenantmanager;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.paas.tenantmanager.impl.SecurityStore;
import org.glassfish.paas.tenantmanager.impl.TenantManagerEx;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-tenant")
@Scoped(value=PerLookup.class)
@I18n(value="create.tenant")
@TargetType(value={CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.DAS})
public final class CreateTenantCommand
implements AdminCommand {
    @Inject
    private TenantManagerEx tm;
    @Param(primary=true)
    String tenantId;
    @Param(name="password", password=true)
    private String password;
    private ActionReport report;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateTenantCommand.class);
    private static final Logger logger = LogDomains.getLogger(CreateTenantCommand.class, (String)"javax.org.glassfish.paas");
    @Inject
    SecurityStore securityStore;

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (this.tenantId == null) {
            String msg = localStrings.getLocalString("NullTenantId", "TenantId cannot be null");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        logger.log(Level.INFO, "create.tenant.admin", this.tenantId + ".admin");
        this.securityStore.create(this.tenantId + ".admin", this.password.toCharArray());
        logger.log(Level.INFO, "create.tenant", this.tenantId);
        this.tm.create(this.tenantId, "admin");
    }
}

