/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.tenantmanager.impl;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.beans.PropertyChangeEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.paas.tenantmanager.impl.TenantDocument;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.IndentingXMLStreamWriter;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
public class TenantConfigListener
implements ConfigListener {
    @Inject
    protected Logger logger;
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TenantConfigListener.class);
    final XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        PropertyChangeEvent event = events[0];
        ConfigBeanProxy source = (ConfigBeanProxy)event.getSource();
        ConfigBean configBean = (ConfigBean)Dom.unwrap((ConfigBeanProxy)source);
        TenantDocument doc = (TenantDocument)configBean.document;
        try {
            this.save(doc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void save(TenantDocument doc) throws IOException {
        URI filePath;
        try {
            filePath = doc.getResource().toURI();
        }
        catch (URISyntaxException e1) {
            throw new IOException(e1);
        }
        File destination = new File(filePath);
        File f = File.createTempFile("tenant", ".xml", destination.getParentFile());
        if (!f.exists()) {
            throw new IOException(localStrings.getLocalString("NoTmpFile", "Cannot create temporary file when saving tenant.xml"));
        }
        XMLStreamWriter writer = null;
        FileOutputStream fos = new FileOutputStream(f);
        try {
            writer = this.xmlFactory.createXMLStreamWriter(new BufferedOutputStream(fos));
            IndentingXMLStreamWriter indentingXMLStreamWriter = new IndentingXMLStreamWriter(writer);
            doc.writeTo((XMLStreamWriter)indentingXMLStreamWriter);
            indentingXMLStreamWriter.close();
        }
        catch (XMLStreamException e) {
            String msg = localStrings.getLocalString("TmpFileNotSaved", "Configuration could not be saved to temporary file");
            this.logger.log(Level.SEVERE, msg, e);
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException e) {
                    this.logger.log(Level.SEVERE, localStrings.getLocalString("CloseFailed", "Cannot close configuration writer stream"), e);
                    throw new IOException(e.getMessage(), e);
                }
            }
            ((OutputStream)fos).close();
        }
        File backup = new File(destination.getParentFile(), "tenant.xml.bak");
        if (destination.exists() && backup.exists() && !backup.delete()) {
            String msg = localStrings.getLocalString("BackupDeleteFailed", "Could not delete previous backup file at {0}", new Object[]{backup.getAbsolutePath()});
            this.logger.severe(msg);
            throw new IOException(msg);
        }
        if (destination.exists() && !FileUtils.renameFile((File)destination, (File)backup)) {
            String msg = localStrings.getLocalString("TmpRenameFailed", "Could not rename {0} to {1}", new Object[]{destination.getAbsolutePath(), backup.getAbsolutePath()});
            this.logger.severe(msg);
            throw new IOException(msg);
        }
        if (!FileUtils.renameFile((File)f, (File)destination)) {
            String msg = localStrings.getLocalString("TmpRenameFailed", "Could not rename {0} to {1}", new Object[]{f.getAbsolutePath(), destination.getAbsolutePath()});
            if (!FileUtils.renameFile((File)backup, (File)destination)) {
                msg = msg + "\n" + localStrings.getLocalString("RenameFailed", "Could not rename backup to {0}", new Object[]{destination.getAbsolutePath()});
            }
            this.logger.severe(msg);
            throw new IOException(msg);
        }
    }
}

