/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.tenantmanager.impl;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.InhabitantsParser;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.paas.admin.CloudServices;
import org.glassfish.paas.tenantmanager.config.TenantManagerConfig;
import org.glassfish.paas.tenantmanager.entity.Tenant;
import org.glassfish.paas.tenantmanager.entity.TenantAdmin;
import org.glassfish.paas.tenantmanager.impl.TenantConfigBean;
import org.glassfish.paas.tenantmanager.impl.TenantConfigListener;
import org.glassfish.paas.tenantmanager.impl.TenantDocument;
import org.glassfish.paas.tenantmanager.impl.TenantManagerEx;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class TenantManagerImpl
implements TenantManagerEx {
    private ThreadLocal<String> currentTenant = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return null;
        }
    };
    private Map<String, Habitat> habitats = new HashMap<String, Habitat>();
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    ServerEnvironment env;
    @Inject
    private TenantConfigListener configListener;
    @Inject
    private Logger logger;
    @Inject
    private ModulesRegistry modulesRegistry;
    @Inject
    private ConfigSupport configSupport;

    @Override
    public <T> T get(Class<T> config) {
        String name = this.getCurrentTenant();
        return this.get(config, name);
    }

    @Override
    public <T extends ConfigBeanProxy> Object executeUpdate(final SingleConfigCode<T> code, T param) throws TransactionFailure {
        ConfigBeanProxy[] objects = new ConfigBeanProxy[]{param};
        return this.excuteUpdate(new ConfigCode(){

            public Object run(ConfigBeanProxy ... objects) throws PropertyVetoException, TransactionFailure {
                return code.run(objects[0]);
            }
        }, objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object excuteUpdate(ConfigCode configCode, ConfigBeanProxy ... objects) throws TransactionFailure {
        block5: {
            ConfigBeanProxy source = objects[0];
            TenantConfigBean configBean = (TenantConfigBean)Dom.unwrap((ConfigBeanProxy)source);
            ReentrantLock lock = configBean.getDocument().getLock();
            if (!lock.tryLock(ConfigSupport.lockTimeOutInSeconds, TimeUnit.SECONDS)) break block5;
            try {
                Object object = this.configSupport._apply(configCode, objects);
                lock.unlock();
                return object;
            }
            catch (Throwable throwable) {
                try {
                    lock.unlock();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        throw new TransactionFailure("Can't acquire global lock");
    }

    @Override
    public String getCurrentTenant() {
        String name = this.currentTenant.get();
        if (name == null) {
            throw new IllegalArgumentException("No current tenant set");
        }
        return name;
    }

    @Override
    public void setCurrentTenant(String name) {
        this.currentTenant.set(name);
    }

    private File getTenantFile(String name) {
        String dir = this.getTenantManagerConfig().getFileStore() + "/" + name;
        String filePath = dir + "/tenant.xml";
        return new File(filePath);
    }

    @Override
    public Tenant create(String name, final String adminUserName) {
        File tenantFile = this.getTenantFile(name);
        File tenantDir = tenantFile.getParentFile();
        if (tenantFile.exists()) {
            throw new IllegalArgumentException("Tenant " + name + " already exists");
        }
        try {
            boolean created = tenantDir.mkdirs();
            this.logger.fine("Tenant dir " + tenantDir.getPath() + " was " + (created ? "" : "not ") + "created");
            created = tenantFile.createNewFile();
            this.logger.fine("Tenant file " + tenantFile.getPath() + " was " + (created ? "" : "not ") + "created");
            FileWriter writer = new FileWriter(tenantFile);
            writer.write("<tenant name='" + name + "'/>");
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Tenant tenant = this.get(Tenant.class, name);
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Tenant>(){

                public Object run(Tenant tenant) throws TransactionFailure {
                    TenantAdmin tenantAdmin = (TenantAdmin)tenant.createChild(TenantAdmin.class);
                    tenantAdmin.setName(adminUserName);
                    tenant.setTenantAdmin(tenantAdmin);
                    return tenant;
                }
            }, (ConfigBeanProxy)tenant);
        }
        catch (TransactionFailure e) {
            e.printStackTrace();
        }
        return tenant;
    }

    @Override
    public void delete(String name) {
        this.habitats.remove(name);
        FileUtils.deleteFileMaybe((File)this.getTenantFile(name));
    }

    @Override
    public TenantManagerConfig getTenantManagerConfig() {
        CloudServices cs = (CloudServices)this.config.getExtensionByType(CloudServices.class);
        TenantManagerConfig tmc = (TenantManagerConfig)cs.getCloudServiceByType(TenantManagerConfig.class);
        return tmc;
    }

    private <T> T get(Class<T> config, String tenantName) {
        Habitat habitat = this.getHabitat(tenantName);
        return (T)habitat.getComponent(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Habitat getHabitat(String name) {
        if (!this.habitats.containsKey(name)) {
            Map<String, Habitat> map = this.habitats;
            synchronized (map) {
                if (!this.habitats.containsKey(name)) {
                    this.habitats.put(name, this.getNewHabitat(name));
                }
            }
        }
        return this.habitats.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Habitat getNewHabitat(String name) {
        Habitat habitat = this.modulesRegistry.newHabitat();
        InhabitantsParser parser = new InhabitantsParser(habitat);
        habitat.add((Inhabitant)new ExistingSingletonInhabitant(ModulesRegistry.class, (Object)this.modulesRegistry));
        ClassLoader oldCL = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                return cl;
            }
        });
        try {
            habitat = this.modulesRegistry.createHabitat("default", parser);
        }
        catch (Throwable throwable) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(oldCL){
                final /* synthetic */ ClassLoader val$oldCL;
                {
                    this.val$oldCL = classLoader;
                }

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(this.val$oldCL);
                    return null;
                }
            });
            throw throwable;
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        DomDocument<Dom> doc = this.populate(habitat, name);
        ((ConfigBean)doc.getRoot()).addListener((ConfigListener)this.configListener);
        return habitat;
    }

    private DomDocument<Dom> populate(Habitat habitat, String name) {
        String filePath = this.getTenantManagerConfig().getFileStore() + "/" + name + "/tenant.xml";
        ConfigParser parser = new ConfigParser(habitat);
        URL fileUrl = null;
        try {
            fileUrl = new File(filePath).toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            return parser.parse(fileUrl, (DomDocument)new TenantDocument(habitat, fileUrl));
        }
        catch (ComponentException e) {
            throw new IllegalArgumentException("Tenant '" + name + "' might be deleted", e);
        }
    }
}

