/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.generator.database;

import com.sun.jdo.spi.persistence.generator.database.JDBCInfo;
import com.sun.jdo.spi.persistence.generator.database.LogHelperDatabaseGenerator;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.glassfish.persistence.common.I18NHelper;
import org.glassfish.persistence.common.database.DBVendorTypeHelper;

public class MappingPolicy
implements Cloneable {
    static final char DOT = '.';
    private static final String CLASS_BASE = "{class-name}";
    private static final String FIELD_BASE = "{field-name}";
    private static final String RELATIONSHIP_BASE = "{relationship-field-name}";
    private static String REGEXP_DOT = "\\.";
    private static final String INDICATOR_JDBC_PREFIX = "jdbc";
    private static final String INDICATOR_MAXIMUM_LENGTH = "maximum-length";
    private static final String INDICATOR_TABLE_NAME = "table-name";
    private static final String INDICATOR_COLUMN_NAME = "column-name";
    private static final String INDICATOR_JOIN_TABLE_NAME = "join-table-name";
    private static final String INDICATOR_CONSTRAINT_NAME = "constraint-name";
    private static final String CLASS_PREFIX = "{class-name}.";
    private static final String RELATIONSHIP_PREFIX = "{class-name}.{relationship-field-name}.";
    private static final String DEFAULT_COLUMN_KEY = "{class-name}.{field-name}.column-name";
    private static final String DEFAULT_JOIN_TABLE_KEY = "{class-name}.{relationship-field-name}.join-table-name";
    private static final String DEFAULT_CONSTRAINT_KEY = "{class-name}.{relationship-field-name}.constraint-name";
    private static final String DEFAULT_TABLE_KEY = "{class-name}.table-name";
    private static final String TABLE_NAME_AS_CLASSNAME = "{className}";
    private static final String TABLE_NAME_UPPERCASE = "{className}".toUpperCase();
    private static final String TABLE_NAME_HASH_UPPERCASE = "{HASH-CLASSNAME}";
    private static final String COLUMN_NAME_AS_FIELDNAME = "{fieldName}";
    private static final String COLUMN_NAME_UPPERCASE = "{fieldName}".toUpperCase();
    private static final String JOIN_TABLE_NAME_UPPERCASE = "{CLASSNAMES}";
    private static final String CONSTRAINT_NAME_UPPERCASE = "{FIELDNAMES}";
    private static final String INDICATOR_SQL_FORMAT = "sql-format";
    private static final String STATEMENT_SEPARATOR_INDICATOR = "statementSeparator";
    private static final String CREATE_TABLE_START_INDICATOR = "createTableStart";
    private static final String CREATE_TABLE_END_INDICATOR = "createTableEnd";
    private static final String CREATE_INDEX_INDICATOR = "createIndex";
    private static final String DROP_TABLE_INDICATOR = "dropTable";
    private static final String ALTER_TABLE_ADD_CONSTRAINT_START_INDICATOR = "alterTableAddConstraintStart";
    private static final String ALTER_TABLE_DROP_CONSTRAINT_INDICATOR = "alterTableDropConstraint";
    private static final String PRIMARY_KEY_CONSTRAINT_INDICATOR = "primaryKeyConstraint";
    private static final String FOREIGN_KEY_CONSTRAINT_INDICATOR = "foreignKeyConstraint";
    private static final String COLUMN_NULLABILITY_INDICATOR = "columnNullability";
    private static final String LOB_LOGGING_INDICATOR = "LOBLogging";
    private static final String PK_PREFIX = "PK_";
    private static final String FK_PREFIX = "FK_";
    private static final String GLOBAL_NAMING_SPACE = "GLOBAL";
    public static final String USE_UNIQUE_TABLE_NAMES = "use-unique-table-names";
    private static final String RESERVED_WORDS = "reserved-words";
    private static final String RESERVED_WORD_UNRESERVER = "9";
    private static final int MAX_LEN_COUNTER = 4;
    private static final int MAX_LEN_RESERVED = 1;
    private static final String PROPERTY_FILE_DIR = "com/sun/jdo/spi/persistence/generator/database/";
    private static final String PROPERTY_FILE_EXT = ".properties";
    private static final Properties defaultProps = new Properties();
    private static final Map jdbcTypes = new HashMap();
    private static final Map jdbcTypeNames = new HashMap();
    private int counter = 0;
    private Map namespaces = new HashMap();
    private boolean uniqueTableName = false;
    private final Set reservedWords = new TreeSet();
    private static Set defaultReservedWords;
    private final Map dbJdbcInfoMap = new HashMap();
    private Map userJdbcInfoMap = new HashMap();
    private final Map sqlInfo = new HashMap();
    private int tableNameMaxLength;
    private int columnNameMaxLength;
    private int constraintNameMaxLength;
    private String statementSeparator;
    private String createTableStart;
    private String createTableEnd;
    private String createIndex;
    private String dropTable;
    private String alterTableAddConstraintStart;
    private String alterTableDropConstraint;
    private String primaryKeyConstraint;
    private String foreignKeyConstraint;
    private String columnNullability;
    private String lobLogging = "";
    private final Map namingPolicy = new HashMap();
    private static final Map instances;
    private static final Logger logger;
    private static final ResourceBundle messages;

    private MappingPolicy() throws IOException {
        this.load(MappingPolicy.getPropertyFileName(DBVendorTypeHelper.DEFAULT_DB), defaultProps, false);
        this.init(defaultProps);
        defaultReservedWords = this.reservedWords;
        instances.put(DBVendorTypeHelper.DEFAULT_DB, this);
        if (logger.isLoggable(300)) {
            logger.finest("new MappingPolicy():\n" + this.toString());
        }
    }

    private MappingPolicy(String databaseType) throws IOException {
        Properties mergedProp = new Properties(defaultProps);
        this.load(MappingPolicy.getPropertyFileName(databaseType), mergedProp, false);
        this.init(mergedProp);
        instances.put(databaseType, this);
        if (logger.isLoggable(300)) {
            logger.finest("new MappingPolicy(" + databaseType + "):\n" + this.toString());
        }
    }

    public static synchronized MappingPolicy getMappingPolicy(String databaseType) throws IOException {
        if (logger.isLoggable(500)) {
            logger.fine("get MappingPolicy" + databaseType);
        }
        MappingPolicy mappingPolicy = null;
        try {
            if (databaseType == null) {
                databaseType = DBVendorTypeHelper.DEFAULT_DB;
            }
            if ((mappingPolicy = (MappingPolicy)instances.get(databaseType)) == null) {
                mappingPolicy = new MappingPolicy(databaseType);
            }
            mappingPolicy = (MappingPolicy)mappingPolicy.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return mappingPolicy;
    }

    protected Object clone() throws CloneNotSupportedException {
        MappingPolicy mappingPolicyClone = (MappingPolicy)super.clone();
        mappingPolicyClone.namespaces = new HashMap();
        mappingPolicyClone.uniqueTableName = false;
        mappingPolicyClone.userJdbcInfoMap = new HashMap();
        return mappingPolicyClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void load(String resourceName, Properties properties, boolean override) throws IOException {
        if (logger.isLoggable(500)) {
            logger.fine("load resource:" + resourceName);
        }
        InputStream bin = null;
        InputStream in = null;
        try {
            if (override) {
                in = new FileInputStream(resourceName);
            } else {
                ClassLoader loader = MappingPolicy.class.getClassLoader();
                in = loader != null ? loader.getResourceAsStream(resourceName) : ClassLoader.getSystemResourceAsStream(resourceName);
                if (in == null) {
                    throw new IOException(I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_ResourceNotFound", (Object[])new Object[]{resourceName}));
                }
            }
            bin = new BufferedInputStream(in);
            properties.load(bin);
            if (logger.isLoggable(500)) {
                logger.fine("load " + resourceName + " successfuly");
            }
        }
        finally {
            try {
                bin.close();
            }
            catch (Exception exception) {}
        }
    }

    void resetCounter() {
        this.namespaces.clear();
        this.userJdbcInfoMap.clear();
        this.counter = 0;
    }

    public void setUserPolicy(Properties props) {
        if (null != props) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = props.getProperty(name);
                if (name.equals(USE_UNIQUE_TABLE_NAMES)) {
                    if (StringHelper.isEmpty((String)value)) continue;
                    this.uniqueTableName = Boolean.valueOf(value);
                    continue;
                }
                StringTokenizer nameParser = new StringTokenizer(name, String.valueOf('.'));
                String indicator = null;
                while (nameParser.hasMoreTokens()) {
                    indicator = nameParser.nextToken();
                }
                if (indicator.startsWith(INDICATOR_JDBC_PREFIX)) {
                    this.setJDBCInfoEntry(this.userJdbcInfoMap, name, value, indicator);
                    continue;
                }
                if (!logger.isLoggable(800)) continue;
                logger.info(I18NHelper.getMessage((ResourceBundle)messages, (String)"MSG_UnexpectedUserProp", (Object[])new Object[]{name, value}));
            }
        }
    }

    public void setUniqueTableName(boolean uniqueTableName) {
        this.uniqueTableName = uniqueTableName;
    }

    public String getSQLTypeName(int jdbcType) {
        String rc = null;
        Object o = this.sqlInfo.get(new Integer(jdbcType));
        rc = null != o ? (String)o : MappingPolicy.getJdbcTypeName(jdbcType);
        return rc;
    }

    public JDBCInfo getJDBCInfo(String fieldName, String fieldType) {
        JDBCInfo ji;
        JDBCInfo rc = null;
        if (logger.isLoggable(300)) {
            logger.finest("Entering MappingPolicy.getJDBCInfo: " + fieldName + ", " + fieldType);
        }
        if (null != fieldName && null != (rc = (JDBCInfo)this.userJdbcInfoMap.get(fieldName)) && !rc.isComplete()) {
            ji = null;
            if (rc.hasJdbcType()) {
                ji = this.getdbJDBCInfo(rc.getJdbcType());
            }
            if (null == ji) {
                ji = this.getdbJDBCInfo(fieldType);
            }
            rc.complete(ji);
        }
        if (null == rc) {
            rc = this.getdbJDBCInfo(fieldType);
        }
        ji = this.getdbJDBCInfo(rc.getJdbcType());
        rc.override(ji);
        if (logger.isLoggable(300)) {
            logger.finest("Leaving MappingPolicy.getJDBCInfo: " + fieldName + ", " + fieldType + " => " + rc);
        }
        return rc;
    }

    private JDBCInfo getdbJDBCInfo(int jdbcType) {
        String typename = MappingPolicy.getJdbcTypeName(jdbcType);
        return (JDBCInfo)this.dbJdbcInfoMap.get(typename);
    }

    private JDBCInfo getdbJDBCInfo(String fieldType) {
        JDBCInfo rc = (JDBCInfo)this.dbJdbcInfoMap.get(fieldType);
        if (null == rc) {
            rc = (JDBCInfo)this.dbJdbcInfoMap.get("BLOB");
        }
        return rc;
    }

    static Integer getJdbcType(String jdbcTypeName) {
        return (Integer)jdbcTypes.get(jdbcTypeName.toUpperCase());
    }

    public static String getOverrideForLength(String className, String fieldName) {
        return className + "." + fieldName + ".jdbc-maximum-length";
    }

    public static String getOverrideForNullability(String className, String fieldName) {
        return className + "." + fieldName + ".jdbc-nullable";
    }

    public static String getOverrideForPrecision(String className, String fieldName) {
        return className + "." + fieldName + ".jdbc-precision";
    }

    public static String getOverrideForScale(String className, String fieldName) {
        return className + "." + fieldName + ".jdbc-scale";
    }

    public static String getOverrideForType(String className, String fieldName) {
        return className + "." + fieldName + ".jdbc-type";
    }

    public static String getJdbcTypeName(int type) throws IllegalArgumentException {
        String rc = (String)jdbcTypeNames.get(new Integer(type));
        if (null == rc) {
            throw new IllegalArgumentException();
        }
        return rc;
    }

    public String getTableName(String name, String uniqueName) {
        StringBuffer key = new StringBuffer(name).append('.').append(INDICATOR_TABLE_NAME);
        String rc = (String)this.namingPolicy.get(key.toString());
        if (rc == null) {
            rc = (String)this.namingPolicy.get(DEFAULT_TABLE_KEY);
        }
        if (this.uniqueTableName) {
            rc = TABLE_NAME_HASH_UPPERCASE;
        }
        if (rc.equals(TABLE_NAME_UPPERCASE)) {
            rc = name.toUpperCase();
        } else if (rc.equals(TABLE_NAME_AS_CLASSNAME)) {
            rc = name;
        } else if (rc.equals(TABLE_NAME_HASH_UPPERCASE)) {
            rc = uniqueName.toUpperCase();
        }
        return this.getUniqueGlobalName(rc, this.tableNameMaxLength);
    }

    public String getColumnName(String className, String fieldName, String tableName) {
        StringBuffer key = new StringBuffer(className).append('.').append(fieldName).append('.').append(INDICATOR_COLUMN_NAME);
        String rc = (String)this.namingPolicy.get(key.toString());
        if (rc == null) {
            key = new StringBuffer(className).append('.').append(FIELD_BASE).append('.').append(INDICATOR_COLUMN_NAME);
            rc = (String)this.namingPolicy.get(key.toString());
        }
        if (rc == null) {
            rc = (String)this.namingPolicy.get(DEFAULT_COLUMN_KEY);
        }
        if (rc.equals(COLUMN_NAME_UPPERCASE)) {
            rc = fieldName.toUpperCase();
        } else if (rc.equals(COLUMN_NAME_AS_FIELDNAME)) {
            rc = fieldName;
        }
        return this.getUniqueLocalName(rc, tableName, this.columnNameMaxLength);
    }

    public String getConstraintColumnName(String tableName, String columnName) {
        return this.getUniqueLocalName(new StringBuffer(tableName).append('_').append(columnName).toString(), tableName, this.columnNameMaxLength);
    }

    public String getConstraintName(String relName, String uniqueId) {
        Object rc = (String)this.namingPolicy.get(DEFAULT_CONSTRAINT_KEY);
        if (((String)rc).equals(CONSTRAINT_NAME_UPPERCASE)) {
            rc = FK_PREFIX + relName.toUpperCase();
        }
        if (this.uniqueTableName) {
            rc = (String)rc + uniqueId;
        }
        rc = this.getUniqueGlobalName((String)rc, this.constraintNameMaxLength);
        if (logger.isLoggable(400)) {
            logger.finer("MappingPolicy.getConstraintName: " + relName + " -> " + (String)rc);
        }
        return rc;
    }

    public String getPrimaryKeyConstraintName(String tableName) {
        return this.getUniqueGlobalName(PK_PREFIX + tableName, this.constraintNameMaxLength);
    }

    public String getJoinTableName(String className1, String className2) {
        String rc = (String)this.namingPolicy.get(DEFAULT_JOIN_TABLE_KEY);
        if (rc.equals(JOIN_TABLE_NAME_UPPERCASE)) {
            rc = (className1 + className2).toUpperCase();
        }
        return this.getUniqueGlobalName(rc, this.tableNameMaxLength);
    }

    private String getUniqueLocalName(String colName, String tableName, int maxLen) {
        return this.getUniqueName(colName, tableName, maxLen);
    }

    private String getUniqueGlobalName(String name, int maxLen) {
        return this.getUniqueName(name, GLOBAL_NAMING_SPACE, maxLen);
    }

    private String getUniqueName(String name, String namespace, int maxLen) {
        HashSet<Object> names;
        Object nameUpper;
        Object rc = name;
        if (name.length() > (maxLen -= 4)) {
            rc = name.substring(0, maxLen);
        }
        if (defaultReservedWords.contains(nameUpper = ((String)rc).toUpperCase()) || this.reservedWords.contains(nameUpper)) {
            if (((String)rc).length() > --maxLen) {
                nameUpper = ((String)nameUpper).substring(0, maxLen);
                rc = ((String)rc).substring(0, maxLen);
            }
            nameUpper = (String)nameUpper + RESERVED_WORD_UNRESERVER;
            rc = (String)rc + RESERVED_WORD_UNRESERVER;
        }
        if ((names = (HashSet<Object>)this.namespaces.get(namespace)) == null) {
            names = new HashSet<Object>();
            names.add(nameUpper);
            this.namespaces.put(namespace, names);
        } else if (names.contains(nameUpper)) {
            ++this.counter;
            rc = (String)rc + (95 + this.counter);
        } else {
            names.add(nameUpper);
        }
        return rc;
    }

    String getStatementSeparator() {
        return this.statementSeparator;
    }

    String getCreateTableStart() {
        return this.createTableStart;
    }

    String getCreateTableEnd() {
        return this.createTableEnd;
    }

    String getCreateIndex() {
        return this.createIndex;
    }

    String getDropTable() {
        return this.dropTable;
    }

    String getAlterTableAddConstraintStart() {
        return this.alterTableAddConstraintStart;
    }

    String getAlterTableDropConstraint() {
        return this.alterTableDropConstraint;
    }

    String getPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    String getForeignKeyConstraint() {
        return this.foreignKeyConstraint;
    }

    String getColumnNullability() {
        return this.columnNullability;
    }

    String getLobLogging() {
        return this.lobLogging;
    }

    private void init(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            if (name.equals(RESERVED_WORDS)) {
                this.initReservedWords(value);
                continue;
            }
            String indicator = null;
            StringTokenizer nameParser = new StringTokenizer(name, String.valueOf('.'));
            while (nameParser.hasMoreTokens()) {
                indicator = nameParser.nextToken();
            }
            if (indicator.equals(INDICATOR_SQL_FORMAT)) {
                this.setSqlFormatEntry(name, value);
                continue;
            }
            if (indicator.startsWith(INDICATOR_JDBC_PREFIX)) {
                this.setJDBCInfoEntry(this.dbJdbcInfoMap, name, value, indicator);
                continue;
            }
            if (indicator.equals(INDICATOR_MAXIMUM_LENGTH)) {
                this.setLengthEntry(name, value);
                continue;
            }
            if (indicator.equals(INDICATOR_TABLE_NAME) || indicator.equals(INDICATOR_COLUMN_NAME) || indicator.equals(INDICATOR_JOIN_TABLE_NAME) || indicator.equals(INDICATOR_CONSTRAINT_NAME)) {
                this.setNamingEntry(name, value);
                continue;
            }
            this.setSQLInfoEntry(name, value);
        }
    }

    private void initReservedWords(String res) {
        StringTokenizer st = new StringTokenizer(res, ",");
        while (st.hasMoreTokens()) {
            this.reservedWords.add(st.nextToken().trim());
        }
    }

    private void setSqlFormatEntry(String name, String value) {
        if (value != null) {
            if (name.startsWith(STATEMENT_SEPARATOR_INDICATOR)) {
                this.statementSeparator = value;
            } else if (name.startsWith(CREATE_TABLE_START_INDICATOR)) {
                this.createTableStart = value;
            } else if (name.startsWith(CREATE_TABLE_END_INDICATOR)) {
                this.createTableEnd = value;
            } else if (name.startsWith(CREATE_INDEX_INDICATOR)) {
                this.createIndex = value;
            } else if (name.startsWith(DROP_TABLE_INDICATOR)) {
                this.dropTable = value;
            } else if (name.startsWith(ALTER_TABLE_ADD_CONSTRAINT_START_INDICATOR)) {
                this.alterTableAddConstraintStart = value;
            } else if (name.startsWith(ALTER_TABLE_DROP_CONSTRAINT_INDICATOR)) {
                this.alterTableDropConstraint = value;
            } else if (name.startsWith(PRIMARY_KEY_CONSTRAINT_INDICATOR)) {
                this.primaryKeyConstraint = value;
            } else if (name.startsWith(FOREIGN_KEY_CONSTRAINT_INDICATOR)) {
                this.foreignKeyConstraint = value;
            } else if (name.startsWith(COLUMN_NULLABILITY_INDICATOR)) {
                this.columnNullability = value;
            } else if (name.startsWith(LOB_LOGGING_INDICATOR)) {
                this.lobLogging = value;
            }
        }
    }

    private void setJDBCInfoEntry(Map jdbcInfoMap, String name, String value, String indicator) {
        if (value != null) {
            String fieldOrType = name;
            int i = name.indexOf("." + indicator);
            if (i > 0) {
                fieldOrType = name.substring(0, i);
            }
            JDBCInfo ji = (JDBCInfo)jdbcInfoMap.get(fieldOrType);
            try {
                if (null != ji) {
                    ji.setValue(value, indicator);
                } else {
                    ji = new JDBCInfo();
                    ji.setValue(value, indicator);
                    jdbcInfoMap.put(fieldOrType, ji);
                }
            }
            catch (JDBCInfo.IllegalJDBCTypeException ex) {
                String msg = I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_InvalidJDBCTypeName", (Object[])new Object[]{value, fieldOrType});
                logger.log(1000, msg);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    private void setLengthEntry(String name, String value) {
        if (value != null) {
            int val = Integer.parseInt(value);
            if (name.startsWith(INDICATOR_TABLE_NAME)) {
                this.tableNameMaxLength = val;
            } else if (name.startsWith(INDICATOR_COLUMN_NAME)) {
                this.columnNameMaxLength = val;
            } else if (name.startsWith(INDICATOR_CONSTRAINT_NAME)) {
                this.constraintNameMaxLength = val;
            }
        }
    }

    private void setNamingEntry(String name, String value) {
        this.namingPolicy.put(name, value);
    }

    private void setSQLInfoEntry(String name, String value) {
        this.sqlInfo.put(MappingPolicy.getJdbcType(name), value);
    }

    private static String getPropertyFileName(String databaseType) {
        return PROPERTY_FILE_DIR + databaseType + PROPERTY_FILE_EXT;
    }

    public String toString() {
        StringBuffer rc = new StringBuffer("statementSeparator=" + this.statementSeparator + "\ncreateTableStart=" + this.createTableStart + "\ncreateTableEnd=" + this.createTableEnd + "\ncreateIndex=" + this.createIndex + "\ndropTable=" + this.dropTable + "\nalterTableAddConstraintStart=" + this.alterTableAddConstraintStart + "\nalterTableDropConstraint=" + this.alterTableDropConstraint + "\nprimaryKeyConstraint=" + this.primaryKeyConstraint + "\nforeignKeyConstraint=" + this.foreignKeyConstraint + "\ncolumnNullability=" + this.columnNullability + "\nlobLogging=" + this.lobLogging + "\ntableNameMaxLength=" + this.tableNameMaxLength + "\ncolumnNameMaxLength=" + this.columnNameMaxLength + "\nconstraintNameMaxLength=" + this.constraintNameMaxLength + "\nuniqueTableName=" + this.uniqueTableName + "\ncounter=" + this.counter + "\n\n");
        rc.append("    dbJdbcInfoMap:\n").append(this.stringifyMap(this.dbJdbcInfoMap));
        rc.append("    userJdbcInfoMap:\n").append(this.stringifyMap(this.userJdbcInfoMap));
        rc.append("    sqlInfo:\n").append(this.stringifyMap(this.sqlInfo));
        rc.append("    namingPolicy:\n").append(this.stringifyMap(this.namingPolicy));
        rc.append("    namespaces:\n").append(this.stringifyMap(this.namespaces));
        rc.append("    reservedWords:\n").append(this.stringifySet(this.reservedWords));
        return rc.toString();
    }

    private String stringifyMap(Map m) {
        StringBuffer rc = new StringBuffer();
        for (Map.Entry e : m.entrySet()) {
            rc.append(e.getKey()).append("=").append(e.getValue()).append("\n");
        }
        return rc.toString();
    }

    private String stringifySet(Set s) {
        StringBuffer rc = new StringBuffer();
        int count = 0;
        Iterator i = s.iterator();
        while (i.hasNext()) {
            rc.append(i.next()).append(" ");
            if (count++ <= 6) continue;
            rc.append("\n");
            count = 0;
        }
        return rc.toString();
    }

    static {
        instances = new HashMap();
        logger = LogHelperDatabaseGenerator.getLogger();
        messages = I18NHelper.loadBundle(MappingPolicy.class);
        jdbcTypes.put("BIGINT", new Integer(-5));
        jdbcTypes.put("BIT", new Integer(-7));
        jdbcTypes.put("BLOB", new Integer(2004));
        jdbcTypes.put("CHAR", new Integer(1));
        jdbcTypes.put("CLOB", new Integer(2005));
        jdbcTypes.put("DATE", new Integer(91));
        jdbcTypes.put("DECIMAL", new Integer(3));
        jdbcTypes.put("DOUBLE", new Integer(8));
        jdbcTypes.put("INTEGER", new Integer(4));
        jdbcTypes.put("LONGVARBINARY", new Integer(-4));
        jdbcTypes.put("LONGVARCHAR", new Integer(-1));
        jdbcTypes.put("NULL", new Integer(0));
        jdbcTypes.put("REAL", new Integer(7));
        jdbcTypes.put("SMALLINT", new Integer(5));
        jdbcTypes.put("TIME", new Integer(92));
        jdbcTypes.put("TIMESTAMP", new Integer(93));
        jdbcTypes.put("TINYINT", new Integer(-6));
        jdbcTypes.put("VARCHAR", new Integer(12));
        jdbcTypeNames.put(new Integer(-5), "BIGINT");
        jdbcTypeNames.put(new Integer(-7), "BIT");
        jdbcTypeNames.put(new Integer(2004), "BLOB");
        jdbcTypeNames.put(new Integer(1), "CHAR");
        jdbcTypeNames.put(new Integer(2005), "CLOB");
        jdbcTypeNames.put(new Integer(91), "DATE");
        jdbcTypeNames.put(new Integer(3), "DECIMAL");
        jdbcTypeNames.put(new Integer(8), "DOUBLE");
        jdbcTypeNames.put(new Integer(4), "INTEGER");
        jdbcTypeNames.put(new Integer(-4), "LONGVARBINARY");
        jdbcTypeNames.put(new Integer(-1), "LONGVARCHAR");
        jdbcTypeNames.put(new Integer(0), "NULL");
        jdbcTypeNames.put(new Integer(7), "REAL");
        jdbcTypeNames.put(new Integer(5), "SMALLINT");
        jdbcTypeNames.put(new Integer(92), "TIME");
        jdbcTypeNames.put(new Integer(93), "TIMESTAMP");
        jdbcTypeNames.put(new Integer(-6), "TINYINT");
        jdbcTypeNames.put(new Integer(12), "VARCHAR");
        try {
            new MappingPolicy();
        }
        catch (Throwable ex) {
            logger.log(1000, I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_MappingPolicyNotFound", (Object[])new Object[]{DBVendorTypeHelper.DEFAULT_DB}));
        }
    }
}

