/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo.impl;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElementProperties;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public abstract class PersistenceElementImpl
implements PersistenceElement.Impl,
PersistenceElementProperties {
    PersistenceElement _element;
    private PropertyChangeSupport _support;
    private transient VetoableChangeSupport _vetoableSupport;
    private String _name;

    public PersistenceElementImpl() {
        this(null);
    }

    public PersistenceElementImpl(String name) {
        this._name = name;
    }

    @Override
    public void attachToElement(PersistenceElement element) {
        this._element = element;
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        if (this._support != null) {
            this._support.firePropertyChange(name, o, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this._support == null) {
            PersistenceElementImpl persistenceElementImpl = this;
            synchronized (persistenceElementImpl) {
                if (this._support == null) {
                    this._support = new PropertyChangeSupport(this._element);
                }
            }
        }
        this._support.addPropertyChangeListener(l);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(l);
        }
    }

    protected void fireVetoableChange(String name, Object o, Object n) throws PropertyVetoException {
        if (this._vetoableSupport != null) {
            this._vetoableSupport.fireVetoableChange(name, o, n);
        }
    }

    @Override
    public synchronized void addVetoableChangeListener(VetoableChangeListener l) {
        if (this._vetoableSupport == null) {
            this._vetoableSupport = new VetoableChangeSupport(this._element);
        }
        this._vetoableSupport.addVetoableChangeListener(l);
    }

    @Override
    public synchronized void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this._vetoableSupport != null) {
            this._vetoableSupport.removeVetoableChangeListener(l);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) throws ModelException {
        String old = this.getName();
        try {
            this.fireVetoableChange("name", old, name);
            this._name = name;
            this.firePropertyChange("name", old, name);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }
}

