/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.model.util;

import com.sun.jdo.api.persistence.mapping.ejb.AbstractNameMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.PersistenceDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationRoleDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationshipDescriptor;

public abstract class NameMapper
extends AbstractNameMapper {
    private EjbBundleDescriptorImpl _bundleDescriptor;
    private Map _generatedRelToInverseRelMap;
    private Map _relToInverseGeneratedRelMap;

    protected NameMapper(EjbBundleDescriptorImpl bundleDescriptor) {
        this._bundleDescriptor = bundleDescriptor;
        this.initGeneratedRelationshipMaps();
    }

    private void initGeneratedRelationshipMaps() {
        EjbBundleDescriptorImpl bundleDescriptor = this.getBundleDescriptor();
        Set relationships = bundleDescriptor.getRelationships();
        this._generatedRelToInverseRelMap = new HashMap();
        this._relToInverseGeneratedRelMap = new HashMap();
        if (relationships != null) {
            Iterator iterator = relationships.iterator();
            ArrayList<RelationshipDescriptor> generatedRels = new ArrayList<RelationshipDescriptor>();
            int counter = 0;
            while (iterator.hasNext()) {
                RelationshipDescriptor relationship = (RelationshipDescriptor)iterator.next();
                if (relationship.getSource().getCMRField() == null) {
                    generatedRels.add(relationship);
                }
                if (relationship.getSink().getCMRField() != null) continue;
                generatedRels.add(relationship);
            }
            for (RelationshipDescriptor relationship : generatedRels) {
                RelationRoleDescriptor source = relationship.getSource();
                String sourceEjbName = source.getOwner().getName();
                String sourceCMRField = source.getCMRField();
                boolean sourceIsNull = sourceCMRField == null;
                RelationRoleDescriptor sink = relationship.getSink();
                String sinkEjbName = sink.getOwner().getName();
                String ejbName = sourceIsNull ? sourceEjbName : sinkEjbName;
                String otherEjbName = sourceIsNull ? sinkEjbName : sourceEjbName;
                List<String> ejbField = Arrays.asList(otherEjbName, sourceIsNull ? sink.getCMRField() : sourceCMRField);
                PersistenceDescriptor pDescriptor = ((EjbCMPEntityDescriptor)bundleDescriptor.getEjbByName(ejbName)).getPersistenceDescriptor();
                List<String> generatedField = null;
                String uniqueName = null;
                while (this.hasField(pDescriptor, uniqueName = "thisRelationshipFieldWasGeneratedByTheNameMapper" + ++counter)) {
                }
                generatedField = Arrays.asList(ejbName, uniqueName);
                this._generatedRelToInverseRelMap.put(generatedField, ejbField);
                this._relToInverseGeneratedRelMap.put(ejbField, generatedField);
            }
        }
    }

    protected Map getGeneratedFieldsMap() {
        return this._generatedRelToInverseRelMap;
    }

    protected Map getInverseFieldsMap() {
        return this._relToInverseGeneratedRelMap;
    }

    private boolean hasField(PersistenceDescriptor persistenceDescriptor, String fieldName) {
        Class fieldType = null;
        try {
            fieldType = persistenceDescriptor.getTypeFor(fieldName);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        return fieldType != null;
    }

    public EjbBundleDescriptorImpl getBundleDescriptor() {
        return this._bundleDescriptor;
    }

    public abstract EjbCMPEntityDescriptor getDescriptorForEjbName(String var1);

    public int getKeyClassTypeForEjbName(String name) {
        String keyClass = this.getKeyClassForEjbName(name);
        if (!"java.lang.Object".equals(keyClass)) {
            EjbCMPEntityDescriptor descriptor = this.getDescriptorForEjbName(name);
            return descriptor.getPrimaryKeyFieldDesc() != null ? 2 : 1;
        }
        return 3;
    }

    public abstract String getEjbNameForAbstractSchema(String var1);

    public abstract String getConcreteBeanClassForEjbName(String var1);
}

